/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.ComputeDirectiveParser;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DispatchingDirectiveHolder;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class})
public class ProgramSet {
    private final PackDirectives packDirectives;
    private final ProgramSource shadow;
    private final ComputeSource[] shadowCompute;
    private final ProgramSource[] shadowcomp;
    private final ComputeSource[][] shadowCompCompute;
    private final ComputeSource[] setup;
    private final ProgramSource[] begin;
    private final ComputeSource[][] beginCompute;
    private final ProgramSource[] prepare;
    private final ComputeSource[][] prepareCompute;
    private final ProgramSource gbuffersBasic;
    private final ProgramSource gbuffersLine;
    private final ProgramSource gbuffersBeaconBeam;
    private final ProgramSource gbuffersTextured;
    private final ProgramSource gbuffersTexturedLit;
    private final ProgramSource gbuffersTerrain;
    private ProgramSource gbuffersDamagedBlock;
    private final ProgramSource gbuffersSkyBasic;
    private final ProgramSource gbuffersSkyTextured;
    private final ProgramSource gbuffersClouds;
    private final ProgramSource gbuffersWeather;
    private final ProgramSource gbuffersEntities;
    private final ProgramSource gbuffersEntitiesTrans;
    private final ProgramSource gbuffersEntitiesGlowing;
    private final ProgramSource gbuffersGlint;
    private final ProgramSource gbuffersEntityEyes;
    private final ProgramSource gbuffersBlock;
    private final ProgramSource gbuffersHand;
    private final ProgramSource[] deferred;
    private final ComputeSource[][] deferredCompute;
    private final ProgramSource gbuffersWater;
    private final ProgramSource gbuffersHandWater;
    private final ProgramSource[] composite;
    private final ComputeSource[][] compositeCompute;
    private final ProgramSource compositeFinal;
    private final ComputeSource[] finalCompute;
    private final ShaderPack pack;

    public ProgramSet(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack) {
        int i;
        this.packDirectives = new PackDirectives(PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS, shaderProperties);
        this.pack = pack;
        this.shadow = ProgramSet.readProgramSource(directory, sourceProvider, "shadow", this, shaderProperties, BlendModeOverride.OFF);
        this.shadowCompute = this.readComputeArray(directory, sourceProvider, "shadow");
        this.shadowcomp = this.readProgramArray(directory, sourceProvider, "shadowcomp", shaderProperties);
        this.shadowCompCompute = new ComputeSource[this.shadowcomp.length][];
        for (i = 0; i < this.shadowcomp.length; ++i) {
            this.shadowCompCompute[i] = this.readComputeArray(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$$init$$1(String.valueOf(i == 0 ? "" : Integer.valueOf(i))));
        }
        this.setup = this.readComputeProgramArray(directory, sourceProvider, "setup");
        this.begin = this.readProgramArray(directory, sourceProvider, "begin", shaderProperties);
        this.beginCompute = new ComputeSource[this.begin.length][];
        for (i = 0; i < this.begin.length; ++i) {
            this.beginCompute[i] = this.readComputeArray(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$$init$$2(String.valueOf(i == 0 ? "" : Integer.valueOf(i))));
        }
        this.prepare = this.readProgramArray(directory, sourceProvider, "prepare", shaderProperties);
        this.prepareCompute = new ComputeSource[this.prepare.length][];
        for (i = 0; i < this.prepare.length; ++i) {
            this.prepareCompute[i] = this.readComputeArray(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$$init$$3(String.valueOf(i == 0 ? "" : Integer.valueOf(i))));
        }
        this.gbuffersBasic = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_basic", this, shaderProperties);
        this.gbuffersLine = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_line", this, shaderProperties);
        this.gbuffersBeaconBeam = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_beaconbeam", this, shaderProperties);
        this.gbuffersTextured = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_textured", this, shaderProperties);
        this.gbuffersTexturedLit = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_textured_lit", this, shaderProperties);
        this.gbuffersTerrain = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_terrain", this, shaderProperties);
        this.gbuffersDamagedBlock = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_damagedblock", this, shaderProperties);
        this.gbuffersSkyBasic = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_skybasic", this, shaderProperties);
        this.gbuffersSkyTextured = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_skytextured", this, shaderProperties);
        this.gbuffersClouds = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_clouds", this, shaderProperties);
        this.gbuffersWeather = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_weather", this, shaderProperties);
        this.gbuffersEntities = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_entities", this, shaderProperties);
        this.gbuffersEntitiesTrans = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_entities_translucent", this, shaderProperties);
        this.gbuffersEntitiesGlowing = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_entities_glowing", this, shaderProperties);
        this.gbuffersGlint = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_armor_glint", this, shaderProperties);
        this.gbuffersEntityEyes = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_spidereyes", this, shaderProperties);
        this.gbuffersBlock = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_block", this, shaderProperties);
        this.gbuffersHand = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_hand", this, shaderProperties);
        this.deferred = this.readProgramArray(directory, sourceProvider, "deferred", shaderProperties);
        this.deferredCompute = new ComputeSource[this.deferred.length][];
        for (i = 0; i < this.deferred.length; ++i) {
            this.deferredCompute[i] = this.readComputeArray(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$$init$$4(String.valueOf(i == 0 ? "" : Integer.valueOf(i))));
        }
        this.gbuffersWater = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_water", this, shaderProperties);
        this.gbuffersHandWater = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_hand_water", this, shaderProperties);
        this.composite = this.readProgramArray(directory, sourceProvider, "composite", shaderProperties);
        this.compositeCompute = new ComputeSource[this.composite.length][];
        for (i = 0; i < this.deferred.length; ++i) {
            this.compositeCompute[i] = this.readComputeArray(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$$init$$5(String.valueOf(i == 0 ? "" : Integer.valueOf(i))));
        }
        this.compositeFinal = ProgramSet.readProgramSource(directory, sourceProvider, "final", this, shaderProperties);
        this.finalCompute = this.readComputeArray(directory, sourceProvider, "final");
        this.locateDirectives();
        if (!this.gbuffersDamagedBlock.isValid()) {
            ProgramSet.first(this.getGbuffersTerrain(), this.getGbuffersTexturedLit(), this.getGbuffersTextured(), this.getGbuffersBasic()).ifPresent(src -> {
                ProgramDirectives overrideDirectives = src.getDirectives().withOverriddenDrawBuffers(new int[]{0});
                this.gbuffersDamagedBlock = src.withDirectiveOverride(overrideDirectives);
            });
        }
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    private ProgramSource[] readProgramArray(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String name, ShaderProperties shaderProperties) {
        ProgramSource[] programs = new ProgramSource[99];
        for (int i = 0; i < programs.length; ++i) {
            String suffix = i == 0 ? "" : Integer.toString(i);
            programs[i] = ProgramSet.readProgramSource(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$readProgramArray$1(name, suffix), this, shaderProperties);
        }
        return programs;
    }

    private ComputeSource[] readComputeProgramArray(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String name) {
        ComputeSource[] programs = new ComputeSource[100];
        for (int i = 0; i < programs.length; ++i) {
            String suffix = i == 0 ? "" : Integer.toString(i);
            programs[i] = ProgramSet.readComputeSource(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$readProgramArray$1(name, suffix), this);
        }
        return programs;
    }

    private ComputeSource[] readComputeArray(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String name) {
        ComputeSource[] programs = new ComputeSource[27];
        programs[0] = ProgramSet.readComputeSource(directory, sourceProvider, name, this);
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            String suffix = ProgramSet.jvmdowngrader$concat$readComputeArray$1(c);
            programs[c - 96] = ProgramSet.readComputeSource(directory, sourceProvider, ProgramSet.jvmdowngrader$concat$readProgramArray$1(name, suffix), this);
            if (programs[c - 96] == null) break;
        }
        return programs;
    }

    private void locateDirectives() {
        ArrayList<ProgramSource> programs = new ArrayList<ProgramSource>();
        ArrayList<Object> computes = new ArrayList<Object>();
        programs.add(this.shadow);
        programs.addAll(Arrays.asList(this.shadowcomp));
        programs.addAll(Arrays.asList(this.begin));
        programs.addAll(Arrays.asList(this.prepare));
        programs.addAll(Arrays.asList(this.gbuffersBasic, this.gbuffersBeaconBeam, this.gbuffersTextured, this.gbuffersTexturedLit, this.gbuffersTerrain, this.gbuffersDamagedBlock, this.gbuffersSkyBasic, this.gbuffersSkyTextured, this.gbuffersClouds, this.gbuffersWeather, this.gbuffersEntities, this.gbuffersEntitiesTrans, this.gbuffersEntitiesGlowing, this.gbuffersGlint, this.gbuffersEntityEyes, this.gbuffersBlock, this.gbuffersHand));
        for (ComputeSource[] computeSourceArray : this.compositeCompute) {
            computes.addAll(Arrays.asList(computeSourceArray));
        }
        for (ComputeSource[] computeSourceArray : this.deferredCompute) {
            computes.addAll(Arrays.asList(computeSourceArray));
        }
        for (ComputeSource[] computeSourceArray : this.prepareCompute) {
            computes.addAll(Arrays.asList(computeSourceArray));
        }
        for (ComputeSource[] computeSourceArray : this.shadowCompCompute) {
            computes.addAll(Arrays.asList(computeSourceArray));
        }
        for (ComputeSource[] computeSourceArray : this.setup) {
            if (computeSourceArray == null) continue;
            computes.add(computeSourceArray);
        }
        for (ComputeSource[] computeSourceArray : this.beginCompute) {
            computes.addAll(Arrays.asList(computeSourceArray));
        }
        Collections.addAll(computes, this.finalCompute);
        Collections.addAll(computes, this.shadowCompute);
        for (ComputeSource computeSource : computes) {
            if (computeSource == null) continue;
            computeSource.getSource().map(ConstDirectiveParser::findDirectives).ifPresent(constDirectives -> {
                for (ConstDirectiveParser.ConstDirective directive : constDirectives) {
                    if (directive.getType() == ConstDirectiveParser.Type.IVEC3 && directive.getKey().equals("workGroups")) {
                        ComputeDirectiveParser.setComputeWorkGroups(source, directive);
                        continue;
                    }
                    if (directive.getType() != ConstDirectiveParser.Type.VEC2 || !directive.getKey().equals("workGroupsRender")) continue;
                    ComputeDirectiveParser.setComputeWorkGroupsRelative(source, directive);
                }
            });
        }
        programs.addAll(Arrays.asList(this.deferred));
        programs.add(this.gbuffersWater);
        programs.add(this.gbuffersHandWater);
        programs.addAll(Arrays.asList(this.composite));
        programs.add(this.compositeFinal);
        DispatchingDirectiveHolder packDirectiveHolder = new DispatchingDirectiveHolder();
        this.packDirectives.acceptDirectivesFrom(packDirectiveHolder);
        for (ProgramSource source : programs) {
            if (source == null) continue;
            source.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(directives -> {
                for (ConstDirectiveParser.ConstDirective directive : directives) {
                    packDirectiveHolder.processDirective(directive);
                }
            });
        }
        this.packDirectives.getRenderTargetDirectives().getRenderTargetSettings().forEach((index, settings) -> Iris.logger.debug(ProgramSet.jvmdowngrader$concat$lambda$locateDirectives$2$1(index, String.valueOf(settings))));
    }

    public Optional<ProgramSource> getShadow() {
        return this.shadow.requireValid();
    }

    public ProgramSource[] getShadowComposite() {
        return this.shadowcomp;
    }

    public ComputeSource[] getSetup() {
        return this.setup;
    }

    public ProgramSource[] getBegin() {
        return this.begin;
    }

    public ComputeSource[][] getBeginCompute() {
        return this.beginCompute;
    }

    public ProgramSource[] getPrepare() {
        return this.prepare;
    }

    public Optional<ProgramSource> getGbuffersBasic() {
        return this.gbuffersBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBeaconBeam() {
        return this.gbuffersBeaconBeam.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTextured() {
        return this.gbuffersTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTexturedLit() {
        return this.gbuffersTexturedLit.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTerrain() {
        return this.gbuffersTerrain.requireValid();
    }

    public Optional<ProgramSource> getGbuffersDamagedBlock() {
        return this.gbuffersDamagedBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyBasic() {
        return this.gbuffersSkyBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyTextured() {
        return this.gbuffersSkyTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersClouds() {
        return this.gbuffersClouds.requireValid();
    }

    public Optional<ProgramSource> getGbuffersWeather() {
        return this.gbuffersWeather.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntities() {
        return this.gbuffersEntities.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntitiesTrans() {
        return this.gbuffersEntitiesTrans.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntitiesGlowing() {
        return this.gbuffersEntitiesGlowing.requireValid();
    }

    public Optional<ProgramSource> getGbuffersGlint() {
        return this.gbuffersGlint.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntityEyes() {
        return this.gbuffersEntityEyes.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBlock() {
        return this.gbuffersBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHand() {
        return this.gbuffersHand.requireValid();
    }

    public Optional<ProgramSource> get(ProgramId programId) {
        Optional<ProgramSource> optional;
        switch (programId) {
            case Shadow: {
                optional = this.getShadow();
                break;
            }
            case Basic: {
                optional = this.getGbuffersBasic();
                break;
            }
            case Line: {
                optional = this.gbuffersLine.requireValid();
                break;
            }
            case Textured: {
                optional = this.getGbuffersTextured();
                break;
            }
            case TexturedLit: {
                optional = this.getGbuffersTexturedLit();
                break;
            }
            case SkyBasic: {
                optional = this.getGbuffersSkyBasic();
                break;
            }
            case SkyTextured: {
                optional = this.getGbuffersSkyTextured();
                break;
            }
            case Clouds: {
                optional = this.getGbuffersClouds();
                break;
            }
            case Terrain: {
                optional = this.getGbuffersTerrain();
                break;
            }
            case DamagedBlock: {
                optional = this.getGbuffersDamagedBlock();
                break;
            }
            case Block: {
                optional = this.getGbuffersBlock();
                break;
            }
            case BeaconBeam: {
                optional = this.getGbuffersBeaconBeam();
                break;
            }
            case Entities: {
                optional = this.getGbuffersEntities();
                break;
            }
            case EntitiesTrans: {
                optional = this.getGbuffersEntitiesTrans();
                break;
            }
            case EntitiesGlowing: {
                optional = this.getGbuffersEntitiesGlowing();
                break;
            }
            case ArmorGlint: {
                optional = this.getGbuffersGlint();
                break;
            }
            case SpiderEyes: {
                optional = this.getGbuffersEntityEyes();
                break;
            }
            case Hand: {
                optional = this.getGbuffersHand();
                break;
            }
            case Weather: {
                optional = this.getGbuffersWeather();
                break;
            }
            case Water: {
                optional = this.getGbuffersWater();
                break;
            }
            case HandWater: {
                optional = this.getGbuffersHandWater();
                break;
            }
            case Final: {
                optional = this.getCompositeFinal();
                break;
            }
            default: {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    public ProgramSource[] getDeferred() {
        return this.deferred;
    }

    public Optional<ProgramSource> getGbuffersWater() {
        return this.gbuffersWater.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHandWater() {
        return this.gbuffersHandWater.requireValid();
    }

    public ProgramSource[] getComposite() {
        return this.composite;
    }

    public Optional<ProgramSource> getCompositeFinal() {
        return this.compositeFinal.requireValid();
    }

    public ComputeSource[] getShadowCompute() {
        return this.shadowCompute;
    }

    public ComputeSource[][] getShadowCompCompute() {
        return this.shadowCompCompute;
    }

    public ComputeSource[][] getPrepareCompute() {
        return this.prepareCompute;
    }

    public ComputeSource[][] getDeferredCompute() {
        return this.deferredCompute;
    }

    public ComputeSource[][] getCompositeCompute() {
        return this.compositeCompute;
    }

    public ComputeSource[] getFinalCompute() {
        return this.finalCompute;
    }

    public PackDirectives getPackDirectives() {
        return this.packDirectives;
    }

    public ShaderPack getPack() {
        return this.pack;
    }

    private static ProgramSource readProgramSource(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String program, ProgramSet programSet, ShaderProperties properties) {
        return ProgramSet.readProgramSource(directory, sourceProvider, program, programSet, properties, null);
    }

    private static ProgramSource readProgramSource(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String program, ProgramSet programSet, ShaderProperties properties, BlendModeOverride defaultBlendModeOverride) {
        AbsolutePackPath vertexPath = directory.resolve(ProgramSet.jvmdowngrader$concat$readProgramSource$1(program));
        String vertexSource = sourceProvider.apply(vertexPath);
        AbsolutePackPath geometryPath = directory.resolve(ProgramSet.jvmdowngrader$concat$readProgramSource$2(program));
        String geometrySource = sourceProvider.apply(geometryPath);
        String tessControlSource = null;
        String tessEvalSource = null;
        if (programSet.pack.hasFeature(FeatureFlags.TESSELLATION_SHADERS)) {
            AbsolutePackPath tessControlPath = directory.resolve(ProgramSet.jvmdowngrader$concat$readProgramSource$3(program));
            tessControlSource = sourceProvider.apply(tessControlPath);
            AbsolutePackPath tessEvalPath = directory.resolve(ProgramSet.jvmdowngrader$concat$readProgramSource$4(program));
            tessEvalSource = sourceProvider.apply(tessEvalPath);
        }
        AbsolutePackPath fragmentPath = directory.resolve(ProgramSet.jvmdowngrader$concat$readProgramSource$5(program));
        String fragmentSource = sourceProvider.apply(fragmentPath);
        return new ProgramSource(program, vertexSource, geometrySource, tessControlSource, tessEvalSource, fragmentSource, programSet, properties, defaultBlendModeOverride);
    }

    private static ComputeSource readComputeSource(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String program, ProgramSet programSet) {
        AbsolutePackPath computePath = directory.resolve(ProgramSet.jvmdowngrader$concat$readComputeSource$1(program));
        String computeSource = sourceProvider.apply(computePath);
        if (computeSource == null) {
            return null;
        }
        return new ComputeSource(program, computeSource, programSet);
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return "shadowcomp" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$2(String string) {
        return "begin" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$3(String string) {
        return "prepare" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$4(String string) {
        return "deferred" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$5(String string) {
        return "composite" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramArray$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readComputeArray$1(char c) {
        return "_" + c;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramSource$1(String string) {
        return string + ".vsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramSource$2(String string) {
        return string + ".gsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramSource$3(String string) {
        return string + ".tcs";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramSource$4(String string) {
        return string + ".tes";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProgramSource$5(String string) {
        return string + ".fsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readComputeSource$1(String string) {
        return string + ".csh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$locateDirectives$2$1(Integer n, String string) {
        return "Render target settings for colortex" + n + ": " + string;
    }
}

