/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.ShadowCullState;
import org.joml.Vector4f;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={DepthSamplingSettings.class, SamplingSettings.class})
public class PackShadowDirectives {
    public static final int MAX_SHADOW_COLOR_BUFFERS_IRIS = 8;
    public static final int MAX_SHADOW_COLOR_BUFFERS_OF = 2;
    private final OptionalBoolean shadowEnabled;
    private int resolution;
    private Float fov;
    private float distance;
    private float voxelDistance;
    private float distanceRenderMul;
    private float entityShadowDistanceMul;
    private boolean explicitRenderDistance;
    private float intervalSize;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final ShadowCullState cullingState;
    private final ImmutableList<DepthSamplingSettings> depthSamplingSettings;
    private final ImmutableList<SamplingSettings> colorSamplingSettings;

    public PackShadowDirectives(ShaderProperties properties) {
        this.resolution = 1024;
        this.fov = null;
        this.distance = 160.0f;
        this.voxelDistance = 0.0f;
        this.distanceRenderMul = -1.0f;
        this.entityShadowDistanceMul = 1.0f;
        this.explicitRenderDistance = false;
        this.intervalSize = 2.0f;
        this.shouldRenderTerrain = properties.getShadowTerrain().orElse(true);
        this.shouldRenderTranslucent = properties.getShadowTranslucent().orElse(true);
        this.shouldRenderEntities = properties.getShadowEntities().orElse(true);
        this.shouldRenderPlayer = properties.getShadowPlayer().orElse(false);
        this.shouldRenderBlockEntities = properties.getShadowBlockEntities().orElse(true);
        this.cullingState = properties.getShadowCulling();
        this.shadowEnabled = properties.getShadowEnabled();
        this.depthSamplingSettings = ImmutableList.of((Object)new DepthSamplingSettings(), (Object)new DepthSamplingSettings());
        ImmutableList.Builder colorSamplingSettings = ImmutableList.builder();
        for (int i = 0; i < 8; ++i) {
            colorSamplingSettings.add((Object)new SamplingSettings());
        }
        this.colorSamplingSettings = colorSamplingSettings.build();
    }

    public PackShadowDirectives(PackShadowDirectives shadowDirectives) {
        this.resolution = shadowDirectives.resolution;
        this.fov = shadowDirectives.fov;
        this.distance = shadowDirectives.distance;
        this.voxelDistance = shadowDirectives.voxelDistance;
        this.distanceRenderMul = shadowDirectives.distanceRenderMul;
        this.entityShadowDistanceMul = shadowDirectives.entityShadowDistanceMul;
        this.explicitRenderDistance = shadowDirectives.explicitRenderDistance;
        this.intervalSize = shadowDirectives.intervalSize;
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain;
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent;
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities;
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer;
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities;
        this.cullingState = shadowDirectives.cullingState;
        this.depthSamplingSettings = shadowDirectives.depthSamplingSettings;
        this.colorSamplingSettings = shadowDirectives.colorSamplingSettings;
        this.shadowEnabled = shadowDirectives.shadowEnabled;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Float getFov() {
        return this.fov;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getVoxelDistance() {
        return this.voxelDistance;
    }

    public float getDistanceRenderMul() {
        return this.distanceRenderMul;
    }

    public float getEntityShadowDistanceMul() {
        return this.entityShadowDistanceMul;
    }

    public boolean isDistanceRenderMulExplicit() {
        return this.explicitRenderDistance;
    }

    public float getIntervalSize() {
        return this.intervalSize;
    }

    public boolean shouldRenderTerrain() {
        return this.shouldRenderTerrain;
    }

    public boolean shouldRenderTranslucent() {
        return this.shouldRenderTranslucent;
    }

    public boolean shouldRenderEntities() {
        return this.shouldRenderEntities;
    }

    public boolean shouldRenderPlayer() {
        return this.shouldRenderPlayer;
    }

    public boolean shouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public OptionalBoolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public ImmutableList<DepthSamplingSettings> getDepthSamplingSettings() {
        return this.depthSamplingSettings;
    }

    public ImmutableList<SamplingSettings> getColorSamplingSettings() {
        return this.colorSamplingSettings;
    }

    public void acceptDirectives(DirectiveHolder directives) {
        directives.acceptCommentIntDirective("SHADOWRES", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptConstIntDirective("shadowMapResolution", resolution -> {
            this.resolution = resolution;
        });
        directives.acceptCommentFloatDirective("SHADOWFOV", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptConstFloatDirective("shadowMapFov", fov -> {
            this.fov = Float.valueOf(fov);
        });
        directives.acceptCommentFloatDirective("SHADOWHPL", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("shadowDistance", distance -> {
            this.distance = distance;
        });
        directives.acceptConstFloatDirective("entityShadowDistanceMul", distance -> {
            this.entityShadowDistanceMul = distance;
        });
        directives.acceptConstFloatDirective("shadowDistanceRenderMul", distanceRenderMul -> {
            this.distanceRenderMul = distanceRenderMul;
            this.explicitRenderDistance = true;
        });
        directives.acceptConstFloatDirective("shadowIntervalSize", intervalSize -> {
            this.intervalSize = intervalSize;
        });
        directives.acceptConstFloatDirective("voxelDistance", distance -> {
            this.voxelDistance = distance;
        });
        PackShadowDirectives.acceptHardwareFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptDepthMipmapSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorMipmapSettings(directives, this.colorSamplingSettings);
        PackShadowDirectives.acceptDepthFilteringSettings(directives, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorFilteringSettings(directives, this.colorSamplingSettings);
        this.acceptBufferDirectives(directives, this.colorSamplingSettings);
    }

    private static void acceptHardwareFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("shadowHardwareFiltering", hardwareFiltering -> {
            for (DepthSamplingSettings samplerSettings : samplers) {
                samplerSettings.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackShadowDirectives$DepthSamplingSettings$setHardwareFiltering(hardwareFiltering);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = PackShadowDirectives.jvmdowngrader$concat$acceptHardwareFilteringSettings$1(i);
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::jvmdowngrader$handleNest$net_coderbot_iris_shaderpack_PackShadowDirectives$DepthSamplingSettings$setHardwareFiltering);
        }
    }

    private static void acceptDepthMipmapSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexMipmap", ((DepthSamplingSettings)samplers.get(0))::setMipmap);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = PackShadowDirectives.jvmdowngrader$concat$acceptDepthMipmapSettings$1(i);
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptColorMipmapSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        directives.acceptConstBooleanDirective("generateShadowColorMipmap", mipmap -> {
            for (SamplingSettings samplerSettings : samplers) {
                samplerSettings.setMipmap(mipmap);
            }
        });
        for (int i = 0; i < samplers.size(); ++i) {
            String name = PackShadowDirectives.jvmdowngrader$concat$acceptColorMipmapSettings$1(i);
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
            name = PackShadowDirectives.jvmdowngrader$concat$acceptColorMipmapSettings$2(i);
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setMipmap);
        }
    }

    private static void acceptDepthFilteringSettings(DirectiveHolder directives, ImmutableList<DepthSamplingSettings> samplers) {
        if (samplers.size() >= 1) {
            directives.acceptConstBooleanDirective("shadowtexNearest", ((DepthSamplingSettings)samplers.get(0))::setNearest);
        }
        for (int i = 0; i < samplers.size(); ++i) {
            String name = PackShadowDirectives.jvmdowngrader$concat$acceptDepthFilteringSettings$1(i);
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
            name = PackShadowDirectives.jvmdowngrader$concat$acceptDepthFilteringSettings$2(i);
            directives.acceptConstBooleanDirective(name, ((DepthSamplingSettings)samplers.get(i))::setNearest);
        }
    }

    private static void acceptColorFilteringSettings(DirectiveHolder directives, ImmutableList<SamplingSettings> samplers) {
        for (int i = 0; i < samplers.size(); ++i) {
            String name = PackShadowDirectives.jvmdowngrader$concat$acceptColorFilteringSettings$1(i);
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = PackShadowDirectives.jvmdowngrader$concat$acceptColorFilteringSettings$2(i);
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
            name = PackShadowDirectives.jvmdowngrader$concat$acceptColorFilteringSettings$3(i);
            directives.acceptConstBooleanDirective(name, ((SamplingSettings)samplers.get(i))::setNearest);
        }
    }

    private void acceptBufferDirectives(DirectiveHolder directives, ImmutableList<SamplingSettings> settings) {
        int i = 0;
        while (i < settings.size()) {
            String bufferName = PackShadowDirectives.jvmdowngrader$concat$acceptBufferDirectives$1(i);
            int finalI = i++;
            directives.acceptConstStringDirective(PackShadowDirectives.jvmdowngrader$concat$acceptBufferDirectives$1(bufferName), format -> {
                Optional<InternalTextureFormat> internalFormat = InternalTextureFormat.fromString(format);
                if (internalFormat.isPresent()) {
                    ((SamplingSettings)settings.get(finalI)).setFormat(internalFormat.get());
                } else {
                    Iris.logger.warn(PackShadowDirectives.jvmdowngrader$concat$lambda$acceptBufferDirectives$0$1(format, bufferName));
                }
            });
            directives.acceptConstBooleanDirective(PackShadowDirectives.jvmdowngrader$concat$acceptBufferDirectives$2(bufferName), shouldClear -> ((SamplingSettings)settings.get(finalI)).setClear(shouldClear));
            directives.acceptConstVec4Directive(PackShadowDirectives.jvmdowngrader$concat$acceptBufferDirectives$3(bufferName), clearColor -> ((SamplingSettings)settings.get(finalI)).setClearColor((Vector4f)clearColor));
        }
    }

    public String toString() {
        return PackShadowDirectives.jvmdowngrader$concat$toString$1(this.resolution, this.fov, this.distance, this.distanceRenderMul, this.entityShadowDistanceMul, this.intervalSize, String.valueOf(this.depthSamplingSettings), String.valueOf(this.colorSamplingSettings));
    }

    @Generated
    public ShadowCullState getCullingState() {
        return this.cullingState;
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptHardwareFilteringSettings$1(int n) {
        return "shadowHardwareFiltering" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptDepthMipmapSettings$1(int n) {
        return "shadowtex" + n + "Mipmap";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptColorMipmapSettings$1(int n) {
        return "shadowcolor" + n + "Mipmap";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptColorMipmapSettings$2(int n) {
        return "shadowColor" + n + "Mipmap";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptDepthFilteringSettings$1(int n) {
        return "shadowtex" + n + "Nearest";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptDepthFilteringSettings$2(int n) {
        return "shadow" + n + "MinMagNearest";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptColorFilteringSettings$1(int n) {
        return "shadowcolor" + n + "Nearest";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptColorFilteringSettings$2(int n) {
        return "shadowColor" + n + "Nearest";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptColorFilteringSettings$3(int n) {
        return "shadowColor" + n + "MinMagNearest";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$1(int n) {
        return "shadowcolor" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$1(String string) {
        return string + "Format";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$2(String string) {
        return string + "Clear";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$3(String string) {
        return string + "ClearColor";
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(int n, Float f, float f2, float f3, float f4, float f5, String string, String string2) {
        return "PackShadowDirectives{resolution=" + n + ", fov=" + f + ", distance=" + f2 + ", distanceRenderMul=" + f3 + ", entityDistanceRenderMul=" + f4 + ", intervalSize=" + f5 + ", depthSamplingSettings=" + string + ", colorSamplingSettings=" + string2 + "}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$acceptBufferDirectives$0$1(String string, String string2) {
        return "Unrecognized internal texture format " + string + " specified for " + string2 + "Format, ignoring.";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=PackShadowDirectives.class)
    public static class DepthSamplingSettings
    extends SamplingSettings {
        private boolean hardwareFiltering = false;

        private void setHardwareFiltering(boolean hardwareFiltering) {
            this.hardwareFiltering = hardwareFiltering;
        }

        public boolean getHardwareFiltering() {
            return this.hardwareFiltering;
        }

        @Override
        public String toString() {
            return DepthSamplingSettings.jvmdowngrader$concat$toString$1(this.getMipmap(), this.getNearest(), this.hardwareFiltering);
        }

        public /* synthetic */ void jvmdowngrader$handleNest$net_coderbot_iris_shaderpack_PackShadowDirectives$DepthSamplingSettings$setHardwareFiltering(boolean bl) {
            this.setHardwareFiltering(bl);
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackShadowDirectives$DepthSamplingSettings$setHardwareFiltering(boolean bl) {
            this.setHardwareFiltering(bl);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(boolean bl, boolean bl2, boolean bl3) {
            return "DepthSamplingSettings{mipmap=" + bl + ", nearest=" + bl2 + ", hardwareFiltering=" + bl3 + "}";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=PackShadowDirectives.class)
    public static class SamplingSettings {
        private boolean mipmap = false;
        private boolean nearest = false;
        private boolean clear = true;
        private Vector4f clearColor = new Vector4f(1.0f);
        private InternalTextureFormat format = InternalTextureFormat.RGBA;

        protected void setMipmap(boolean mipmap) {
            this.mipmap = mipmap;
        }

        protected void setNearest(boolean nearest) {
            this.nearest = nearest;
        }

        protected void setClear(boolean clear) {
            this.clear = clear;
        }

        protected void setClearColor(Vector4f clearColor) {
            this.clearColor = clearColor;
        }

        protected void setFormat(InternalTextureFormat format) {
            this.format = format;
        }

        public boolean getMipmap() {
            return this.mipmap;
        }

        public boolean getNearest() {
            return this.nearest;
        }

        public boolean getClear() {
            return this.clear;
        }

        public Vector4f getClearColor() {
            return this.clearColor;
        }

        public InternalTextureFormat getFormat() {
            return this.format;
        }

        public String toString() {
            return SamplingSettings.jvmdowngrader$concat$toString$1(this.mipmap, this.nearest, this.clear, String.valueOf(this.clearColor), this.format.name());
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(boolean bl, boolean bl2, boolean bl3, String string, String string2) {
            return "SamplingSettings{mipmap=" + bl + ", nearest=" + bl2 + ", clear=" + bl3 + ", clearColor=" + string + ", format=" + string2 + "}";
        }
    }
}

