/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import org.joml.Vector4f;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={RenderTargetSettings.class})
public class PackRenderTargetDirectives {
    public static final ImmutableList<String> LEGACY_RENDER_TARGETS = ImmutableList.of((Object)"gcolor", (Object)"gdepth", (Object)"gnormal", (Object)"composite", (Object)"gaux1", (Object)"gaux2", (Object)"gaux3", (Object)"gaux4");
    public static final Set<Integer> BASELINE_SUPPORTED_RENDER_TARGETS;
    private final Int2ObjectMap<RenderTargetSettings> renderTargetSettings = new Int2ObjectOpenHashMap();

    PackRenderTargetDirectives(Set<Integer> supportedRenderTargets) {
        supportedRenderTargets.forEach(index -> this.renderTargetSettings.put(index.intValue(), (Object)new RenderTargetSettings()));
    }

    public IntList getBuffersToBeCleared() {
        IntArrayList buffersToBeCleared = new IntArrayList();
        this.renderTargetSettings.forEach((arg_0, arg_1) -> PackRenderTargetDirectives.lambda$getBuffersToBeCleared$0((IntList)buffersToBeCleared, arg_0, arg_1));
        return buffersToBeCleared;
    }

    public Map<Integer, RenderTargetSettings> getRenderTargetSettings() {
        return Collections.unmodifiableMap(this.renderTargetSettings);
    }

    public void acceptDirectives(DirectiveHolder directives) {
        Optional.ofNullable((RenderTargetSettings)this.renderTargetSettings.get(7)).ifPresent(colortex7 -> directives.acceptCommentStringDirective("GAUX4FORMAT", format -> {
            if ("RGBA32F".equals(format)) {
                colortex7.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(InternalTextureFormat.RGBA32F);
            } else if ("RGB32F".equals(format)) {
                colortex7.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(InternalTextureFormat.RGB32F);
            } else if ("RGB16".equals(format)) {
                colortex7.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(InternalTextureFormat.RGB16);
            } else {
                Iris.logger.warn(PackRenderTargetDirectives.jvmdowngrader$concat$lambda$acceptDirectives$1$1(format, format, format));
            }
        }));
        Optional.ofNullable((RenderTargetSettings)this.renderTargetSettings.get(1)).ifPresent(gdepth -> directives.acceptUniformDirective("gdepth", () -> {
            if (gdepth.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$get$requestedFormat() == InternalTextureFormat.RGBA) {
                gdepth.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(InternalTextureFormat.RGBA32F);
            }
        }));
        this.renderTargetSettings.forEach((index, settings) -> {
            this.acceptBufferDirectives(directives, (RenderTargetSettings)settings, PackRenderTargetDirectives.jvmdowngrader$concat$lambda$acceptDirectives$4$1(index));
            if (index < LEGACY_RENDER_TARGETS.size()) {
                this.acceptBufferDirectives(directives, (RenderTargetSettings)settings, (String)LEGACY_RENDER_TARGETS.get(index.intValue()));
            }
        });
    }

    private void acceptBufferDirectives(DirectiveHolder directives, RenderTargetSettings settings, String bufferName) {
        directives.acceptConstStringDirective(PackRenderTargetDirectives.jvmdowngrader$concat$acceptBufferDirectives$1(bufferName), format -> {
            Optional<InternalTextureFormat> internalFormat = InternalTextureFormat.fromString(format);
            if (internalFormat.isPresent()) {
                settings.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(internalFormat.get());
            } else {
                Iris.logger.warn(PackRenderTargetDirectives.jvmdowngrader$concat$lambda$acceptBufferDirectives$0$1(format, bufferName));
            }
        });
        directives.acceptConstBooleanDirective(PackRenderTargetDirectives.jvmdowngrader$concat$acceptBufferDirectives$2(bufferName), shouldClear -> settings.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$clear(shouldClear));
        directives.acceptConstVec4Directive(PackRenderTargetDirectives.jvmdowngrader$concat$acceptBufferDirectives$3(bufferName), clearColor -> settings.jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$clearColor((Vector4f)clearColor));
    }

    private static /* synthetic */ void lambda$getBuffersToBeCleared$0(IntList buffersToBeCleared, Integer index, RenderTargetSettings settings) {
        if (settings.shouldClear()) {
            buffersToBeCleared.add(index.intValue());
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < 16; ++i) {
            builder.add((Object)i);
        }
        BASELINE_SUPPORTED_RENDER_TARGETS = builder.build();
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$1(String string) {
        return string + "Format";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$2(String string) {
        return string + "Clear";
    }

    private static /* synthetic */ String jvmdowngrader$concat$acceptBufferDirectives$3(String string) {
        return string + "ClearColor";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$acceptBufferDirectives$0$1(String string, String string2) {
        return "Unrecognized internal texture format " + string + " specified for " + string2 + "Format, ignoring.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$acceptDirectives$4$1(Integer n) {
        return "colortex" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$acceptDirectives$1$1(String string, String string2, String string3) {
        return "Ignoring GAUX4FORMAT directive /* GAUX4FORMAT:" + string + "*/ because " + string2 + " must be RGBA32F, RGB32F, or RGB16. Use `const int colortex7Format = " + string3 + ";` + instead.";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=PackRenderTargetDirectives.class)
    public static final class RenderTargetSettings {
        private InternalTextureFormat requestedFormat = InternalTextureFormat.RGBA;
        private boolean clear = true;
        private Vector4f clearColor = null;

        public InternalTextureFormat getInternalFormat() {
            return this.requestedFormat;
        }

        public boolean shouldClear() {
            return this.clear;
        }

        public Optional<Vector4f> getClearColor() {
            return Optional.ofNullable(this.clearColor);
        }

        public String toString() {
            return RenderTargetSettings.jvmdowngrader$concat$toString$1(String.valueOf((Object)this.requestedFormat), this.clear, String.valueOf(this.clearColor));
        }

        public /* synthetic */ InternalTextureFormat jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$get$requestedFormat() {
            return this.requestedFormat;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$requestedFormat(InternalTextureFormat internalTextureFormat) {
            this.requestedFormat = internalTextureFormat;
        }

        public /* synthetic */ boolean jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$get$clear() {
            return this.clear;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$clear(boolean bl) {
            this.clear = bl;
        }

        public /* synthetic */ Vector4f jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$get$clearColor() {
            return this.clearColor;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_shaderpack_PackRenderTargetDirectives$RenderTargetSettings$set$clearColor(Vector4f vector4f) {
            this.clearColor = vector4f;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, String string2) {
            return "RenderTargetSettings{requestedFormat=" + string + ", clear=" + bl + ", clearColor=" + string2 + "}";
        }
    }
}

