/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LegacyIdMap;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.BlockRenderType;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IdMap {
    private final Object2IntMap<NamespacedId> itemIdMap;
    private final Object2IntMap<NamespacedId> entityIdMap;
    private Int2ObjectMap<List<BlockEntry>> blockPropertiesMap;
    private Map<NamespacedId, BlockRenderType> blockRenderTypeMap;

    IdMap(Path shaderPath, ShaderPackOptions shaderPackOptions, Iterable<StringPair> environmentDefines) {
        this.itemIdMap = IdMap.loadProperties(shaderPath, "item.properties", shaderPackOptions, environmentDefines).map(IdMap::parseItemIdMap).orElse(Object2IntMaps.emptyMap());
        this.entityIdMap = IdMap.loadProperties(shaderPath, "entity.properties", shaderPackOptions, environmentDefines).map(IdMap::parseEntityIdMap).orElse(Object2IntMaps.emptyMap());
        IdMap.loadProperties(shaderPath, "block.properties", shaderPackOptions, environmentDefines).ifPresent(blockProperties -> {
            this.blockPropertiesMap = IdMap.parseBlockMap(blockProperties, "block.", "block.properties");
            this.blockRenderTypeMap = IdMap.parseRenderTypeMap(blockProperties, "layer.", "block.properties");
        });
        if (this.blockPropertiesMap == null) {
            this.blockPropertiesMap = new Int2ObjectOpenHashMap();
            LegacyIdMap.addLegacyValues(this.blockPropertiesMap);
        }
        if (this.blockRenderTypeMap == null) {
            this.blockRenderTypeMap = Collections.emptyMap();
        }
    }

    private static Optional<Properties> loadProperties(Path shaderPath, String name, ShaderPackOptions shaderPackOptions, Iterable<StringPair> environmentDefines) {
        String fileContents = IdMap.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        String processed = PropertiesPreprocessor.preprocessSource(fileContents, shaderPackOptions, environmentDefines);
        StringReader propertiesReader = new StringReader(processed);
        OrderBackedProperties properties = new OrderBackedProperties();
        try {
            properties.load(propertiesReader);
        }
        catch (IOException e) {
            Iris.logger.error(IdMap.jvmdowngrader$concat$loadProperties$1(name, String.valueOf(shaderPath)), e);
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug(IdMap.jvmdowngrader$concat$readProperties$1(name));
            return null;
        }
        catch (IOException e) {
            Iris.logger.error(IdMap.jvmdowngrader$concat$readProperties$2(name), e);
            return null;
        }
    }

    private static Object2IntMap<NamespacedId> parseItemIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "item.", "item.properties");
    }

    private static Object2IntMap<NamespacedId> parseEntityIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "entity.", "entity.properties");
    }

    static List<String> parseIdentifierList(String value, String fileName, String key) {
        if (value.indexOf(34) == -1) {
            String[] parts = value.split("\\s+");
            ArrayList<String> result = new ArrayList<String>(parts.length);
            for (String part : parts) {
                if (part.isEmpty()) continue;
                result.add(part);
            }
            return result;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (escaped) {
                current.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (Character.isWhitespace(c) && !inQuotes) {
                if (current.length() <= 0) continue;
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (inQuotes) {
            Iris.logger.warn(IdMap.jvmdowngrader$concat$parseIdentifierList$1(fileName, key));
        }
        if (escaped) {
            Iris.logger.warn(IdMap.jvmdowngrader$concat$parseIdentifierList$2(fileName, key));
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    private static Object2IntMap<NamespacedId> parseIdMap(Properties properties, String keyPrefix, String fileName) {
        Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
        idMap.defaultReturnValue(-1);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseIdMap$0(keyPrefix, fileName, (Object2IntMap)idMap, arg_0, arg_1)));
        return Object2IntMaps.unmodifiable((Object2IntMap)idMap);
    }

    private static Int2ObjectMap<List<BlockEntry>> parseBlockMap(Properties properties, String keyPrefix, String fileName) {
        Int2ObjectOpenHashMap entriesById = new Int2ObjectOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseBlockMap$0(keyPrefix, fileName, (Int2ObjectMap)entriesById, arg_0, arg_1)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)entriesById);
    }

    private static Map<NamespacedId, BlockRenderType> parseRenderTypeMap(Properties properties, String keyPrefix, String fileName) {
        HashMap<NamespacedId, BlockRenderType> overrides = new HashMap<NamespacedId, BlockRenderType>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            if (!key.startsWith(keyPrefix)) {
                return;
            }
            String keyWithoutPrefix = key.substring(keyPrefix.length());
            BlockRenderType renderType = BlockRenderType.fromString(keyWithoutPrefix).orElse(null);
            if (renderType == null) {
                Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseRenderTypeMap$0$1(fileName, key));
                return;
            }
            for (String part : IdMap.parseIdentifierList(value, fileName, key)) {
                overrides.put(new NamespacedId(part), renderType);
            }
        }));
        return overrides;
    }

    public Int2ObjectMap<List<BlockEntry>> getBlockProperties() {
        return this.blockPropertiesMap;
    }

    public Object2IntFunction<NamespacedId> getItemIdMap() {
        return this.itemIdMap;
    }

    public Object2IntFunction<NamespacedId> getEntityIdMap() {
        return this.entityIdMap;
    }

    public Map<NamespacedId, BlockRenderType> getBlockRenderTypeMap() {
        return this.blockRenderTypeMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdMap idMap = (IdMap)o;
        return Objects.equals(this.itemIdMap, idMap.itemIdMap) && Objects.equals(this.entityIdMap, idMap.entityIdMap) && Objects.equals(this.blockPropertiesMap, idMap.blockPropertiesMap) && Objects.equals(this.blockRenderTypeMap, idMap.blockRenderTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.itemIdMap, this.entityIdMap, this.blockPropertiesMap, this.blockRenderTypeMap);
    }

    private static /* synthetic */ void lambda$parseBlockMap$0(String keyPrefix, String fileName, Int2ObjectMap entriesById, Object keyObject, Object valueObject) {
        int intId;
        String key = (String)keyObject;
        StringBuilder value = new StringBuilder((String)valueObject);
        if (!key.startsWith(keyPrefix)) {
            return;
        }
        try {
            intId = Integer.parseInt(key.substring(keyPrefix.length()));
        }
        catch (NumberFormatException e) {
            Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseBlockMap$0$1(fileName, key));
            return;
        }
        ArrayList<BlockEntry> entries = new ArrayList<BlockEntry>();
        if (value.toString().contains("minecraft:leaves")) {
            ArrayList leaves = OreDictionary.getOres((String)"treeLeaves");
            for (ItemStack leaf : leaves) {
                if (!(leaf.func_77973_b() instanceof ItemBlock)) continue;
                Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseBlockMap$0$1(Item.field_150901_e.func_148750_c((Object)leaf.func_77973_b())));
                value.append(" ").append(Item.field_150901_e.func_148750_c((Object)leaf.func_77973_b()));
            }
        }
        for (String part : IdMap.parseIdentifierList(value.toString(), fileName, key)) {
            if (part.isEmpty()) continue;
            try {
                entries.add(BlockEntry.parse(part));
            }
            catch (Exception e) {
                Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseBlockMap$0$2(fileName, key), e);
            }
        }
        entriesById.put(intId, Collections.unmodifiableList(entries));
    }

    private static /* synthetic */ void lambda$parseIdMap$0(String keyPrefix, String fileName, Object2IntMap idMap, Object keyObject, Object valueObject) {
        int intId;
        String key = (String)keyObject;
        String value = (String)valueObject;
        if (!key.startsWith(keyPrefix)) {
            return;
        }
        try {
            intId = Integer.parseInt(key.substring(keyPrefix.length()));
        }
        catch (NumberFormatException e) {
            Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseBlockMap$0$1(fileName, key));
            return;
        }
        for (String part : IdMap.parseIdentifierList(value, fileName, key)) {
            if (part.contains("=")) {
                Iris.logger.warn(IdMap.jvmdowngrader$concat$lambda$parseIdMap$0$1(fileName, key, part));
                continue;
            }
            idMap.put((Object)new NamespacedId(part), intId);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadProperties$1(String string, String string2) {
        return "Error loading " + string + " at " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProperties$1(String string) {
        return "An " + string + " file was not found in the current shaderpack";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readProperties$2(String string) {
        return "An IOException occurred reading " + string + " from the current shaderpack";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseIdentifierList$1(String string, String string2) {
        return string + " [" + string2 + "]: Unclosed quote";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseIdentifierList$2(String string, String string2) {
        return string + " [" + string2 + "]: Trailing backslash";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseRenderTypeMap$0$1(String string, String string2) {
        return "Failed to parse line in " + string + ": invalid block render type: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseBlockMap$0$1(String string, String string2) {
        return "Failed to parse line in " + string + ": invalid key " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseBlockMap$0$1(String string) {
        return "Found leaf " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseBlockMap$0$2(String string, String string2) {
        return "Unexpected error while parsing an entry from " + string + " for the key " + string2 + ":";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseIdMap$0$1(String string, String string2, String string3) {
        return "Failed to parse an ResourceLocation in " + string + " for the key " + string2 + ": state properties are currently not supported: " + string3;
    }
}

