/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.Optional;
import lombok.Generated;
import net.coderbot.iris.shaderpack.IndirectPointer;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderProperties;
import org.joml.Vector2f;
import org.joml.Vector3i;

public class ComputeSource {
    private final String name;
    private final String source;
    private final ProgramSet parent;
    private final IndirectPointer indirectPointer;
    private Vector3i workGroups;
    private Vector2f workGroupRelative;

    public ComputeSource(String name, String source, ProgramSet parent) {
        this(name, source, parent, null);
    }

    public ComputeSource(String name, String source, ProgramSet parent, ShaderProperties properties) {
        this.name = name;
        this.source = source;
        this.parent = parent;
        this.indirectPointer = properties != null ? (IndirectPointer)((Object)properties.getIndirectPointers().get((Object)name)) : null;
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public boolean isValid() {
        return this.source != null;
    }

    public Optional<ComputeSource> requireValid() {
        if (this.isValid()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ProgramSet getParent() {
        return this.parent;
    }

    @Generated
    public IndirectPointer getIndirectPointer() {
        return this.indirectPointer;
    }

    @Generated
    public Vector3i getWorkGroups() {
        return this.workGroups;
    }

    @Generated
    public void setWorkGroups(Vector3i workGroups) {
        this.workGroups = workGroups;
    }

    @Generated
    public Vector2f getWorkGroupRelative() {
        return this.workGroupRelative;
    }

    @Generated
    public void setWorkGroupRelative(Vector2f workGroupRelative) {
        this.workGroupRelative = workGroupRelative;
    }
}

