/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import org.joml.Vector2f;
import org.joml.Vector3i;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ComputeDirectiveParser {
    public static void setComputeWorkGroups(ComputeSource source, ConstDirectiveParser.ConstDirective directive) {
        String ivec3Args;
        if (!directive.getValue().startsWith("ivec3")) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroups$1(String.valueOf(directive)));
        }
        if (!(ivec3Args = directive.getValue().substring("ivec3".length()).trim()).startsWith("(") || !ivec3Args.endsWith(")")) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroups$1(String.valueOf(directive)));
        }
        ivec3Args = ivec3Args.substring(1, ivec3Args.length() - 1);
        String[] parts = ivec3Args.split(",");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (parts.length != 3) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroups$1(String.valueOf(directive), parts.length));
        }
        try {
            source.setWorkGroups(new Vector3i(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        }
        catch (NumberFormatException e) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroups$2(String.valueOf(directive)), e);
        }
    }

    public static void setComputeWorkGroupsRelative(ComputeSource source, ConstDirectiveParser.ConstDirective directive) {
        String vec2Args;
        if (!directive.getValue().startsWith("vec2")) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroupsRelative$1(String.valueOf(directive)));
        }
        if (!(vec2Args = directive.getValue().substring("vec2".length()).trim()).startsWith("(") || !vec2Args.endsWith(")")) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroupsRelative$1(String.valueOf(directive)));
        }
        vec2Args = vec2Args.substring(1, vec2Args.length() - 1);
        String[] parts = vec2Args.split(",");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (parts.length != 2) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroupsRelative$1(String.valueOf(directive), parts.length));
        }
        try {
            source.setWorkGroupRelative(new Vector2f(Float.parseFloat(parts[0]), Float.parseFloat(parts[1])));
        }
        catch (NumberFormatException e) {
            Iris.logger.error(ComputeDirectiveParser.jvmdowngrader$concat$setComputeWorkGroups$2(String.valueOf(directive)), e);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$setComputeWorkGroups$1(String string) {
        return "Failed to process " + string + ": value was not a valid ivec3 constructor";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setComputeWorkGroups$1(String string, int n) {
        return "Failed to process " + string + ": expected 3 arguments to a ivec3 constructor, got " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setComputeWorkGroups$2(String string) {
        return "Failed to process " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setComputeWorkGroupsRelative$1(String string) {
        return "Failed to process " + string + ": value was not a valid vec2 constructor";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setComputeWorkGroupsRelative$1(String string, int n) {
        return "Failed to process " + string + ": expected 2 arguments to a vec2 constructor, got " + n;
    }
}

