/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.ShaderTransformer;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.CeleritasTerrainParameters;
import net.coderbot.iris.pipeline.transform.parameter.ComputeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.pipeline.transform.parameter.TextureStageParameters;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={CacheKey.class, 1.class})
public class TransformPatcher {
    private static final int MAX_CACHE_ENTRIES = 400;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache = new LinkedHashMap<CacheKey, Map<PatchShaderType, String>>(401, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, Map<PatchShaderType, String>> eldest) {
            return this.size() > 400;
        }
    };
    private static final boolean useCache = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<PatchShaderType, String> transform(String vertex, String geometry, String tessControl, String tessEval, String fragment, Parameters parameters) {
        if (vertex == null && geometry == null && tessControl == null && tessEval == null && fragment == null) {
            return null;
        }
        CacheKey key = null;
        Map<PatchShaderType, String> result = null;
        key = new CacheKey(parameters, vertex, geometry, tessControl, tessEval, fragment);
        Map<CacheKey, Map<PatchShaderType, String>> map = cache;
        synchronized (map) {
            result = cache.get(key);
        }
        if (result == null) {
            result = ShaderTransformer.transform(vertex, geometry, tessControl, tessEval, fragment, parameters);
            map = cache;
            synchronized (map) {
                Map<PatchShaderType, String> existing = cache.get(key);
                if (existing != null) {
                    return existing;
                }
                cache.put(key, result);
            }
        }
        return result;
    }

    public static Map<PatchShaderType, String> patchAttributes(String vertex, String geometry, String tessControl, String tessEval, String fragment, InputAvailability inputs) {
        return TransformPatcher.transform(vertex, geometry, tessControl, tessEval, fragment, new AttributeParameters(Patch.ATTRIBUTES, geometry != null, inputs));
    }

    public static Map<PatchShaderType, String> patchAttributes(String vertex, String geometry, String fragment, InputAvailability inputs) {
        return TransformPatcher.patchAttributes(vertex, geometry, null, null, fragment, inputs);
    }

    public static Map<PatchShaderType, String> patchCeleritasTerrain(String vertex, String geometry, String fragment) {
        return TransformPatcher.transform(vertex, geometry, null, null, fragment, new CeleritasTerrainParameters(Patch.CELERITAS_TERRAIN));
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String fragment) {
        return TransformPatcher.patchComposite(vertex, geometry, null, null, fragment, TextureStage.COMPOSITE_AND_FINAL, null);
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String tessControl, String tessEval, String fragment) {
        return TransformPatcher.patchComposite(vertex, geometry, tessControl, tessEval, fragment, TextureStage.COMPOSITE_AND_FINAL, null);
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String tessControl, String tessEval, String fragment, TextureStage stage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.transform(vertex, geometry, tessControl, tessEval, fragment, new TextureStageParameters(Patch.COMPOSITE, stage, textureMap));
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String fragment, TextureStage stage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        return TransformPatcher.patchComposite(vertex, geometry, null, null, fragment, stage, textureMap);
    }

    public static String patchCompute(String name, String compute, TextureStage stage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        if (compute == null) {
            return null;
        }
        Map<PatchShaderType, String> result = ShaderTransformer.transformCompute(compute, new ComputeParameters(Patch.COMPUTE, stage, textureMap));
        return result != null ? result.get((Object)PatchShaderType.COMPUTE) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<CacheKey, Map<PatchShaderType, String>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=TransformPatcher.class)
    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String tessControl;
        final String tessEval;
        final String fragment;

        public CacheKey(Parameters parameters, String vertex, String geometry, String tessControl, String tessEval, String fragment) {
            this.parameters = parameters;
            this.vertex = vertex;
            this.geometry = geometry;
            this.tessControl = tessControl;
            this.tessEval = tessEval;
            this.fragment = fragment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
            result = 31 * result + (this.tessControl == null ? 0 : this.tessControl.hashCode());
            result = 31 * result + (this.tessEval == null ? 0 : this.tessEval.hashCode());
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.vertex == null ? 0 : this.vertex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.fragment, other.fragment) && Objects.equals(this.geometry, other.geometry) && Objects.equals(this.tessControl, other.tessControl) && Objects.equals(this.tessEval, other.tessEval) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.vertex, other.vertex);
        }
    }
}

