/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.google.common.base.Stopwatch;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonToken;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Token;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTreeWalker;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ShaderParser;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.StorageCollector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Transformer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.CeleritasTransformer;
import net.coderbot.iris.pipeline.transform.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.CompositeDepthTransformer;
import net.coderbot.iris.pipeline.transform.ComputeTransformer;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.render.shader.ShaderLoader;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_CharSequence;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_R_Matcher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class, TransformKey.class, NegotiationResult.class, DowngradeRule.class, VersionRequirement.class})
public class ShaderTransformer {
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)(?:\\s+(\\w+))?");
    private static final Pattern inOutVaryingPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(in|out)(\\s+)");
    private static final Pattern inPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(in)(\\s+)");
    private static final Pattern outPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(out)(\\s+)");
    private static final Pattern texturePattern = Pattern.compile("\\btexture\\s*\\(|(\\btexture\\b)");
    private static final Pattern unsignedSuffixPattern = Pattern.compile("(\\b(?:\\d+|0[xX][0-9a-fA-F]+))[uU]\\b");
    private static final int CACHE_SIZE = 100;
    private static final Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> shaderTransformationCache = new Object2ObjectLinkedOpenHashMap();
    private static final boolean useCache = true;
    private static final Set<String> loggedNegotiations = new HashSet<String>();
    private static final Map<Integer, List<String>> versionedReservedWords = new HashMap<Integer, List<String>>();
    private static final VersionRequirement[] VERSION_REQUIREMENTS;
    private static final DowngradeRule[] DOWNGRADE_RULES;
    private static Pattern hoistPattern;
    private static Object2IntMap<String> keywordToVersion;
    private static int maxSupportedHoistVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            shaderTransformationCache.clear();
        }
        loggedNegotiations.clear();
    }

    private static String replaceTexture(String input) {
        Matcher matcher = texturePattern.matcher(input);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                J_U_R_Matcher.appendReplacement((Matcher)matcher, (StringBuilder)builder, (String)"iris_renamed_texture");
                continue;
            }
            J_U_R_Matcher.appendReplacement((Matcher)matcher, (StringBuilder)builder, (String)Matcher.quoteReplacement(matcher.group(0)));
        }
        J_U_R_Matcher.appendTail((Matcher)matcher, (StringBuilder)builder);
        return builder.toString();
    }

    private static int getStageMinimumVersion(PatchShaderType stage) {
        int n;
        switch (stage) {
            case COMPUTE: {
                n = 330;
                break;
            }
            case TESS_CONTROL: 
            case TESS_EVAL: {
                n = 400;
                break;
            }
            case GEOMETRY: {
                n = 150;
                break;
            }
            default: {
                n = 110;
            }
        }
        return n;
    }

    static NegotiationResult negotiateVersion(int effectiveVersion, PatchShaderType stage) {
        int maxGlsl = RenderSystem.getMaxGlslVersion();
        if (effectiveVersion <= maxGlsl) {
            if (effectiveVersion <= 120 && RenderSystem.supportsGpuShader4()) {
                String profile = "";
                for (DowngradeRule rule : DOWNGRADE_RULES) {
                    if (rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$fromVersion() != 130 || rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$toVersion() != 120) continue;
                    List definesOnly = J_U_S_Stream.toList(rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$preprocessorDefines().stream().filter(d -> !d.startsWith("GLSL_FUNC:")));
                    return NegotiationResult.success(effectiveVersion, "", rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$extensions(), rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$defines(), definesOnly, true);
                }
                return NegotiationResult.success(effectiveVersion, "", J_U_List.of((Object)"GL_EXT_gpu_shader4"), J_U_Map.of(), J_U_List.of(), true);
            }
            return NegotiationResult.noop(effectiveVersion, effectiveVersion >= 150 ? "compatibility" : "");
        }
        int stageMin = ShaderTransformer.getStageMinimumVersion(stage);
        if (maxGlsl < stageMin) {
            return NegotiationResult.error(ShaderTransformer.jvmdowngrader$concat$negotiateVersion$1(maxGlsl, stageMin, stage.name()));
        }
        ArrayList<String> accExtensions = new ArrayList<String>();
        HashMap<String, String> accDefines = new HashMap<String, String>();
        ArrayList<String> accPreprocessorDefines = new ArrayList<String>();
        boolean accConvertQualifiers = false;
        int currentVersion = effectiveVersion;
        while (currentVersion > maxGlsl) {
            DowngradeRule matched = null;
            for (DowngradeRule rule : DOWNGRADE_RULES) {
                if (rule.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$fromVersion() != currentVersion) continue;
                matched = rule;
                break;
            }
            if (matched == null) {
                return NegotiationResult.error(ShaderTransformer.jvmdowngrader$concat$negotiateVersion$1(currentVersion, maxGlsl, effectiveVersion));
            }
            if (!matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$supported().getAsBoolean()) {
                return NegotiationResult.error(ShaderTransformer.jvmdowngrader$concat$negotiateVersion$2(matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$fromVersion(), matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$toVersion(), String.valueOf(matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$extensions())));
            }
            accExtensions.addAll(matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$extensions());
            accDefines.putAll(matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$defines());
            accPreprocessorDefines.addAll(matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$preprocessorDefines());
            accConvertQualifiers |= matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$convertStorageQualifiers();
            currentVersion = matched.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$toVersion();
        }
        if (currentVersion < stageMin) {
            return NegotiationResult.error(ShaderTransformer.jvmdowngrader$concat$negotiateVersion$3(currentVersion, stageMin, stage.name()));
        }
        String profile = currentVersion >= 150 ? "compatibility" : "";
        return NegotiationResult.success(currentVersion, profile, accExtensions, accDefines, accPreprocessorDefines, accConvertQualifiers);
    }

    public static void init() {
        StringBuilder patternBuilder = new StringBuilder();
        Object2IntOpenHashMap versionMap = new Object2IntOpenHashMap();
        int maxVersion = 0;
        for (VersionRequirement req : VERSION_REQUIREMENTS) {
            if (!req.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$supported().getAsBoolean()) continue;
            if (!J_L_CharSequence.isEmpty((CharSequence)patternBuilder)) {
                patternBuilder.append('|');
            }
            patternBuilder.append("\\b").append(Pattern.quote(req.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$keyword())).append("\\b");
            versionMap.put((Object)req.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$keyword(), req.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$minVersion());
            maxVersion = Math.max(maxVersion, req.jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$minVersion());
        }
        if (!J_L_CharSequence.isEmpty((CharSequence)patternBuilder)) {
            hoistPattern = Pattern.compile(patternBuilder.toString());
            keywordToVersion = versionMap;
        }
        maxSupportedHoistVersion = maxVersion;
        Iris.logger.info("Shader version hoisting: {} feature(s) GLSL {}", versionMap.size(), maxVersion > 0 ? Integer.valueOf(maxVersion) : "N/A");
    }

    private static int getRequiredVersion(String shaderSource, int declaredVersion) {
        int ver;
        if (hoistPattern == null || declaredVersion >= maxSupportedHoistVersion) {
            return declaredVersion;
        }
        Matcher m = hoistPattern.matcher(shaderSource);
        int required = declaredVersion;
        while (m.find() && ((ver = keywordToVersion.getInt((Object)m.group())) <= required || (required = ver) < maxSupportedHoistVersion)) {
        }
        return required;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends Parameters> Map<PatchShaderType, String> transform(String vertex, String geometry, String tessControl, String tessEval, String fragment, P parameters) {
        Map<PatchShaderType, String> result;
        if (vertex == null && geometry == null && tessControl == null && tessEval == null && fragment == null) {
            return null;
        }
        Patch patchType = parameters.patch;
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.VERTEX, vertex);
        inputs.put(PatchShaderType.GEOMETRY, geometry);
        inputs.put(PatchShaderType.TESS_CONTROL, tessControl);
        inputs.put(PatchShaderType.TESS_EVAL, tessEval);
        inputs.put(PatchShaderType.FRAGMENT, fragment);
        TransformKey<P> key = new TransformKey<P>(patchType, inputs, parameters);
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToLast(key);
        }
        if (result == null) {
            result = ShaderTransformer.transformInternal(inputs, patchType, parameters);
            parameters.type = null;
            object2ObjectLinkedOpenHashMap = shaderTransformationCache;
            synchronized (object2ObjectLinkedOpenHashMap) {
                Map existing = (Map)shaderTransformationCache.getAndMoveToLast(key);
                if (existing != null) {
                    return existing;
                }
                if (shaderTransformationCache.size() >= 100) {
                    shaderTransformationCache.removeFirst();
                }
                shaderTransformationCache.putAndMoveToLast(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends Parameters> Map<PatchShaderType, String> transformCompute(String compute, P parameters) {
        Map<PatchShaderType, String> result;
        if (compute == null) {
            return null;
        }
        Patch patchType = parameters.patch;
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.COMPUTE, compute);
        TransformKey<P> key = new TransformKey<P>(patchType, inputs, parameters);
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToLast(key);
        }
        if (result == null) {
            result = ShaderTransformer.transformComputeInternal(compute, patchType, parameters);
            parameters.type = null;
            object2ObjectLinkedOpenHashMap = shaderTransformationCache;
            synchronized (object2ObjectLinkedOpenHashMap) {
                Map existing = (Map)shaderTransformationCache.getAndMoveToLast(key);
                if (existing != null) {
                    return existing;
                }
                if (shaderTransformationCache.size() >= 100) {
                    shaderTransformationCache.removeFirst();
                }
                shaderTransformationCache.putAndMoveToLast(key, result);
            }
        }
        return result;
    }

    private static <P extends Parameters> Map<PatchShaderType, String> transformComputeInternal(String compute, Patch patchType, P parameters) {
        NegotiationResult negotiation;
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        Stopwatch watch = Stopwatch.createStarted();
        parameters.type = ShaderType.COMPUTE;
        Matcher matcher = versionPattern.matcher(compute);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No #version directive found in compute shader source code!");
        }
        String versionString = matcher.group(1);
        int versionInt = Integer.parseInt(versionString);
        int requiredVersion = ShaderTransformer.getRequiredVersion(compute, versionInt);
        if (requiredVersion > versionInt) {
            Iris.logger.debug("Compute shader requires GLSL {} for detected features, hoisting from {}", requiredVersion, versionInt);
            versionInt = requiredVersion;
            versionString = String.valueOf(versionInt);
        }
        if (versionInt < 330) {
            versionString = "330";
            versionInt = 330;
        }
        if ((negotiation = ShaderTransformer.negotiateVersion(versionInt, PatchShaderType.COMPUTE)).isError()) {
            throw new RuntimeException(ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$1(negotiation.error()));
        }
        if (negotiation.targetVersion() != versionInt) {
            Iris.logger.debug("Negotiated compute shader from GLSL {} to {}", versionInt, negotiation.targetVersion());
            versionInt = negotiation.targetVersion();
            versionString = String.valueOf(versionInt);
        }
        String profileString = ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$2(versionString);
        String input = ShaderTransformer.replaceTexture(compute);
        for (int version : versionedReservedWords.keySet()) {
            if (versionInt >= version) continue;
            for (String reservedWord : versionedReservedWords.get(version)) {
                String newName = ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$3(reservedWord);
                input = input.replaceAll(ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$4(reservedWord), newName);
            }
        }
        ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader(input);
        Transformer transformer = new Transformer(parsedShader.full());
        ShaderTransformer.doTransform(transformer, patchType, parameters, "core", versionInt);
        String extensions = versionPattern.matcher(ShaderTransformer.getFormattedShader(parsedShader.pre(), "")).replaceFirst("").trim();
        String finalHeader = ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$1(profileString, extensions.isEmpty() ? "" : ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$5(extensions));
        StringBuilder formattedShaderBuilder = new StringBuilder();
        transformer.mutateTree(tree -> formattedShaderBuilder.append(ShaderTransformer.getFormattedShader(tree, finalHeader)));
        String formattedShader = formattedShaderBuilder.toString();
        formattedShader = formattedShader.replace("iris_renamed_texture", "texture");
        formattedShader = formattedShader.replace("iris_renamed_sample", "sample");
        result.put(PatchShaderType.COMPUTE, formattedShader);
        watch.stop();
        Iris.logger.info("[Load #{}] Transformed compute shader for {} in {}", Iris.getShaderPackLoadId(), patchType.name(), watch);
        return result;
    }

    private static <P extends Parameters> Map<PatchShaderType, String> transformInternal(EnumMap<PatchShaderType, String> inputs, Patch patchType, P parameters) {
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        EnumMap<PatchShaderType, Transformer> types = new EnumMap<PatchShaderType, Transformer>(PatchShaderType.class);
        EnumMap<PatchShaderType, String> prepatched = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        EnumMap<PatchShaderType, NegotiationResult> negotiations = new EnumMap<PatchShaderType, NegotiationResult>(PatchShaderType.class);
        EnumMap<PatchShaderType, Boolean> needsTextureLodExtension = new EnumMap<PatchShaderType, Boolean>(PatchShaderType.class);
        Stopwatch watch = Stopwatch.createStarted();
        for (PatchShaderType type : PatchShaderType.VALUES) {
            NegotiationResult negotiation;
            int versionInt;
            parameters.type = type.glShaderType;
            if (inputs.get((Object)type) == null) continue;
            String input = inputs.get((Object)type);
            Matcher matcher = versionPattern.matcher(input);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No #version directive found in source code!");
            }
            String versionString = matcher.group(1);
            if (versionString == null) continue;
            String profile = "";
            String scanSource = patchType == Patch.CELERITAS_TERRAIN && type == PatchShaderType.VERTEX ? ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$1(input, ShaderTransformer.computeCeleritasHeader()) : input;
            int n = ShaderTransformer.getRequiredVersion(scanSource, versionInt = Integer.parseInt(versionString));
            if (n > versionInt) {
                Iris.logger.debug("Shader requires GLSL {} for detected features, hoisting from {}", n, versionInt);
                versionInt = n;
                versionString = String.valueOf(versionInt);
            }
            if ((negotiation = ShaderTransformer.negotiateVersion(versionInt, type)).isError()) {
                throw new RuntimeException(ShaderTransformer.jvmdowngrader$concat$transformInternal$1(type.name(), negotiation.error()));
            }
            if (negotiation.targetVersion() != versionInt) {
                String negotiationKey = ShaderTransformer.jvmdowngrader$concat$transformInternal$1(type.name(), versionInt, negotiation.targetVersion());
                if (loggedNegotiations.add(negotiationKey)) {
                    Iris.logger.info("Negotiated {} shader from GLSL {} to {} (extensions: {}, polyfills: {})", type.name(), versionInt, negotiation.targetVersion(), negotiation.extensions(), negotiation.preprocessorDefines().size());
                }
                versionInt = negotiation.targetVersion();
                versionString = String.valueOf(versionInt);
                profile = negotiation.profile();
            } else if (versionInt >= 150 && (profile = matcher.group(2)) == null) {
                profile = "compatibility";
            }
            negotiations.put(type, negotiation);
            String profileString = ShaderTransformer.jvmdowngrader$concat$transformInternal$2(versionString, profile.isEmpty() ? "" : ShaderTransformer.jvmdowngrader$concat$transformInternal$1(profile));
            input = ShaderTransformer.replaceTexture(input);
            for (int version : versionedReservedWords.keySet()) {
                if (versionInt >= version) continue;
                for (String reservedWord : versionedReservedWords.get(version)) {
                    String newName = ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$3(reservedWord);
                    input = input.replaceAll(ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$4(reservedWord), newName);
                }
            }
            ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader(input);
            Transformer transformer = new Transformer(parsedShader.full());
            if (parameters.type == ShaderType.VERTEX || parameters.type == ShaderType.FRAGMENT) {
                ShaderTransformer.upgradeStorageQualifiers(transformer, parameters);
            }
            ShaderTransformer.doTransform(transformer, patchType, parameters, profile, versionInt);
            if (versionInt <= 120 && (transformer.containsCall("texture2DLod") || transformer.containsCall("texture3DLod") || transformer.containsCall("texture2DGradARB"))) {
                needsTextureLodExtension.put(type, true);
            }
            String extensions = versionPattern.matcher(ShaderTransformer.getFormattedShader(parsedShader.pre(), "")).replaceFirst("").trim();
            types.put(type, transformer);
            prepatched.put(type, ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$1(profileString, extensions.isEmpty() ? "" : ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$5(extensions)));
        }
        CompatibilityTransformer.transformGrouped(types, parameters);
        for (Map.Entry entry : types.entrySet()) {
            PatchShaderType shaderType = (PatchShaderType)((Object)entry.getKey());
            Transformer transformer = (Transformer)entry.getValue();
            String header = (String)prepatched.get((Object)shaderType);
            NegotiationResult negotiation = (NegotiationResult)((Object)negotiations.get((Object)shaderType));
            if (patchType == Patch.CELERITAS_TERRAIN && shaderType == PatchShaderType.VERTEX) {
                header = ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$1(header, ShaderTransformer.computeCeleritasHeader());
            }
            String finalHeader = header;
            StringBuilder formattedShaderBuilder = new StringBuilder();
            transformer.mutateTree(tree -> formattedShaderBuilder.append(ShaderTransformer.getFormattedShader(tree, finalHeader)));
            String formattedShader = formattedShaderBuilder.toString();
            formattedShader = formattedShader.replace("iris_renamed_texture", "texture");
            formattedShader = formattedShader.replace("iris_renamed_sample", "sample");
            if (needsTextureLodExtension.containsKey((Object)shaderType)) {
                String[] parts = formattedShader.split("\n", 2);
                parts[1] = ShaderTransformer.jvmdowngrader$concat$transformInternal$2(parts[1]);
                formattedShader = ShaderTransformer.jvmdowngrader$concat$transformInternal$3(parts[0], (String)parts[1]);
            }
            if (!(negotiation == null || negotiation.extensions().isEmpty() && negotiation.preprocessorDefines().isEmpty())) {
                formattedShader = ShaderTransformer.injectGlslPreamble(formattedShader, negotiation.extensions(), negotiation.preprocessorDefines());
            }
            if (negotiation != null && !negotiation.defines().isEmpty()) {
                for (Map.Entry entry2 : negotiation.defines().entrySet()) {
                    formattedShader = formattedShader.replaceAll(ShaderTransformer.jvmdowngrader$concat$transformComputeInternal$4(Pattern.quote((String)entry2.getKey())), Matcher.quoteReplacement((String)entry2.getValue()));
                }
            }
            if (negotiation != null && (negotiation.convertStorageQualifiers() || negotiation.targetVersion() <= 120)) {
                if (shaderType == PatchShaderType.VERTEX) {
                    Matcher inMatcher = inPattern.matcher(formattedShader);
                    formattedShader = inMatcher.replaceAll("$1attribute$3");
                    Matcher matcher = outPattern.matcher(formattedShader);
                    formattedShader = matcher.replaceAll("$1varying$3");
                } else {
                    Matcher inOutVaryingMatcher = inOutVaryingPattern.matcher(formattedShader);
                    formattedShader = inOutVaryingMatcher.replaceAll("$1varying$3");
                }
                formattedShader = unsignedSuffixPattern.matcher(formattedShader).replaceAll("$1");
            }
            result.put(shaderType, formattedShader);
        }
        watch.stop();
        Iris.logger.info("[Load #{}] Transformed shader for {} in {}", Iris.getShaderPackLoadId(), patchType.name(), watch);
        return result;
    }

    private static void doTransform(Transformer transformer, Patch patchType, Parameters parameters, String profile, int versionInt) {
        switch (patchType) {
            case CELERITAS_TERRAIN: {
                CeleritasTransformer.transform(transformer, parameters, versionInt);
                ShaderTransformer.patchMultiTexCoord3(transformer, parameters);
                ShaderTransformer.replaceMidTexCoord(transformer, 3.0517578E-5f);
                ShaderTransformer.applyIntelHd4000Workaround(transformer);
                break;
            }
            case COMPOSITE: {
                CompositeDepthTransformer.transform(transformer, parameters, versionInt);
                break;
            }
            case ATTRIBUTES: {
                AttributeTransformer.transform(transformer, (AttributeParameters)parameters, profile, versionInt);
                break;
            }
            case COMPUTE: {
                ComputeTransformer.transform(transformer, parameters, versionInt);
                break;
            }
            default: {
                throw new IllegalStateException(ShaderTransformer.jvmdowngrader$concat$doTransform$1(patchType.name()));
            }
        }
        CompatibilityTransformer.transformEach(transformer, parameters);
    }

    public static void applyIntelHd4000Workaround(Transformer transformer) {
        transformer.renameFunctionCall("ftransform", "iris_ftransform");
    }

    public static void patchMultiTexCoord3(Transformer transformer, Parameters parameters) {
        if (parameters.type == ShaderType.VERTEX && transformer.hasVariable("gl_MultiTexCoord3") && !transformer.hasVariable("mc_midTexCoord")) {
            transformer.rename("gl_MultiTexCoord3", "mc_midTexCoord");
            transformer.injectVariable("attribute vec4 mc_midTexCoord;");
        }
    }

    public static void replaceMidTexCoord(Transformer transformer, float textureScale) {
        int type = transformer.findType("mc_midTexCoord");
        if (type != 0) {
            transformer.removeVariable("mc_midTexCoord");
        }
        transformer.replaceExpression("mc_midTexCoord", "iris_MidTex");
        switch (type) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
            case 36: {
                transformer.injectFunction(ShaderTransformer.jvmdowngrader$concat$replaceMidTexCoord$1(textureScale));
                break;
            }
            case 196: {
                transformer.injectFunction(ShaderTransformer.jvmdowngrader$concat$replaceMidTexCoord$2(textureScale));
                break;
            }
            case 197: {
                transformer.injectFunction(ShaderTransformer.jvmdowngrader$concat$replaceMidTexCoord$3(textureScale));
                break;
            }
            case 198: {
                transformer.injectFunction(ShaderTransformer.jvmdowngrader$concat$replaceMidTexCoord$4(textureScale));
                break;
            }
        }
        transformer.injectVariable("in vec2 mc_midTexCoord;");
    }

    public static void addIfNotExists(Transformer transformer, String name, String code) {
        if (!transformer.hasVariable(name)) {
            transformer.injectVariable(code);
        }
    }

    public static void addIfNotExistsType(Transformer transformer, String name, String type) {
        if (!transformer.hasVariable(name)) {
            transformer.injectVariable(ShaderTransformer.jvmdowngrader$concat$addIfNotExistsType$1(type, name));
        }
    }

    private static String computeCeleritasHeader() {
        ShaderConstants constants = ShaderConstants.builder().add("VERT_POS_SCALE", "1.0").add("VERT_POS_OFFSET", "0.0").add("VERT_TEX_SCALE", "1.0").build();
        String chunkVertexHeader = org.embeddedt.embeddium.impl.gl.shader.ShaderParser.parseShader(ShaderLoader.getShaderSource("sodium:include/chunk_vertex.glsl"), ShaderLoader::getShaderSource, constants).replace("_get_relative_chunk_coord(pos) * vec3(16.0)", "vec3(_get_relative_chunk_coord(pos)) * 16.0");
        return ShaderTransformer.jvmdowngrader$concat$computeCeleritasHeader$1(chunkVertexHeader);
    }

    public static void upgradeStorageQualifiers(Transformer root, Parameters parameters) {
        ArrayList tokens = new ArrayList();
        root.mutateTree(tree -> ParseTreeWalker.DEFAULT.walk(new StorageCollector(tokens), (ParseTree)tree));
        for (TerminalNode node : tokens) {
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken)) {
                return;
            }
            CommonToken token2 = (CommonToken)token;
            if (token2.getType() == 2) {
                token2.setType(62);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
                continue;
            }
            if (token2.getType() != 195) continue;
            if (parameters.type == ShaderType.VERTEX) {
                token2.setType(109);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(109).replace("'", ""));
                continue;
            }
            token2.setType(62);
            token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
        }
    }

    private static String injectGlslPreamble(String shader, List<String> extensions, List<String> preprocessorDefines) {
        StringBuilder extensionBlock = new StringBuilder();
        StringBuilder defineBlock = new StringBuilder();
        StringBuilder functionBlock = new StringBuilder();
        for (String ext : extensions) {
            extensionBlock.append("#extension ").append(ext).append(" : require\n");
        }
        for (String define : preprocessorDefines) {
            if (define.startsWith("GLSL_FUNC:")) {
                functionBlock.append(define.substring(10)).append("\n");
                continue;
            }
            defineBlock.append(define).append("\n");
        }
        String[] lines = shader.split("\n");
        StringBuilder shaderResult = new StringBuilder();
        boolean extensionsInjected = false;
        boolean definesInjected = false;
        boolean functionsInjected = false;
        for (String line : lines) {
            String trimmed = line.trim();
            boolean isPreprocessor = trimmed.startsWith("#");
            boolean isExtension = trimmed.startsWith("#extension");
            boolean isVersion = trimmed.startsWith("#version");
            if (isVersion) {
                shaderResult.append(line).append("\n");
                shaderResult.append((CharSequence)extensionBlock);
                extensionsInjected = true;
                continue;
            }
            if (!definesInjected && extensionsInjected && !isExtension && !trimmed.isEmpty()) {
                shaderResult.append((CharSequence)defineBlock);
                definesInjected = true;
            }
            if (!functionsInjected && definesInjected && !isPreprocessor && !trimmed.isEmpty()) {
                shaderResult.append((CharSequence)functionBlock);
                functionsInjected = true;
            }
            shaderResult.append(line).append("\n");
        }
        if (!definesInjected) {
            shaderResult.append((CharSequence)defineBlock);
        }
        if (!functionsInjected) {
            shaderResult.append((CharSequence)functionBlock);
        }
        return shaderResult.toString();
    }

    public static String getFormattedShader(ParseTree tree, String string) {
        StringBuilder sb = new StringBuilder(ShaderTransformer.jvmdowngrader$concat$getFormattedShader$1(string));
        String[] tabHolder = new String[]{""};
        ShaderTransformer.getFormattedShader(tree, sb, tabHolder);
        return sb.toString();
    }

    private static void getFormattedShader(ParseTree tree, StringBuilder stringBuilder, String[] tabHolder) {
        if (tree instanceof TerminalNode) {
            String text = tree.getText();
            if (text.equals("<EOF>")) {
                return;
            }
            if (text.equals("#")) {
                stringBuilder.append("\n#");
                return;
            }
            stringBuilder.append(text);
            if (text.equals("{")) {
                stringBuilder.append(" \n\t");
                tabHolder[0] = "\t";
            }
            if (text.equals("}")) {
                if (stringBuilder.length() >= 2) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 2);
                }
                tabHolder[0] = "";
                stringBuilder.append(" \n");
            } else {
                stringBuilder.append(text.equals(";") ? ShaderTransformer.jvmdowngrader$concat$getFormattedShader$2(tabHolder[0]) : " ");
            }
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                ShaderTransformer.getFormattedShader(tree.getChild(i), stringBuilder, tabHolder);
            }
        }
    }

    static {
        versionedReservedWords.put(400, J_U_List.of((Object)"sample"));
        VERSION_REQUIREMENTS = new VersionRequirement[]{new VersionRequirement("std430", 430, RenderSystem::supportsSSBO), new VersionRequirement("iimage", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("uimage", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("imageLoad", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("imageStore", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("uint", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec2", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec3", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec4", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("flat", 130, () -> RenderSystem.getMaxGlslVersion() >= 130)};
        DOWNGRADE_RULES = new DowngradeRule[]{new DowngradeRule(130, 120, RenderSystem::supportsGpuShader4, J_U_List.of((Object)"GL_EXT_gpu_shader4"), J_U_Map.of((Object)"texture", (Object)"texture2D"), J_U_List.of((Object[])new String[]{"#define uint int", "#define uvec2 ivec2", "#define uvec3 ivec3", "#define uvec4 ivec4", "#define isnan(x) ((x) != (x))", "#define isinf(x) ((x) == (1.0/0.0) || (x) == (-1.0/0.0))", "#define trunc(x) (sign(x) * floor(abs(x)))", "#define round(x) (floor((x) + 0.5))", "#define texelFetch texelFetch2D", "#define textureSize textureSize2D", "#define modf iris_modf", "GLSL_FUNC:float iris_modf(float x, out float i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec2 iris_modf(vec2 x, out vec2 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec3 iris_modf(vec3 x, out vec3 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec4 iris_modf(vec4 x, out vec4 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec2 mix(vec2 a, vec2 b, bvec2 sel) { return vec2(sel.x ? b.x : a.x, sel.y ? b.y : a.y); }", "GLSL_FUNC:vec3 mix(vec3 a, vec3 b, bvec3 sel) { return vec3(sel.x ? b.x : a.x, sel.y ? b.y : a.y, sel.z ? b.z : a.z); }", "GLSL_FUNC:vec4 mix(vec4 a, vec4 b, bvec4 sel) { return vec4(sel.x ? b.x : a.x, sel.y ? b.y : a.y, sel.z ? b.z : a.z, sel.w ? b.w : a.w); }", "GLSL_FUNC:bool any(bool b) { return b; }", "GLSL_FUNC:bool all(bool b) { return b; }"}), true)};
    }

    private static /* synthetic */ String jvmdowngrader$concat$negotiateVersion$1(int n, int n2, String string) {
        return "Hardware GLSL " + n + " below stage minimum " + n2 + " for " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$negotiateVersion$1(int n, int n2, int n3) {
        return "No downgrade rule from GLSL " + n + " (hardware max: " + n2 + ", shader requires: " + n3 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$negotiateVersion$2(int n, int n2, String string) {
        return "Downgrade from " + n + " to " + n2 + " requires extensions " + string + " which are not supported";
    }

    private static /* synthetic */ String jvmdowngrader$concat$negotiateVersion$3(int n, int n2, String string) {
        return "Downgrade reached GLSL " + n + " which is below stage minimum " + n2 + " for " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$1(String string) {
        return "Compute shader version negotiation failed: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$2(String string) {
        return "#version " + string + " core\n";
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$3(String string) {
        return "iris_renamed_" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$4(String string) {
        return "\\b" + string + "\\b";
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$5(String string) {
        return "\n" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformComputeInternal$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$1(String string, String string2) {
        return "Shader version negotiation failed for " + string + ": " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$1(String string, int n, int n2) {
        return string + "_" + n + "_" + n2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$1(String string) {
        return " " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$2(String string, String string2) {
        return "#version " + string + string2 + "\n";
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$2(String string) {
        return "#extension GL_ARB_shader_texture_lod : require\n" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$transformInternal$3(String string, String string2) {
        return string + "\n" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$doTransform$1(String string) {
        return "Unknown patch type: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$replaceMidTexCoord$1(float f) {
        return "float iris_MidTex = (mc_midTexCoord.x * " + f + ").x;";
    }

    private static /* synthetic */ String jvmdowngrader$concat$replaceMidTexCoord$2(float f) {
        return "vec2 iris_MidTex = (mc_midTexCoord.xy * " + f + ").xy;";
    }

    private static /* synthetic */ String jvmdowngrader$concat$replaceMidTexCoord$3(float f) {
        return "vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + f + ", 0.0);";
    }

    private static /* synthetic */ String jvmdowngrader$concat$replaceMidTexCoord$4(float f) {
        return "vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + f + ", 0.0, 1.0);";
    }

    private static /* synthetic */ String jvmdowngrader$concat$addIfNotExistsType$1(String string, String string2) {
        return string + " " + string2 + ";";
    }

    private static /* synthetic */ String jvmdowngrader$concat$computeCeleritasHeader$1(String string) {
        return "\n\n" + string + "\n\n";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getFormattedShader$1(String string) {
        return string + "\n";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getFormattedShader$2(String string) {
        return " \n" + string;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="fromVersion", type=int.class), @RecordComponents.Value(name="toVersion", type=int.class), @RecordComponents.Value(name="supported", type=BooleanSupplier.class), @RecordComponents.Value(name="extensions", type=List.class), @RecordComponents.Value(name="defines", type=Map.class), @RecordComponents.Value(name="preprocessorDefines", type=List.class), @RecordComponents.Value(name="convertStorageQualifiers", type=boolean.class)})
    @NestHost(value=ShaderTransformer.class)
    private static final class DowngradeRule
    extends J_L_Record {
        private final int fromVersion;
        private final int toVersion;
        private final BooleanSupplier supported;
        private final List<String> extensions;
        private final Map<String, String> defines;
        private final List<String> preprocessorDefines;
        private final boolean convertStorageQualifiers;

        DowngradeRule(int fromVersion, int toVersion, BooleanSupplier supported, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.supported = supported;
            this.extensions = extensions;
            this.defines = defines;
            this.preprocessorDefines = preprocessorDefines;
            this.convertStorageQualifiers = convertStorageQualifiers;
        }

        public final String toString() {
            return DowngradeRule.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return DowngradeRule.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return DowngradeRule.jvmdowngrader$equals$equals(this, o);
        }

        public int fromVersion() {
            return this.fromVersion;
        }

        public int toVersion() {
            return this.toVersion;
        }

        public BooleanSupplier supported() {
            return this.supported;
        }

        public List<String> extensions() {
            return this.extensions;
        }

        public Map<String, String> defines() {
            return this.defines;
        }

        public List<String> preprocessorDefines() {
            return this.preprocessorDefines;
        }

        public boolean convertStorageQualifiers() {
            return this.convertStorageQualifiers;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(DowngradeRule downgradeRule) {
            DowngradeRule downgradeRule2 = downgradeRule;
            return "ShaderTransformer$DowngradeRule[" + "fromVersion=" + downgradeRule.fromVersion + ", " + "toVersion=" + downgradeRule.toVersion + ", " + "supported=" + downgradeRule.supported + ", " + "extensions=" + downgradeRule.extensions + ", " + "defines=" + downgradeRule.defines + ", " + "preprocessorDefines=" + downgradeRule.preprocessorDefines + ", " + "convertStorageQualifiers=" + downgradeRule.convertStorageQualifiers + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(DowngradeRule downgradeRule) {
            Object[] objectArray = new Object[]{downgradeRule.fromVersion, downgradeRule.toVersion, downgradeRule.supported, downgradeRule.extensions, downgradeRule.defines, downgradeRule.preprocessorDefines, downgradeRule.convertStorageQualifiers};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(DowngradeRule downgradeRule, Object object) {
            if (downgradeRule == object) {
                return true;
            }
            if (object != null && object instanceof DowngradeRule) {
                DowngradeRule downgradeRule2 = (DowngradeRule)((Object)object);
                if (downgradeRule.fromVersion == downgradeRule2.fromVersion && downgradeRule.toVersion == downgradeRule2.toVersion && Objects.equals(downgradeRule.supported, downgradeRule2.supported) && Objects.equals(downgradeRule.extensions, downgradeRule2.extensions) && Objects.equals(downgradeRule.defines, downgradeRule2.defines) && Objects.equals(downgradeRule.preprocessorDefines, downgradeRule2.preprocessorDefines) && downgradeRule.convertStorageQualifiers == downgradeRule2.convertStorageQualifiers) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ List jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$extensions() {
            return this.extensions;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$extensions(List list) {
            this.extensions = list;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$fromVersion() {
            return this.fromVersion;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$fromVersion(int n) {
            this.fromVersion = n;
        }

        public /* synthetic */ boolean jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$convertStorageQualifiers() {
            return this.convertStorageQualifiers;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$convertStorageQualifiers(boolean bl) {
            this.convertStorageQualifiers = bl;
        }

        public /* synthetic */ List jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$preprocessorDefines() {
            return this.preprocessorDefines;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$preprocessorDefines(List list) {
            this.preprocessorDefines = list;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$toVersion() {
            return this.toVersion;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$toVersion(int n) {
            this.toVersion = n;
        }

        public /* synthetic */ Map jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$defines() {
            return this.defines;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$defines(Map map) {
            this.defines = map;
        }

        public /* synthetic */ BooleanSupplier jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$get$supported() {
            return this.supported;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$DowngradeRule$set$supported(BooleanSupplier booleanSupplier) {
            this.supported = booleanSupplier;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="targetVersion", type=int.class), @RecordComponents.Value(name="profile", type=String.class), @RecordComponents.Value(name="extensions", type=List.class), @RecordComponents.Value(name="defines", type=Map.class), @RecordComponents.Value(name="preprocessorDefines", type=List.class), @RecordComponents.Value(name="convertStorageQualifiers", type=boolean.class), @RecordComponents.Value(name="error", type=String.class)})
    @NestHost(value=ShaderTransformer.class)
    static final class NegotiationResult
    extends J_L_Record {
        private final int targetVersion;
        private final String profile;
        private final List<String> extensions;
        private final Map<String, String> defines;
        private final List<String> preprocessorDefines;
        private final boolean convertStorageQualifiers;
        private final String error;

        NegotiationResult(int targetVersion, String profile, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers, String error) {
            this.targetVersion = targetVersion;
            this.profile = profile;
            this.extensions = extensions;
            this.defines = defines;
            this.preprocessorDefines = preprocessorDefines;
            this.convertStorageQualifiers = convertStorageQualifiers;
            this.error = error;
        }

        static NegotiationResult success(int targetVersion, String profile, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers) {
            return new NegotiationResult(targetVersion, profile, extensions, defines, preprocessorDefines, convertStorageQualifiers, null);
        }

        static NegotiationResult error(String message) {
            return new NegotiationResult(-1, "", J_U_List.of(), J_U_Map.of(), J_U_List.of(), false, message);
        }

        static NegotiationResult noop(int version, String profile) {
            return new NegotiationResult(version, profile, J_U_List.of(), J_U_Map.of(), J_U_List.of(), false, null);
        }

        boolean isError() {
            return this.error != null;
        }

        public final String toString() {
            return NegotiationResult.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return NegotiationResult.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return NegotiationResult.jvmdowngrader$equals$equals(this, o);
        }

        public int targetVersion() {
            return this.targetVersion;
        }

        public String profile() {
            return this.profile;
        }

        public List<String> extensions() {
            return this.extensions;
        }

        public Map<String, String> defines() {
            return this.defines;
        }

        public List<String> preprocessorDefines() {
            return this.preprocessorDefines;
        }

        public boolean convertStorageQualifiers() {
            return this.convertStorageQualifiers;
        }

        public String error() {
            return this.error;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(NegotiationResult negotiationResult) {
            NegotiationResult negotiationResult2 = negotiationResult;
            return "ShaderTransformer$NegotiationResult[" + "targetVersion=" + negotiationResult.targetVersion + ", " + "profile=" + negotiationResult.profile + ", " + "extensions=" + negotiationResult.extensions + ", " + "defines=" + negotiationResult.defines + ", " + "preprocessorDefines=" + negotiationResult.preprocessorDefines + ", " + "convertStorageQualifiers=" + negotiationResult.convertStorageQualifiers + ", " + "error=" + negotiationResult.error + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(NegotiationResult negotiationResult) {
            Object[] objectArray = new Object[]{negotiationResult.targetVersion, negotiationResult.profile, negotiationResult.extensions, negotiationResult.defines, negotiationResult.preprocessorDefines, negotiationResult.convertStorageQualifiers, negotiationResult.error};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(NegotiationResult negotiationResult, Object object) {
            if (negotiationResult == object) {
                return true;
            }
            if (object != null && object instanceof NegotiationResult) {
                NegotiationResult negotiationResult2 = (NegotiationResult)((Object)object);
                if (negotiationResult.targetVersion == negotiationResult2.targetVersion && Objects.equals(negotiationResult.profile, negotiationResult2.profile) && Objects.equals(negotiationResult.extensions, negotiationResult2.extensions) && Objects.equals(negotiationResult.defines, negotiationResult2.defines) && Objects.equals(negotiationResult.preprocessorDefines, negotiationResult2.preprocessorDefines) && negotiationResult.convertStorageQualifiers == negotiationResult2.convertStorageQualifiers && Objects.equals(negotiationResult.error, negotiationResult2.error)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="keyword", type=String.class), @RecordComponents.Value(name="minVersion", type=int.class), @RecordComponents.Value(name="supported", type=BooleanSupplier.class)})
    @NestHost(value=ShaderTransformer.class)
    private static final class VersionRequirement
    extends J_L_Record {
        private final String keyword;
        private final int minVersion;
        private final BooleanSupplier supported;

        VersionRequirement(String keyword, int minVersion, BooleanSupplier supported) {
            this.keyword = keyword;
            this.minVersion = minVersion;
            this.supported = supported;
        }

        public final String toString() {
            return VersionRequirement.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return VersionRequirement.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return VersionRequirement.jvmdowngrader$equals$equals(this, o);
        }

        public String keyword() {
            return this.keyword;
        }

        public int minVersion() {
            return this.minVersion;
        }

        public BooleanSupplier supported() {
            return this.supported;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(VersionRequirement versionRequirement) {
            VersionRequirement versionRequirement2 = versionRequirement;
            return "ShaderTransformer$VersionRequirement[" + "keyword=" + versionRequirement.keyword + ", " + "minVersion=" + versionRequirement.minVersion + ", " + "supported=" + versionRequirement.supported + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(VersionRequirement versionRequirement) {
            Object[] objectArray = new Object[]{versionRequirement.keyword, versionRequirement.minVersion, versionRequirement.supported};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(VersionRequirement versionRequirement, Object object) {
            if (versionRequirement == object) {
                return true;
            }
            if (object != null && object instanceof VersionRequirement) {
                VersionRequirement versionRequirement2 = (VersionRequirement)((Object)object);
                if (Objects.equals(versionRequirement.keyword, versionRequirement2.keyword) && versionRequirement.minVersion == versionRequirement2.minVersion && Objects.equals(versionRequirement.supported, versionRequirement2.supported)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$minVersion() {
            return this.minVersion;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$set$minVersion(int n) {
            this.minVersion = n;
        }

        public /* synthetic */ String jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$keyword() {
            return this.keyword;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$set$keyword(String string) {
            this.keyword = string;
        }

        public /* synthetic */ BooleanSupplier jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$get$supported() {
            return this.supported;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_pipeline_transform_ShaderTransformer$VersionRequirement$set$supported(BooleanSupplier booleanSupplier) {
            this.supported = booleanSupplier;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ShaderTransformer.class)
    private static final class TransformKey<P extends Parameters> {
        private final Patch patchType;
        private final EnumMap<PatchShaderType, String> inputs;
        private final P params;

        TransformKey(Patch patchType, EnumMap<PatchShaderType, String> inputs, P params) {
            this.patchType = patchType;
            this.inputs = inputs;
            this.params = params;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TransformKey that = (TransformKey)obj;
            return Objects.equals((Object)this.patchType, (Object)that.patchType) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.patchType, this.inputs, this.params});
        }

        public String toString() {
            return TransformKey.jvmdowngrader$concat$toString$1(String.valueOf((Object)this.patchType), String.valueOf(this.inputs), String.valueOf(this.params));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3) {
            return "TransformKey[patchType=" + string + ", inputs=" + string2 + ", params=" + string3 + "]";
        }
    }
}

