/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Transformer;
import java.util.Map;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CommonTransformer {
    private static final Map<String, String> COMMON_TEXTURE_RENAMES = J_U_Map.ofEntries((Map.Entry[])new Map.Entry[]{J_U_Map.entry((Object)"texture2D", (Object)"texture"), J_U_Map.entry((Object)"texture3D", (Object)"texture"), J_U_Map.entry((Object)"texture2DLod", (Object)"textureLod"), J_U_Map.entry((Object)"texture3DLod", (Object)"textureLod"), J_U_Map.entry((Object)"texture2DProj", (Object)"textureProj"), J_U_Map.entry((Object)"texture3DProj", (Object)"textureProj"), J_U_Map.entry((Object)"texture2DGrad", (Object)"textureGrad"), J_U_Map.entry((Object)"texture2DGradARB", (Object)"textureGrad"), J_U_Map.entry((Object)"texture3DGrad", (Object)"textureGrad"), J_U_Map.entry((Object)"texelFetch2D", (Object)"texelFetch"), J_U_Map.entry((Object)"texelFetch3D", (Object)"texelFetch"), J_U_Map.entry((Object)"textureSize2D", (Object)"textureSize")});

    public static void transform(Transformer root, Parameters parameters, boolean core, int glslVersion) {
        root.rename("gl_FogFragCoord", "iris_FogFragCoord");
        if (parameters.type == ShaderType.VERTEX) {
            root.injectVariable("out float iris_FogFragCoord;");
            root.prependMain("iris_FogFragCoord = 0.0f;");
        } else if (parameters.type == ShaderType.FRAGMENT) {
            root.injectVariable("in float iris_FogFragCoord;");
        }
        if (parameters.type == ShaderType.VERTEX) {
            root.injectVariable("vec4 iris_FrontColor;");
            root.rename("gl_FrontColor", "iris_FrontColor");
        }
        if (parameters.type == ShaderType.FRAGMENT) {
            if (root.containsCall("gl_FragColor")) {
                root.replaceExpression("gl_FragColor", "gl_FragData[0]");
            }
            if (!core && parameters.getAlphaTest() != AlphaTest.ALWAYS) {
                root.injectVariable("uniform float iris_currentAlphaTest;");
                root.appendMain(parameters.getAlphaTest().toExpression("gl_FragData[0].a", "iris_currentAlphaTest", ""));
            }
        }
        if (root.containsCall("texture") && root.hasVariable("texture")) {
            root.rename("texture", "gtexture");
        }
        if (root.hasVariable("iris_renamed_texture")) {
            root.rename("iris_renamed_texture", "gtexture");
        }
        if (root.containsCall("gcolor") && root.hasVariable("gcolor")) {
            root.rename("gcolor", "gtexture");
        }
        root.rename("gl_Fog", "iris_Fog");
        root.injectVariable("uniform float iris_FogDensity;");
        root.injectVariable("uniform float iris_FogStart;");
        root.injectVariable("uniform float iris_FogEnd;");
        root.injectVariable("uniform vec4 iris_FogColor;");
        root.injectFunction("struct iris_FogParameters {vec4 color;float density;float start;float end;float scale;};");
        root.injectFunction("iris_FogParameters iris_Fog = iris_FogParameters(iris_FogColor, iris_FogDensity, iris_FogStart, iris_FogEnd, 1.0f / (iris_FogEnd - iris_FogStart));");
        if (glslVersion > 120) {
            root.renameFunctionCall(COMMON_TEXTURE_RENAMES);
            root.renameAndWrapShadow("shadow2D", "texture");
            root.renameAndWrapShadow("shadow2DLod", "textureLod");
        }
    }
}

