/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.GameModeUtil;
import com.gtnewhorizons.angelica.compat.toremove.MatrixStack;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import com.gtnewhorizons.angelica.rendering.celeritas.CeleritasWorldRenderer;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShadowCullState;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.FrustumHolder;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.advanced.SafeZoneCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import org.embeddedt.embeddium.impl.render.viewport.ViewportProvider;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={MipmapPass.class})
public class ShadowRenderer {
    public static final Matrix4f MODELVIEW = new Matrix4f();
    public static final FloatBuffer MODELVIEW_BUFFER = BufferUtils.createFloatBuffer((int)16);
    public static final Matrix4f PROJECTION = new Matrix4f();
    public static final List<TileEntity> visibleTileEntities = new ArrayList<TileEntity>();
    public static final List<TileEntity> globalTileEntities = new ArrayList<TileEntity>();
    public static boolean ACTIVE = false;
    private static final Comparator<Entity> ENTITY_CLASS_COMPARATOR = Comparator.comparingInt(a -> System.identityHashCode(a.getClass()));
    private static final NonCullingFrustum NON_CULLING_FRUSTUM = new NonCullingFrustum();
    private static final CullEverythingFrustum CULL_EVERYTHING_FRUSTUM = new CullEverythingFrustum();
    public static ShadowRenderTargets CURRENT_TARGETS = null;
    private final float halfPlaneLength;
    private final float voxelDistance;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    private final ShadowRenderTargets targets;
    private final ShadowCullState packCullingState;
    private final ShadowCompositeRenderer compositeRenderer;
    private boolean packHasVoxelization;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final float sunPathRotation;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private int renderedShadowEntities = 0;
    private int renderedShadowTileEntities = 0;
    private Profiler profiler;
    private final List<Entity> renderedEntitiesList = new ArrayList<Entity>(64);
    private final MatrixStack shadowModelView = new MatrixStack();
    private final CelestialUniforms celestialUniforms;
    private final AdvancedShadowCullingFrustum cachedAdvancedFrustum = new AdvancedShadowCullingFrustum();
    private final Vector3f shadowLightVectorCache = new Vector3f();
    private BoxCuller cachedBoxCuller;
    private BoxCullingFrustum cachedBoxCullingFrustum;
    private BoxCuller cachedAdvancedBoxCuller;
    private BoxCuller cachedTileEntityCuller;
    private double lastBoxCullerDistance = -1.0;
    private double lastAdvancedBoxCullerDistance = -1.0;
    private double lastTileEntityCullerDistance = -1.0;
    private final IntBuffer swizzleBuf = BufferUtils.createIntBuffer((int)4);
    private double savedRenderPosX;
    private double savedRenderPosY;
    private double savedRenderPosZ;

    public ShadowRenderer(ProgramSource shadow, PackDirectives directives, ShadowRenderTargets shadowRenderTargets, ShadowCompositeRenderer compositeRenderer) {
        this.profiler = Minecraft.func_71410_x().field_71424_I;
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.voxelDistance = shadowDirectives.getVoxelDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = shadowDirectives.getEntityShadowDistanceMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities();
        this.compositeRenderer = compositeRenderer;
        this.debugStringOverall = ShadowRenderer.jvmdowngrader$concat$$init$$1(this.halfPlaneLength, this.resolution, this.resolution);
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = shadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (shadow != null) {
            this.packHasVoxelization = shadow.getGeometrySource().isPresent();
            this.packCullingState = shadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = ShadowCullState.DEFAULT;
        }
        this.sunPathRotation = directives.getSunPathRotation();
        this.celestialUniforms = new CelestialUniforms(this.sunPathRotation);
        this.configureSamplingSettings(shadowDirectives);
    }

    public void setUsesImages(boolean usesImages) {
        this.packHasVoxelization = this.packHasVoxelization || usesImages;
    }

    public static MatrixStack createShadowModelView(float sunPathRotation, float intervalSize) {
        Vector3d entityPos = Camera.INSTANCE.getEntityPos();
        MatrixStack modelView = new MatrixStack();
        ShadowMatrices.createModelViewMatrix(modelView, ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, entityPos.x, entityPos.y, entityPos.z);
        return modelView;
    }

    private MatrixStack getShadowModelView() {
        Vector3d entityPos = Camera.INSTANCE.getEntityPos();
        this.shadowModelView.reset();
        ShadowMatrices.createModelViewMatrix(this.shadowModelView, ShadowRenderer.getShadowAngle(), this.intervalSize, this.sunPathRotation, entityPos.x, entityPos.y, entityPos.z);
        return this.shadowModelView;
    }

    private static WorldClient getLevel() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
    }

    private static float getSkyAngle() {
        return Minecraft.func_71410_x().field_71441_e.func_72826_c(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float skyAngle = ShadowRenderer.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        GLStateManager.glActiveTexture(33988);
        this.configureDepthSampler(this.targets.getDepthTexture().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < Math.min(colorSamplingSettings.size(), this.targets.getNumColorTextures()); ++i) {
            if (this.targets.get(i) == null) continue;
            int glTextureId = this.targets.get(i).getMainTexture();
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.get(i));
        }
        GLStateManager.glActiveTexture(33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering()) {
            RenderSystem.texParameteri(glTextureId, 3553, 34892, 34894);
        }
        IntBuffer cfr_ignored_0 = (IntBuffer)J_N_Buffer.rewind((Buffer)this.swizzleBuf);
        IntBuffer cfr_ignored_1 = (IntBuffer)J_N_Buffer.rewind((Buffer)this.swizzleBuf.put(new int[]{6403, 6403, 6403, 1}));
        RenderSystem.texParameteriv(glTextureId, 3553, 36422, this.swizzleBuf);
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            RenderSystem.texParameteri(glTextureId, 3553, 10241, 9729);
            RenderSystem.texParameteri(glTextureId, 3553, 10240, 9729);
        } else {
            RenderSystem.texParameteri(glTextureId, 3553, 10241, 9728);
            RenderSystem.texParameteri(glTextureId, 3553, 10240, 9728);
        }
    }

    private void generateMipmaps() {
        GLStateManager.glActiveTexture(33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            this.setupMipmappingForTexture(mipmapPass.getTexture(), mipmapPass.getTargetFilteringMode());
        }
        GLStateManager.glActiveTexture(33984);
    }

    private void setupMipmappingForTexture(int texture, int filteringMode) {
        RenderSystem.generateMipmaps(texture, 3553);
        RenderSystem.texParameteri(texture, 3553, 10241, filteringMode);
    }

    private FrustumHolder createShadowFrustum(float renderMultiplier, FrustumHolder holder) {
        String reason;
        double distance;
        if ((this.packCullingState == ShadowCullState.DISTANCE || this.packHasVoxelization) && this.packCullingState != ShadowCullState.ADVANCED && this.packCullingState != ShadowCullState.SAFE_ZONE) {
            distance = this.halfPlaneLength * renderMultiplier;
            reason = this.packCullingState == ShadowCullState.DISTANCE ? "(set by shader pack)" : "(voxelization detected)";
            if (distance <= 0.0 || distance > (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)) {
                String distanceInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$1(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16);
                String cullingInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$1(reason);
                return holder.setInfo(NON_CULLING_FRUSTUM, distanceInfo, cullingInfo);
            }
        } else {
            BoxCuller boxCuller;
            String distanceInfo;
            boolean hasSafeZone;
            boolean bl = hasSafeZone = this.packCullingState == ShadowCullState.SAFE_ZONE;
            if (hasSafeZone && renderMultiplier < 0.0f) {
                renderMultiplier = 1.0f;
            }
            double distance2 = (hasSafeZone ? this.voxelDistance : this.halfPlaneLength) * renderMultiplier;
            String setter = "(set by shader pack)";
            if (renderMultiplier < 0.0f) {
                distance2 = IrisVideoSettings.shadowDistance * 16;
                setter = "(set by user)";
            }
            if (distance2 >= (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16) && !hasSafeZone) {
                distanceInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$1(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16);
                boxCuller = null;
            } else {
                distanceInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$1(distance2, setter);
                if (distance2 == 0.0 && !hasSafeZone) {
                    String cullingInfo = "no shadows rendered";
                    return holder.setInfo(CULL_EVERYTHING_FRUSTUM, distanceInfo, cullingInfo);
                }
                boxCuller = this.getOrCreateAdvancedBoxCuller(distance2);
            }
            String cullingInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$3(hasSafeZone ? "Safe Zone" : "Advanced");
            Vector4f shadowLightPosition = this.celestialUniforms.getShadowLightPositionInWorldSpace();
            this.shadowLightVectorCache.set(shadowLightPosition.x(), shadowLightPosition.y(), shadowLightPosition.z());
            this.shadowLightVectorCache.normalize();
            if (hasSafeZone) {
                BoxCuller distanceCuller = new BoxCuller(this.halfPlaneLength * renderMultiplier);
                SafeZoneCullingFrustum safeZoneFrustum = new SafeZoneCullingFrustum(RenderingState.INSTANCE.getModelViewMatrix(), RenderingState.INSTANCE.getProjectionMatrix(), this.shadowLightVectorCache, boxCuller, distanceCuller);
                return holder.setInfo(safeZoneFrustum, distanceInfo, cullingInfo);
            }
            this.cachedAdvancedFrustum.init(RenderingState.INSTANCE.getModelViewMatrix(), RenderingState.INSTANCE.getProjectionMatrix(), this.shadowLightVectorCache, boxCuller);
            return holder.setInfo(this.cachedAdvancedFrustum, distanceInfo, cullingInfo);
        }
        String distanceInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$1(distance);
        String cullingInfo = ShadowRenderer.jvmdowngrader$concat$createShadowFrustum$2(reason);
        holder.setInfo(this.getOrCreateBoxCullingFrustum(distance), distanceInfo, cullingInfo);
        return holder;
    }

    private BoxCullingFrustum getOrCreateBoxCullingFrustum(double distance) {
        if (this.cachedBoxCuller == null) {
            this.cachedBoxCuller = new BoxCuller(distance);
            this.cachedBoxCullingFrustum = new BoxCullingFrustum(this.cachedBoxCuller);
            this.lastBoxCullerDistance = distance;
        } else if (this.lastBoxCullerDistance != distance) {
            this.cachedBoxCuller.setMaxDistance(distance);
            this.lastBoxCullerDistance = distance;
        }
        return this.cachedBoxCullingFrustum;
    }

    private BoxCuller getOrCreateAdvancedBoxCuller(double distance) {
        if (this.cachedAdvancedBoxCuller == null) {
            this.cachedAdvancedBoxCuller = new BoxCuller(distance);
            this.lastAdvancedBoxCullerDistance = distance;
        } else if (this.lastAdvancedBoxCullerDistance != distance) {
            this.cachedAdvancedBoxCuller.setMaxDistance(distance);
            this.lastAdvancedBoxCullerDistance = distance;
        }
        return this.cachedAdvancedBoxCuller;
    }

    private BoxCuller getOrCreateTileEntityCuller(double distance) {
        if (this.cachedTileEntityCuller == null) {
            this.cachedTileEntityCuller = new BoxCuller(distance);
            this.lastTileEntityCullerDistance = distance;
        } else if (this.lastTileEntityCullerDistance != distance) {
            this.cachedTileEntityCuller.setMaxDistance(distance);
            this.lastTileEntityCullerDistance = distance;
        }
        return this.cachedTileEntityCuller;
    }

    private void setupGlState(Matrix4f projMatrix) {
        this.targets.getDepthSourceFb().bind();
        GLStateManager.glViewport(0, 0, this.resolution, this.resolution);
        RenderSystem.setupProjectionMatrix(projMatrix);
        GLStateManager.disableCull();
    }

    private void restoreGlState() {
        GLStateManager.enableCull();
        RenderSystem.restoreProjectionMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147110_a().func_147610_a(false);
        GLStateManager.glViewport(0, 0, mc.field_71443_c, mc.field_71440_d);
    }

    private void copyPreTranslucentDepth() {
        this.profiler.func_76318_c("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderEntities(EntityRenderer levelRenderer, Frustrum frustum, Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        this.profiler.func_76320_a("cull");
        this.renderedEntitiesList.clear();
        boolean playerIsSpectator = GameModeUtil.isSpectator();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        for (Entity entity : ShadowRenderer.getLevel().field_72996_f) {
            if (playerIsSpectator && entity == player || !entity.field_70158_ak && !frustum.func_78546_a(entity.field_70121_D)) continue;
            this.renderedEntitiesList.add(entity);
        }
        this.profiler.func_76318_c("sort");
        this.renderedEntitiesList.sort(ENTITY_CLASS_COMPARATOR);
        this.profiler.func_76318_c("build geometry");
        this.setupEntityShadowState(modelView, cameraX, cameraY, cameraZ);
        try {
            for (Entity entity : this.renderedEntitiesList) {
                RenderManager.field_78727_a.func_147937_a(entity, tickDelta);
            }
        }
        finally {
            this.teardownEntityShadowState();
        }
        this.renderedShadowEntities = this.renderedEntitiesList.size();
        this.profiler.func_76319_b();
    }

    private void setupEntityShadowState(MatrixStack modelView, double cameraX, double cameraY, double cameraZ) {
        this.savedRenderPosX = RenderManager.field_78725_b;
        this.savedRenderPosY = RenderManager.field_78726_c;
        this.savedRenderPosZ = RenderManager.field_78723_d;
        RenderManager.field_78725_b = cameraX;
        RenderManager.field_78726_c = cameraY;
        RenderManager.field_78723_d = cameraZ;
        GLStateManager.glEnable(32823);
        GLStateManager.glPolygonOffset(1.0f, 1.0f);
        GL11.glPushMatrix();
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)((FloatBuffer)J_N_Buffer.clear((Buffer)MODELVIEW_BUFFER)));
        modelView.peek().getModel().get(MODELVIEW_BUFFER);
        GL11.glLoadMatrix((FloatBuffer)MODELVIEW_BUFFER);
    }

    private void teardownEntityShadowState() {
        GL11.glPopMatrix();
        GLStateManager.glDisable(32823);
        GLStateManager.glPolygonOffset(0.0f, 0.0f);
        RenderManager.field_78725_b = this.savedRenderPosX;
        RenderManager.field_78726_c = this.savedRenderPosY;
        RenderManager.field_78723_d = this.savedRenderPosZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPlayerEntity(EntityRenderer levelRenderer, Frustrum frustum, Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        this.profiler.func_76320_a("cull");
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (GameModeUtil.isSpectator()) {
            this.profiler.func_76319_b();
            this.renderedShadowEntities = 0;
            return;
        }
        if (!player.field_70158_ak && !frustum.func_78546_a(player.field_70121_D)) {
            this.profiler.func_76319_b();
            this.renderedShadowEntities = 0;
            return;
        }
        this.profiler.func_76318_c("build geometry");
        int shadowEntities = 0;
        this.setupEntityShadowState(modelView, cameraX, cameraY, cameraZ);
        try {
            if (player.field_70153_n != null) {
                RenderManager.field_78727_a.func_147937_a(player.field_70153_n, tickDelta);
                ++shadowEntities;
            }
            if (player.field_70154_o != null) {
                RenderManager.field_78727_a.func_147937_a(player.field_70154_o, tickDelta);
                ++shadowEntities;
            }
            RenderManager.field_78727_a.func_147937_a((Entity)player, tickDelta);
        }
        finally {
            this.teardownEntityShadowState();
        }
        this.renderedShadowEntities = ++shadowEntities;
        this.profiler.func_76319_b();
    }

    private void renderTileEntity(TileEntity tile, double cameraX, double cameraY, double cameraZ, float partialTicks) {
        if (tile.func_145835_a(cameraX, cameraY, cameraZ) >= tile.func_145833_n()) {
            return;
        }
        int brightness = tile.func_145831_w().func_72802_i(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0);
        GLStateManager.setLightmapTextureCoords(33985, (float)brightness % 65536.0f, (float)brightness / 65536.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.field_145851_c - cameraX, (double)tile.field_145848_d - cameraY, (double)tile.field_145849_e - cameraZ, partialTicks);
    }

    private void renderTileEntities(Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float partialTicks, boolean hasEntityFrustum) {
        this.profiler.func_76320_a("build blockentities");
        int shadowTileEntities = 0;
        BoxCuller culler = null;
        if (hasEntityFrustum) {
            double distance = this.halfPlaneLength * (this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier);
            culler = this.getOrCreateTileEntityCuller(distance);
            culler.setPosition(cameraX, cameraY, cameraZ);
        }
        GL11.glPushMatrix();
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)((FloatBuffer)J_N_Buffer.clear((Buffer)MODELVIEW_BUFFER)));
        modelView.peek().getModel().get(MODELVIEW_BUFFER);
        GL11.glLoadMatrix((FloatBuffer)MODELVIEW_BUFFER);
        GbufferPrograms.beginBlockEntities();
        GbufferPrograms.setBlockEntityDefaults();
        for (TileEntity tileEntity : visibleTileEntities) {
            if (hasEntityFrustum && culler.isCulled(tileEntity.field_145851_c - 1, tileEntity.field_145848_d - 1, tileEntity.field_145849_e - 1, tileEntity.field_145851_c + 1, tileEntity.field_145848_d + 1, tileEntity.field_145849_e + 1)) continue;
            this.renderTileEntity(tileEntity, cameraX, cameraY, cameraZ, partialTicks);
            ++shadowTileEntities;
        }
        for (TileEntity tileEntity : globalTileEntities) {
            if (hasEntityFrustum && culler.isCulled(tileEntity.field_145851_c - 1, tileEntity.field_145848_d - 1, tileEntity.field_145849_e - 1, tileEntity.field_145851_c + 1, tileEntity.field_145848_d + 1, tileEntity.field_145849_e + 1)) continue;
            this.renderTileEntity(tileEntity, cameraX, cameraY, cameraZ, partialTicks);
            ++shadowTileEntities;
        }
        GbufferPrograms.endBlockEntities();
        GLStateManager.glPopMatrix();
        this.renderedShadowTileEntities = shadowTileEntities;
        this.profiler.func_76319_b();
    }

    public void renderShadows(EntityRenderer levelRenderer, Camera playerCamera) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderGlobal rg = mc.field_71438_f;
        this.profiler = Minecraft.func_71410_x().field_71424_I;
        this.profiler.func_76318_c("shadows");
        ACTIVE = true;
        CURRENT_TARGETS = this.targets;
        visibleTileEntities.clear();
        globalTileEntities.clear();
        MatrixStack modelView = this.getShadowModelView();
        MODELVIEW.set((Matrix4fc)modelView.peek().getModel());
        Matrix4f shadowProjection = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        PROJECTION.set((Matrix4fc)shadowProjection);
        this.profiler.func_76320_a("terrain_setup");
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)levelRenderer).saveState();
        }
        this.profiler.func_76320_a("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        Vector3d entityPos = playerCamera.getEntityPos();
        double entityX = entityPos.x;
        double entityY = entityPos.y;
        double entityZ = entityPos.z;
        this.terrainFrustumHolder.getFrustum().func_78547_a(entityX, entityY, entityZ);
        this.profiler.func_76319_b();
        CeleritasWorldRenderer.getInstance().getRenderSectionManager().markGraphDirty();
        mc.field_71438_f.func_72729_a((ICamera)this.terrainFrustumHolder.getFrustum(), playerCamera.getPartialTicks());
        this.profiler.func_76318_c("terrain");
        this.setupGlState(PROJECTION);
        if (this.shouldRenderTerrain) {
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            rg.func_72719_a((EntityLivingBase)mc.field_71439_g, 0, (double)playerCamera.getPartialTicks());
        }
        GLStateManager.glViewport(0, 0, this.resolution, this.resolution);
        this.profiler.func_76318_c("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean hasEntityFrustum = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            hasEntityFrustum = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        Frustrum entityShadowFrustum = this.entityFrustumHolder.getFrustum();
        entityShadowFrustum.func_78547_a(entityX, entityY, entityZ);
        if (AngelicaConfig.enableCeleritas) {
            CeleritasWorldRenderer.getInstance().setCurrentViewport(((ViewportProvider)entityShadowFrustum).sodium$createViewport());
        }
        if (this.shouldRenderEntities) {
            this.renderEntities(levelRenderer, entityShadowFrustum, null, modelView, entityX, entityY, entityZ, tickDelta);
        } else if (this.shouldRenderPlayer) {
            this.renderPlayerEntity(levelRenderer, entityShadowFrustum, null, modelView, entityX, entityY, entityZ, tickDelta);
        }
        if (this.shouldRenderBlockEntities) {
            this.renderTileEntities(null, modelView, entityX, entityY, entityZ, tickDelta, hasEntityFrustum);
        }
        this.profiler.func_76318_c("draw entities");
        this.copyPreTranslucentDepth();
        this.profiler.func_76318_c("translucent terrain");
        if (this.shouldRenderTranslucent) {
            rg.func_72719_a((EntityLivingBase)mc.field_71439_g, 1, (double)playerCamera.getPartialTicks());
        }
        this.profiler.func_76318_c("generate mipmaps");
        this.generateMipmaps();
        this.profiler.func_76318_c("restore gl state");
        this.restoreGlState();
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)levelRenderer).restoreState();
        }
        this.profiler.func_76318_c("shadowcomp");
        if (this.compositeRenderer != null) {
            this.compositeRenderer.renderAll();
        }
        ACTIVE = false;
        CURRENT_TARGETS = null;
        this.profiler.func_76319_b();
        this.profiler.func_76318_c("updatechunks");
    }

    public void addDebugText(List<String> messages) {
        messages.add("[AngelicaShaders - Shadow Pass]");
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$1(this.debugStringOverall));
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$1(this.terrainFrustumHolder.getDistanceInfo(), this.entityFrustumHolder.getDistanceInfo()));
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$2(this.terrainFrustumHolder.getCullingInfo(), this.entityFrustumHolder.getCullingInfo()));
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$1(CeleritasWorldRenderer.getInstance().getChunksDebugString(), this.shouldRenderTerrain ? "" : " (no terrain) ", this.shouldRenderTranslucent ? "" : "(no translucent)"));
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$2(this.getEntitiesDebugString()));
        messages.add(ShadowRenderer.jvmdowngrader$concat$addDebugText$3(this.getTileEntitiesDebugString()));
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? ShadowRenderer.jvmdowngrader$concat$getEntitiesDebugString$1(this.renderedShadowEntities, Minecraft.func_71410_x().field_71441_e.field_72996_f.size()) : "disabled by pack";
    }

    private String getTileEntitiesDebugString() {
        return this.shouldRenderBlockEntities ? ShadowRenderer.jvmdowngrader$concat$getEntitiesDebugString$1(this.renderedShadowTileEntities, Minecraft.func_71410_x().field_71441_e.field_147482_g.size()) : "disabled by pack";
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(float f, int n, int n2) {
        return "half plane = " + f + " meters @ " + n + "x" + n2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$1(int n) {
        return n + " blocks (capped by normal render distance)";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$1(String string) {
        return "disabled " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$1(double d) {
        return d + " blocks (set by shader pack)";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$2(String string) {
        return "distance only " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$1(double d, String string) {
        return d + " blocks " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShadowFrustum$3(String string) {
        return string + " Frustum Culling enabled";
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$1(String string) {
        return "  Shadow Maps: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$1(String string, String string2) {
        return "  Shadow Distance Terrain: " + string + " Entity: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$2(String string, String string2) {
        return "  Shadow Culling Terrain: " + string + " Entity: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$1(String string, String string2, String string3) {
        return "  Shadow Terrain: " + string + string2 + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$2(String string) {
        return "  Shadow Entities: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addDebugText$3(String string) {
        return "  Shadow Block Entities: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getEntitiesDebugString$1(int n, int n2) {
        return n + "/" + n2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ShadowRenderer.class)
    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int texture, int targetFilteringMode) {
            this.texture = texture;
            this.targetFilteringMode = targetFilteringMode;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

