/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import org.jetbrains.annotations.Nullable;

public class PipelineManager {
    private final Function<String, WorldRenderingPipeline> pipelineFactory;
    private final Map<String, WorldRenderingPipeline> pipelinesPerDimension = new HashMap<String, WorldRenderingPipeline>();
    private WorldRenderingPipeline pipeline = new FixedFunctionWorldRenderingPipeline();
    private String lastPreparedDimension = null;
    private int versionCounterForSodiumShaderReload = 0;

    public PipelineManager(Function<String, WorldRenderingPipeline> pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public WorldRenderingPipeline preparePipeline(String currentDimension) {
        if (this.lastPreparedDimension != null && !this.lastPreparedDimension.equals(currentDimension)) {
            Iris.logger.info("Dimension changed from '{}' to '{}', reloading pipeline", this.lastPreparedDimension, currentDimension);
            this.destroyPipeline();
        }
        this.lastPreparedDimension = currentDimension;
        if (!this.pipelinesPerDimension.containsKey(currentDimension)) {
            SystemTimeUniforms.COUNTER.reset();
            SystemTimeUniforms.TIMER.reset();
            Iris.logger.info("Creating pipeline for dimension '{}'", currentDimension);
            this.pipeline = this.pipelineFactory.apply(currentDimension);
            this.pipelinesPerDimension.put(currentDimension, this.pipeline);
        } else {
            this.pipeline = this.pipelinesPerDimension.get(currentDimension);
        }
        return this.pipeline;
    }

    @Nullable
    public WorldRenderingPipeline getPipelineNullable() {
        return this.pipeline;
    }

    public Optional<WorldRenderingPipeline> getPipeline() {
        return Optional.ofNullable(this.pipeline);
    }

    public void destroyPipeline() {
        this.pipelinesPerDimension.forEach((dimensionName, pipeline) -> {
            Iris.logger.info("Destroying pipeline for dimension '{}'", dimensionName);
            this.resetTextureState();
            pipeline.destroy();
        });
        this.pipelinesPerDimension.clear();
        this.pipeline = null;
        this.lastPreparedDimension = null;
        ++this.versionCounterForSodiumShaderReload;
    }

    private void resetTextureState() {
        for (int i = 0; i < 16; ++i) {
            GLStateManager.glActiveTexture(33984 + i);
            GLStateManager.glBindTexture(3553, 0);
        }
        GLStateManager.glActiveTexture(33984);
    }

    @Generated
    public int getVersionCounterForSodiumShaderReload() {
        return this.versionCounterForSodiumShaderReload;
    }
}

