/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VertexBufferType;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final double COS_22_5 = Math.cos(Math.toRadians(22.5));
    private static final double SIN_22_5 = Math.sin(Math.toRadians(22.5));
    private IVertexArrayObject vao;
    private int currentRenderDistance;

    public HorizonRenderer() {
        this.currentRenderDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        this.rebuildBuffer();
    }

    private void rebuildBuffer() {
        if (this.vao != null) {
            this.vao.delete();
        }
        DirectTessellator tessellator = TessellatorManager.startCapturingDirect((VertexFormat)DefaultVertexFormat.POSITION);
        tessellator.func_78382_b();
        this.buildHorizon(this.currentRenderDistance * 16, (Tessellator)tessellator);
        this.vao = DirectTessellator.stopCapturingToVBO((VertexBufferType)VertexBufferType.IMMUTABLE);
    }

    private void buildQuad(Tessellator consumer, double x1, double z1, double x2, double z2) {
        consumer.func_78377_a(x1, -16.0, z1);
        consumer.func_78377_a(x1, 16.0, z1);
        consumer.func_78377_a(x2, 16.0, z2);
        consumer.func_78377_a(x2, -16.0, z2);
    }

    private void buildHalf(Tessellator consumer, double adjacent, double opposite, boolean invert) {
        if (invert) {
            adjacent = -adjacent;
            opposite = -opposite;
        }
        this.buildQuad(consumer, adjacent, -opposite, opposite, -adjacent);
        this.buildQuad(consumer, adjacent, opposite, adjacent, -opposite);
        this.buildQuad(consumer, opposite, adjacent, adjacent, opposite);
        this.buildQuad(consumer, -opposite, adjacent, opposite, adjacent);
    }

    private void buildOctagonalPrism(Tessellator consumer, double adjacent, double opposite) {
        this.buildHalf(consumer, adjacent, opposite, false);
        this.buildHalf(consumer, adjacent, opposite, true);
    }

    private void buildRegularOctagonalPrism(Tessellator consumer, double radius) {
        this.buildOctagonalPrism(consumer, radius * COS_22_5, radius * SIN_22_5);
    }

    private void buildBottomPlane(Tessellator consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.func_78377_a((double)(x + 64), -16.0, (double)z);
                consumer.func_78377_a((double)x, -16.0, (double)z);
                consumer.func_78377_a((double)x, -16.0, (double)(z + 64));
                consumer.func_78377_a((double)(x + 64), -16.0, (double)(z + 64));
            }
        }
    }

    private void buildTopPlane(Tessellator consumer, int radius) {
        for (int x = -radius; x <= radius; x += 64) {
            for (int z = -radius; z <= radius; z += 64) {
                consumer.func_78377_a((double)(x + 64), 16.0, (double)z);
                consumer.func_78377_a((double)(x + 64), 16.0, (double)(z + 64));
                consumer.func_78377_a((double)x, 16.0, (double)(z + 64));
                consumer.func_78377_a((double)x, 16.0, (double)z);
            }
        }
    }

    private void buildHorizon(int radius, Tessellator consumer) {
        if (radius > 256) {
            radius = 256;
        }
        this.buildRegularOctagonalPrism(consumer, radius);
        this.buildTopPlane(consumer, 384);
        this.buildBottomPlane(consumer, 384);
    }

    public void renderHorizon(FloatBuffer matrix) {
        if (this.currentRenderDistance != Minecraft.func_71410_x().field_71474_y.field_151451_c) {
            this.currentRenderDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c;
            this.rebuildBuffer();
        }
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)matrix);
        this.vao.bind();
        this.vao.draw();
        this.vao.unbind();
        GL11.glPopMatrix();
    }

    public void destroy() {
        this.vao.delete();
    }
}

