/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.BaseOptionElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.MergedBooleanOption;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuBooleanOptionElement;
import net.minecraft.client.resources.I18n;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BooleanElementWidget
extends BaseOptionElementWidget<OptionMenuBooleanOptionElement> {
    private static final String TEXT_TRUE = I18n.func_135052_a((String)"label.iris.true", (Object[])new Object[0]);
    private static final String TEXT_FALSE = I18n.func_135052_a((String)"label.iris.false", (Object[])new Object[0]);
    private static final String TEXT_TRUE_DEFAULT = I18n.func_135052_a((String)"label.iris.true", (Object[])new Object[0]);
    private static final String TEXT_FALSE_DEFAULT = I18n.func_135052_a((String)"label.iris.false", (Object[])new Object[0]);
    private final BooleanOption option;
    private boolean appliedValue;
    private boolean value;
    private boolean defaultValue;

    public BooleanElementWidget(OptionMenuBooleanOptionElement element) {
        super(element);
        this.option = element.option;
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        super.init(screen, navigation);
        this.appliedValue = ((OptionMenuBooleanOptionElement)this.element).getAppliedOptionValues().getBooleanValueOrDefault(this.option.getName());
        this.value = ((OptionMenuBooleanOptionElement)this.element).getPendingOptionValues().getBooleanValueOrDefault(this.option.getName());
        this.defaultValue = ((MergedBooleanOption)((OptionMenuBooleanOptionElement)this.element).getAppliedOptionValues().getOptionSet().getBooleanOptions().get((Object)this.option.getName())).getOption().getDefaultValue();
        this.setLabel(GuiUtil.translateOrDefault(this.option.getName(), BooleanElementWidget.jvmdowngrader$concat$init$1(this.option.getName()), new Object[0]));
    }

    @Override
    public void drawScreen(int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        this.updateRenderParams(width, 28);
        this.renderOptionWithValue(x, y, width, height, hovered);
        this.tryRenderTooltip(mouseX, mouseY, hovered);
    }

    @Override
    protected String createValueLabel() {
        if (this.value == this.defaultValue) {
            return this.value ? TEXT_TRUE_DEFAULT : TEXT_FALSE_DEFAULT;
        }
        return this.value ? TEXT_TRUE : TEXT_FALSE;
    }

    @Override
    public String getCommentKey() {
        return BooleanElementWidget.jvmdowngrader$concat$getCommentKey$1(this.option.getName());
    }

    public String getValue() {
        return Boolean.toString(this.value);
    }

    private void queue() {
        Iris.getShaderPackOptionQueue().put(this.option.getName(), this.getValue());
    }

    @Override
    public boolean applyNextValue() {
        this.value = !this.value;
        this.queue();
        return true;
    }

    @Override
    public boolean applyPreviousValue() {
        return this.applyNextValue();
    }

    @Override
    public boolean applyOriginalValue() {
        this.value = this.option.getDefaultValue();
        this.queue();
        return true;
    }

    @Override
    public boolean isValueModified() {
        return this.value != this.appliedValue;
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$1(String string) {
        return "option." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getCommentKey$1(String string) {
        return "option." + string + ".comment";
    }
}

