/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseOptionElementWidget<T extends OptionMenuElement>
extends CommentedElementWidget<T> {
    protected static final String SET_TO_DEFAULT = I18n.func_135052_a((String)"options.iris.setToDefault", (Object[])new Object[0]);
    protected static final String DIVIDER = ": ";
    protected String unmodifiedLabel;
    protected ShaderPackScreen screen;
    protected NavigationController navigation;
    private String label;
    protected String trimmedLabel;
    protected String valueLabel;
    private boolean isLabelTrimmed;
    private int maxLabelWidth;
    private int valueSectionWidth;

    public BaseOptionElementWidget(T element) {
        super(element);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.screen = screen;
        this.navigation = navigation;
        this.valueLabel = null;
        this.trimmedLabel = null;
    }

    protected final void setLabel(String label) {
        this.label = BaseOptionElementWidget.jvmdowngrader$concat$setLabel$1(label);
        this.unmodifiedLabel = label;
    }

    protected final void updateRenderParams(int width, int minValueSectionWidth) {
        if (this.valueLabel == null) {
            this.valueLabel = this.createValueLabel();
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.valueSectionWidth = Math.max(minValueSectionWidth, font.func_78256_a(this.valueLabel) + 8);
        this.maxLabelWidth = width - 8 - this.valueSectionWidth;
        if (this.trimmedLabel == null || font.func_78256_a(this.label) > this.maxLabelWidth != this.isLabelTrimmed) {
            this.updateLabels();
        }
        this.isLabelTrimmed = font.func_78256_a(this.label) > this.maxLabelWidth;
    }

    protected final void renderOptionWithValue(int x, int y, int width, int height, boolean hovered, float sliderPosition, int sliderWidth) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(x, y, width, height, hovered, false);
        GuiUtil.drawButton(x + width - (this.valueSectionWidth + 2), y + 2, this.valueSectionWidth, height - 4, false, true);
        if (sliderPosition >= 0.0f) {
            int sliderSpace = this.valueSectionWidth - 4 - sliderWidth;
            int sliderPos = x + width - this.valueSectionWidth + (int)(sliderPosition * (float)sliderSpace);
            GuiUtil.drawButton(sliderPos, y + 4, sliderWidth, height - 8, false, false);
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_78261_a(this.trimmedLabel, x + 6, y + 7, 0xFFFFFF);
        font.func_78261_a(this.valueLabel, x + (width - 2) - (int)((double)this.valueSectionWidth * 0.5) - (int)((double)font.func_78256_a(this.valueLabel) * 0.5), y + 7, 0xFFFFFF);
    }

    protected final void renderOptionWithValue(int x, int y, int width, int height, boolean hovered) {
        this.renderOptionWithValue(x, y, width, height, hovered, -1.0f, 0);
    }

    protected final void tryRenderTooltip(int mouseX, int mouseY, boolean hovered) {
        if (GuiScreen.func_146272_n()) {
            this.renderTooltip(SET_TO_DEFAULT, mouseX, mouseY, hovered);
        } else if (this.isLabelTrimmed && !this.screen.isDisplayingComment()) {
            this.renderTooltip(this.unmodifiedLabel, mouseX, mouseY, hovered);
        }
    }

    protected final void renderTooltip(String text, int mouseX, int mouseY, boolean hovered) {
        if (hovered) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(Minecraft.func_71410_x().field_71466_p, text, mouseX + 2, mouseY - 16));
        }
    }

    protected final void updateLabels() {
        this.trimmedLabel = this.createTrimmedLabel();
        this.valueLabel = this.createValueLabel();
    }

    protected final String createTrimmedLabel() {
        String label = GuiUtil.shortenText(Minecraft.func_71410_x().field_71466_p, this.label, this.maxLabelWidth);
        if (this.isValueModified()) {
            label = BaseOptionElementWidget.jvmdowngrader$concat$createTrimmedLabel$1(label);
        }
        return label;
    }

    protected abstract String createValueLabel();

    public abstract boolean applyNextValue();

    public abstract boolean applyPreviousValue();

    public abstract boolean applyOriginalValue();

    public abstract boolean isValueModified();

    @Nullable
    public abstract String getCommentKey();

    @Override
    public Optional<String> getCommentTitle() {
        return Optional.of(this.unmodifiedLabel);
    }

    @Override
    public Optional<String> getCommentBody() {
        return Optional.ofNullable(this.getCommentKey()).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0]));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0 || button == 1) {
            boolean refresh = false;
            if (GuiScreen.func_146272_n()) {
                refresh = this.applyOriginalValue();
            }
            if (!refresh) {
                refresh = button == 0 ? this.applyNextValue() : this.applyPreviousValue();
            }
            if (refresh) {
                this.navigation.refresh();
            }
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private static /* synthetic */ String jvmdowngrader$concat$setLabel$1(String string) {
        return string + DIVIDER;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createTrimmedLabel$1(String string) {
        return string + " (*)";
    }
}

