/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_SequencedCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NavigationController {
    private ShaderPackOptionList optionList;
    private String currentScreen = null;
    private final Deque<String> history = new ArrayDeque<String>();

    public void back() {
        if (this.history.size() > 0) {
            J_U_SequencedCollection.removeLast(this.history);
            this.currentScreen = this.history.size() > 0 ? (String)J_U_SequencedCollection.getLast(this.history) : null;
        } else {
            this.currentScreen = null;
        }
        this.rebuild();
    }

    public void open(String screen) {
        this.currentScreen = screen;
        J_U_SequencedCollection.addLast(this.history, (Object)screen);
        this.rebuild();
    }

    public void rebuild() {
        if (this.optionList != null) {
            this.optionList.rebuild();
        }
    }

    public void refresh() {
        if (this.optionList != null) {
            this.optionList.refresh();
        }
    }

    public boolean hasHistory() {
        return this.history.size() > 0;
    }

    public void setActiveOptionList(ShaderPackOptionList optionList) {
        this.optionList = optionList;
    }

    @Generated
    public String getCurrentScreen() {
        return this.currentScreen;
    }
}

