/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MatrixUniform
extends Uniform {
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private Matrix4f cachedValue = null;
    private final Supplier<Matrix4f> value;

    MatrixUniform(int location, Supplier<Matrix4f> value) {
        super(location);
        this.value = value;
    }

    @Override
    public void update() {
        Matrix4f newValue = this.value.get();
        if (newValue == null) {
            throw new RuntimeException("MatrixUniform value is null");
        }
        if (!newValue.equals((Object)this.cachedValue)) {
            this.cachedValue = new Matrix4f((Matrix4fc)newValue);
            this.cachedValue.get(this.buffer);
            FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)this.buffer);
            RenderSystem.uniformMatrix4fv(this.location, false, this.buffer);
        }
    }
}

