/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.lwjgl.BufferUtils;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MatrixFromFloatArrayUniform
extends Uniform {
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private float[] cachedValue = null;
    private final Supplier<float[]> value;

    MatrixFromFloatArrayUniform(int location, Supplier<float[]> value) {
        super(location);
        this.value = value;
    }

    @Override
    public void update() {
        float[] newValue = this.value.get();
        if (!Arrays.equals(newValue, this.cachedValue)) {
            this.cachedValue = Arrays.copyOf(newValue, 16);
            this.buffer.put(this.cachedValue);
            FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.rewind((Buffer)this.buffer);
            RenderSystem.uniformMatrix4fv(this.location, false, this.buffer);
        }
    }
}

