/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.ByteBuffer;
import java.util.Optional;

public enum TextureType {
    TEXTURE_1D(3552),
    TEXTURE_2D(3553),
    TEXTURE_3D(32879),
    TEXTURE_RECTANGLE(34037);

    private final int glType;

    private TextureType(int glType) {
        this.glType = glType;
    }

    public static Optional<TextureType> fromString(String name) {
        try {
            return Optional.of(TextureType.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public int getGlType() {
        return this.glType;
    }

    public void apply(int texture, int sizeX, int sizeY, int sizeZ, int internalFormat, int format, int pixelType, ByteBuffer pixels) {
        switch (this.ordinal()) {
            case 0: {
                RenderSystem.texImage1D(texture, this.glType, 0, internalFormat, sizeX, 0, format, pixelType, pixels);
                break;
            }
            case 1: 
            case 3: {
                RenderSystem.texImage2D(texture, this.glType, 0, internalFormat, sizeX, sizeY, 0, format, pixelType, pixels);
                break;
            }
            case 2: {
                RenderSystem.texImage3D(texture, this.glType, 0, internalFormat, sizeX, sizeY, sizeZ, 0, format, pixelType, pixels);
            }
        }
    }
}

