/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.Locale;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.shader.ShaderType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GlShader
extends GlResource {
    private static final Logger LOGGER = LogManager.getLogger((String)"GlShader");
    private final String name;

    public GlShader(ShaderType type, String name, String src) {
        super(GlShader.createShader(type, name, src));
        this.name = name;
    }

    private static int createShader(ShaderType type, String name, String src) {
        int result;
        int handle = GL20.glCreateShader((int)type.id);
        GL20.glShaderSource((int)handle, (CharSequence)GlShader.jvmdowngrader$concat$createShader$1(src));
        GL20.glCompileShader((int)handle);
        GLDebug.nameObject(33505, handle, GlShader.jvmdowngrader$concat$createShader$1(name, type.name().toLowerCase(Locale.ROOT)));
        String log = RenderSystem.getShaderInfoLog(handle);
        if (!log.isEmpty()) {
            LOGGER.warn(GlShader.jvmdowngrader$concat$createShader$2(name, log));
        }
        if ((result = GL20.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        return handle;
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GL20.glDeleteShader((int)this.getGlId());
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$1(String string) {
        return string + "\u0000";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$1(String string, String string2) {
        return string + "(" + string2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$2(String string, String string2) {
        return "Shader compilation log for " + string + ": " + string2;
    }
}

