/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.sampler;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.texture.TextureType;

public class SamplerBinding {
    private final TextureType textureType;
    private final int textureUnit;
    private final IntSupplier texture;
    private final int sampler;
    private final ValueUpdateNotifier notifier;

    public SamplerBinding(TextureType type, int textureUnit, IntSupplier texture, GlSampler sampler, ValueUpdateNotifier notifier) {
        this.textureType = type;
        this.textureUnit = textureUnit;
        this.texture = texture;
        this.sampler = sampler == null ? 0 : sampler.getId();
        this.notifier = notifier;
    }

    public void update() {
        this.updateSampler();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateSampler);
        }
    }

    private void updateSampler() {
        RenderSystem.bindSamplerToUnit(this.textureUnit, this.sampler);
        RenderSystem.bindTextureToUnit(this.textureType.getGlType(), this.textureUnit, this.texture.getAsInt());
    }
}

