/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.image.ImageBinding;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.image.ImageLimits;
import net.coderbot.iris.gl.program.GlUniform1iCall;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import org.lwjgl.opengl.GL20;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Builder.class})
public class ProgramImages {
    private final ImmutableList<ImageBinding> imageBindings;
    private List<GlUniform1iCall> initializer;

    ProgramImages(ImmutableList<ImageBinding> imageBindings, List<GlUniform1iCall> initializer) {
        this.imageBindings = imageBindings;
        this.initializer = initializer;
    }

    public void update() {
        if (this.initializer != null) {
            for (GlUniform1iCall call : this.initializer) {
                RenderSystem.uniform1i(call.getLocation(), call.getValue());
            }
            this.initializer = null;
        }
        for (ImageBinding imageBinding : this.imageBindings) {
            imageBinding.update();
        }
    }

    public int getActiveImages() {
        return this.imageBindings.size();
    }

    public static Builder builder(int program) {
        return new Builder(program);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ProgramImages.class)
    public static final class Builder
    implements ImageHolder {
        private final int program;
        private final ImmutableList.Builder<ImageBinding> images;
        private final List<GlUniform1iCall> calls;
        private int nextImageUnit;
        private final int maxImageUnits;

        Builder(int program) {
            this.program = program;
            this.images = ImmutableList.builder();
            this.calls = new ArrayList<GlUniform1iCall>();
            this.nextImageUnit = 0;
            this.maxImageUnits = ImageLimits.get().getMaxImageUnits();
        }

        @Override
        public boolean hasImage(String name) {
            return GL20.glGetUniformLocation((int)this.program, (CharSequence)name) != -1;
        }

        @Override
        public void addTextureImage(IntSupplier textureID, InternalTextureFormat internalFormat, String name) {
            int location = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
            if (location == -1) {
                return;
            }
            if (this.nextImageUnit >= this.maxImageUnits) {
                if (this.maxImageUnits == 0) {
                    throw new IllegalStateException(Builder.jvmdowngrader$concat$addTextureImage$1(name));
                }
                throw new IllegalStateException(Builder.jvmdowngrader$concat$addTextureImage$1(name, this.maxImageUnits));
            }
            if (internalFormat == InternalTextureFormat.RGBA) {
                internalFormat = InternalTextureFormat.RGBA8;
            }
            this.images.add((Object)new ImageBinding(this.nextImageUnit, internalFormat.getGlFormat(), textureID));
            this.calls.add(new GlUniform1iCall(location, this.nextImageUnit));
            ++this.nextImageUnit;
        }

        public ProgramImages build() {
            return new ProgramImages((ImmutableList<ImageBinding>)this.images.build(), this.calls);
        }

        private static /* synthetic */ String jvmdowngrader$concat$addTextureImage$1(String string) {
            return "Image units are not supported on this platform, but a shader program attempted to reference " + string + ".";
        }

        private static /* synthetic */ String jvmdowngrader$concat$addTextureImage$1(String string, int n) {
            return "No more available texture units while activating image " + string + ". Only " + n + " image units are available.";
        }
    }
}

