/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.ArrayList;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.shader.GlShader;
import net.coderbot.iris.gl.shader.ProgramCreator;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.TextureType;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProgramBuilder
extends ProgramUniforms.Builder
implements SamplerHolder,
ImageHolder {
    private final int program;
    private final ProgramSamplers.Builder samplers;
    private final ProgramImages.Builder images;

    private ProgramBuilder(String name, int program, ImmutableSet<Integer> reservedTextureUnits) {
        super(name, program);
        this.program = program;
        this.samplers = ProgramSamplers.builder(program, reservedTextureUnits);
        this.images = ProgramImages.builder(program);
    }

    public void bindAttributeLocation(int index, String name) {
        RenderSystem.bindAttributeLocation(this.program, index, name);
    }

    public static ProgramBuilder begin(String name, @Nullable String vertexSource, @Nullable String geometrySource, @Nullable String fragmentSource, ImmutableSet<Integer> reservedTextureUnits) {
        return ProgramBuilder.begin(name, vertexSource, geometrySource, null, null, fragmentSource, reservedTextureUnits);
    }

    public static ProgramBuilder begin(String name, @Nullable String vertexSource, @Nullable String geometrySource, @Nullable String tessControlSource, @Nullable String tessEvalSource, @Nullable String fragmentSource, ImmutableSet<Integer> reservedTextureUnits) {
        GlShader vertex = ProgramBuilder.buildShader(ShaderType.VERTEX, ProgramBuilder.jvmdowngrader$concat$begin$1(name), vertexSource);
        GlShader geometry = geometrySource != null ? ProgramBuilder.buildShader(ShaderType.GEOMETRY, ProgramBuilder.jvmdowngrader$concat$begin$2(name), geometrySource) : null;
        GlShader tessControl = tessControlSource != null ? ProgramBuilder.buildShader(ShaderType.TESSELATION_CONTROL, ProgramBuilder.jvmdowngrader$concat$begin$3(name), tessControlSource) : null;
        GlShader tessEval = tessEvalSource != null ? ProgramBuilder.buildShader(ShaderType.TESSELATION_EVAL, ProgramBuilder.jvmdowngrader$concat$begin$4(name), tessEvalSource) : null;
        GlShader fragment = ProgramBuilder.buildShader(ShaderType.FRAGMENT, ProgramBuilder.jvmdowngrader$concat$begin$5(name), fragmentSource);
        ArrayList<GlShader> shaders = new ArrayList<GlShader>();
        shaders.add(vertex);
        if (geometry != null) {
            shaders.add(geometry);
        }
        if (tessControl != null) {
            shaders.add(tessControl);
        }
        if (tessEval != null) {
            shaders.add(tessEval);
        }
        shaders.add(fragment);
        int programId = ProgramCreator.create(name, shaders.toArray(new GlShader[0]));
        for (GlShader shader : shaders) {
            shader.destroy();
        }
        return new ProgramBuilder(name, programId, reservedTextureUnits);
    }

    public static ProgramBuilder beginCompute(String name, @Nullable String source, ImmutableSet<Integer> reservedTextureUnits) {
        if (!RenderSystem.supportsCompute()) {
            throw new IllegalStateException("This PC does not support compute shaders, but it's attempting to be used???");
        }
        GlShader compute = ProgramBuilder.buildShader(ShaderType.COMPUTE, ProgramBuilder.jvmdowngrader$concat$beginCompute$1(name), source);
        int programId = ProgramCreator.create(name, compute);
        compute.destroy();
        return new ProgramBuilder(name, programId, reservedTextureUnits);
    }

    public Program build() {
        return new Program(this.program, super.buildUniforms(), this.samplers.build(), this.images.build());
    }

    public ComputeProgram buildCompute() {
        return new ComputeProgram(this.program, super.buildUniforms(), this.samplers.build(), this.images.build());
    }

    private static GlShader buildShader(ShaderType shaderType, String name, @Nullable String source) {
        try {
            return new GlShader(shaderType, name, source);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(ProgramBuilder.jvmdowngrader$concat$buildShader$1(String.valueOf((Object)shaderType), name), e);
        }
    }

    @Override
    public void addExternalSampler(int textureUnit, String ... names) {
        this.samplers.addExternalSampler(textureUnit, names);
    }

    @Override
    public boolean hasSampler(String name) {
        return this.samplers.hasSampler(name);
    }

    @Override
    public boolean addDefaultSampler(TextureType type, IntSupplier texture, ValueUpdateNotifier notifier, GlSampler sampler, String ... names) {
        return this.samplers.addDefaultSampler(type, texture, notifier, sampler, names);
    }

    @Override
    public boolean addDynamicSampler(TextureType type, IntSupplier texture, GlSampler sampler, String ... names) {
        return this.samplers.addDynamicSampler(type, texture, sampler, names);
    }

    @Override
    public boolean addDynamicSampler(TextureType type, IntSupplier texture, ValueUpdateNotifier notifier, GlSampler sampler, String ... names) {
        return this.samplers.addDynamicSampler(type, texture, notifier, sampler, names);
    }

    @Override
    public boolean hasImage(String name) {
        return this.images.hasImage(name);
    }

    @Override
    public void addTextureImage(IntSupplier textureID, InternalTextureFormat internalFormat, String name) {
        this.images.addTextureImage(textureID, internalFormat, name);
    }

    private static /* synthetic */ String jvmdowngrader$concat$begin$1(String string) {
        return string + ".vsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$begin$2(String string) {
        return string + ".gsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$begin$3(String string) {
        return string + ".tcs";
    }

    private static /* synthetic */ String jvmdowngrader$concat$begin$4(String string) {
        return string + ".tes";
    }

    private static /* synthetic */ String jvmdowngrader$concat$begin$5(String string) {
        return string + ".fsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$beginCompute$1(String string) {
        return string + ".csh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$buildShader$1(String string, String string2) {
        return "Failed to compile " + string + " shader for program " + string2;
    }
}

