/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.IntBuffer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.FilledIndirectPointer;
import org.joml.Vector2f;
import org.joml.Vector3i;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public final class ComputeProgram
extends GlResource {
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private Vector3i absoluteWorkGroups;
    private Vector2f relativeWorkGroups;
    private FilledIndirectPointer indirectPointer;
    private final IntBuffer localSizeBuffer = BufferUtils.createIntBuffer((int)3);
    private float cachedWidth;
    private float cachedHeight;
    private Vector3i cachedWorkGroups;

    ComputeProgram(int program, ProgramUniforms uniforms, ProgramSamplers samplers, ProgramImages images) {
        super(program);
        RenderSystem.getProgramiv(program, 33383, this.localSizeBuffer);
        this.uniforms = uniforms;
        this.samplers = samplers;
        this.images = images;
    }

    public void setWorkGroupInfo(Vector2f relativeWorkGroups, Vector3i absoluteWorkGroups, FilledIndirectPointer indirectPointer) {
        this.relativeWorkGroups = relativeWorkGroups;
        this.absoluteWorkGroups = absoluteWorkGroups;
        this.indirectPointer = indirectPointer;
    }

    public Vector3i getWorkGroups(float width, float height) {
        if (this.indirectPointer != null) {
            return null;
        }
        if (this.cachedWidth != width || this.cachedHeight != height || this.cachedWorkGroups == null) {
            this.cachedWidth = width;
            this.cachedHeight = height;
            this.cachedWorkGroups = this.absoluteWorkGroups != null ? this.absoluteWorkGroups : (this.relativeWorkGroups != null ? new Vector3i((int)Math.ceil(Math.ceil(width * this.relativeWorkGroups.x) / (double)this.localSizeBuffer.get(0)), (int)Math.ceil(Math.ceil(height * this.relativeWorkGroups.y) / (double)this.localSizeBuffer.get(1)), 1) : new Vector3i((int)Math.ceil(width / (float)this.localSizeBuffer.get(0)), (int)Math.ceil(height / (float)this.localSizeBuffer.get(1)), 1));
        }
        return this.cachedWorkGroups;
    }

    public void use() {
        GL20.glUseProgram((int)this.getGlId());
        this.uniforms.update();
        this.samplers.update();
        this.images.update();
    }

    public void dispatch(float width, float height) {
        if (!Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::allowConcurrentCompute).orElse(false).booleanValue()) {
            RenderSystem.memoryBarrier(8232);
        }
        if (this.indirectPointer != null) {
            RenderSystem.bindBuffer(37102, this.indirectPointer.buffer());
            RenderSystem.dispatchComputeIndirect(this.indirectPointer.offset());
        } else {
            RenderSystem.dispatchCompute(this.getWorkGroups(width, height));
        }
    }

    public static void unbind() {
        ProgramUniforms.clearActiveUniforms();
        GL20.glUseProgram((int)0);
    }

    @Override
    public void destroyInternal() {
        GL20.glDeleteProgram((int)this.getGlId());
    }

    @Deprecated
    public int getProgramId() {
        return this.getGlId();
    }

    public int getActiveImages() {
        return this.images.getActiveImages();
    }
}

