/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.image;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.texture.TextureType;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Relative.class})
public class GlImage
extends GlObject {
    protected final String name;
    protected final String samplerName;
    protected final TextureType target;
    protected final PixelFormat format;
    protected final InternalTextureFormat internalTextureFormat;
    protected final PixelType pixelType;
    private final boolean clear;

    public GlImage(String name, String samplerName, TextureType target, PixelFormat format, InternalTextureFormat internalFormat, PixelType pixelType, boolean clear, int width, int height, int depth) {
        this.setHandle(RenderSystem.createTexture(target.getGlType()));
        this.name = name;
        this.samplerName = samplerName;
        this.target = target;
        this.format = format;
        this.internalTextureFormat = internalFormat;
        this.pixelType = pixelType;
        this.clear = clear;
        GLDebug.nameObject(5890, this.handle(), name);
        GL11.glBindTexture((int)target.getGlType(), (int)this.handle());
        target.apply(this.handle(), width, height, depth, internalFormat.getGlFormat(), format.getGlFormat(), pixelType.getGlFormat(), null);
        int texture = this.handle();
        this.setup(texture, width, height, depth);
        GL11.glBindTexture((int)target.getGlType(), (int)0);
    }

    protected void setup(int texture, int width, int height, int depth) {
        boolean isInteger = this.internalTextureFormat.getPixelFormat().isInteger();
        RenderSystem.texParameteri(texture, this.target.getGlType(), 10241, isInteger ? 9728 : 9729);
        RenderSystem.texParameteri(texture, this.target.getGlType(), 10240, isInteger ? 9728 : 9729);
        RenderSystem.texParameteri(texture, this.target.getGlType(), 10242, 33071);
        if (height > 0) {
            RenderSystem.texParameteri(texture, this.target.getGlType(), 10243, 33071);
        }
        if (depth > 0) {
            RenderSystem.texParameteri(texture, this.target.getGlType(), 32882, 33071);
        }
        RenderSystem.texParameteri(texture, this.target.getGlType(), 33085, 0);
        RenderSystem.texParameteri(texture, this.target.getGlType(), 33082, 0);
        RenderSystem.texParameteri(texture, this.target.getGlType(), 33083, 0);
        RenderSystem.texParameterf(texture, this.target.getGlType(), 34049, 0.0f);
        RenderSystem.clearTexImage(texture, this.target.getGlType(), 0, this.format.getGlFormat(), this.pixelType.getGlFormat());
    }

    public String getName() {
        return this.name;
    }

    public String getSamplerName() {
        return this.samplerName;
    }

    public TextureType getTarget() {
        return this.target;
    }

    public boolean shouldClear() {
        return this.clear;
    }

    public int getId() {
        return this.handle();
    }

    public void clear() {
        RenderSystem.clearTexImage(this.handle(), this.target.getGlType(), 0, this.format.getGlFormat(), this.pixelType.getGlFormat());
    }

    public void updateNewSize(int width, int height) {
    }

    @Override
    protected void destroyInternal() {
        GLStateManager.glDeleteTextures(this.handle());
    }

    public InternalTextureFormat getInternalFormat() {
        return this.internalTextureFormat;
    }

    public String toString() {
        return GlImage.jvmdowngrader$concat$toString$1(this.name, String.valueOf((Object)this.format), String.valueOf((Object)this.internalTextureFormat), String.valueOf((Object)this.pixelType));
    }

    public PixelFormat getFormat() {
        return this.format;
    }

    public PixelType getPixelType() {
        return this.pixelType;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
        return "GlImage name " + string + " format " + string2 + "internalformat " + string3 + " pixeltype " + string4;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=GlImage.class)
    public static class Relative
    extends GlImage {
        private final float relativeHeight;
        private final float relativeWidth;

        public Relative(String name, String samplerName, PixelFormat format, InternalTextureFormat internalFormat, PixelType pixelType, boolean clear, float relativeWidth, float relativeHeight, int currentWidth, int currentHeight) {
            super(name, samplerName, TextureType.TEXTURE_2D, format, internalFormat, pixelType, clear, (int)((float)currentWidth * relativeWidth), (int)((float)currentHeight * relativeHeight), 0);
            this.relativeWidth = relativeWidth;
            this.relativeHeight = relativeHeight;
        }

        @Override
        public void updateNewSize(int width, int height) {
            GL11.glBindTexture((int)this.target.getGlType(), (int)this.handle());
            this.target.apply(this.handle(), (int)((float)width * this.relativeWidth), (int)((float)height * this.relativeHeight), 0, this.internalTextureFormat.getGlFormat(), this.format.getGlFormat(), this.pixelType.getGlFormat(), null);
            int texture = this.handle();
            this.setup(texture, width, height, 0);
            GL11.glBindTexture((int)this.target.getGlType(), (int)0);
        }
    }
}

