/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import net.coderbot.iris.gl.buffer.ShaderStorageBuffer;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import org.lwjgl.opengl.GL15;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={OutOfVideoMemoryError.class})
public class ShaderStorageBufferHolder {
    private int cachedWidth;
    private int cachedHeight;
    private ShaderStorageBuffer[] buffers;
    private boolean destroyed = false;

    public ShaderStorageBufferHolder(Int2ObjectArrayMap<ShaderStorageInfo> overrides, int width, int height) {
        this.cachedWidth = width;
        this.cachedHeight = height;
        this.buffers = new ShaderStorageBuffer[(Integer)Collections.max(overrides.keySet()) + 1];
        overrides.forEach((index, bufferInfo) -> {
            if ((long)bufferInfo.size() > RenderSystem.getVRAM()) {
                throw new OutOfVideoMemoryError(ShaderStorageBufferHolder.jvmdowngrader$concat$lambda$new$0$1(ShaderStorageBufferHolder.toMib(RenderSystem.getVRAM()), bufferInfo.size()));
            }
            if (index > SamplerLimits.get().getMaxShaderStorageUnits()) {
                throw new IllegalStateException(ShaderStorageBufferHolder.jvmdowngrader$concat$lambda$new$0$1(index, SamplerLimits.get().getMaxShaderStorageUnits()));
            }
            this.buffers[index.intValue()] = new ShaderStorageBuffer((int)index, (ShaderStorageInfo)((Object)bufferInfo));
            int buffer = this.buffers[index].getId();
            if (bufferInfo.relative()) {
                this.buffers[index].resizeIfRelative(width, height);
            } else {
                GL15.glBindBuffer((int)37074, (int)buffer);
                RenderSystem.bufferStorage(37074, bufferInfo.size(), 0);
                RenderSystem.clearBufferSubData(37074, 33321, 0L, bufferInfo.size(), 6403, 5120, new int[]{0});
                RenderSystem.bindBufferBase(37074, index, buffer);
            }
        });
        GL15.glBindBuffer((int)37074, (int)0);
    }

    private static long toMib(long x) {
        return x / 1024L / 1024L;
    }

    public void hasResizedScreen(int width, int height) {
        if (width != this.cachedWidth || height != this.cachedHeight) {
            this.cachedWidth = width;
            this.cachedHeight = height;
            for (ShaderStorageBuffer buffer : this.buffers) {
                if (buffer == null) continue;
                buffer.resizeIfRelative(width, height);
            }
        }
    }

    public void setupBuffers() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed buffer objects");
        }
        for (ShaderStorageBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            buffer.bind();
        }
    }

    public int getBufferIndex(int index) {
        if (this.buffers.length < index || this.buffers[index] == null) {
            throw new RuntimeException("Tried to query a buffer for indirect dispatch that doesn't exist!");
        }
        return this.buffers[index].getId();
    }

    public void destroyBuffers() {
        for (ShaderStorageBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            buffer.destroy();
        }
        this.buffers = null;
        this.destroyed = true;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$1(long l, int n) {
        return "We only have " + l + "MiB of RAM to work with, but the pack is requesting " + n + "! Can't continue.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$1(Integer n, int n2) {
        return "We don't have enough SSBO units??? (index: " + n + ", max: " + n2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=ShaderStorageBufferHolder.class)
    private static class OutOfVideoMemoryError
    extends RuntimeException {
        public OutOfVideoMemoryError(String s) {
            super(s);
        }
    }
}

