/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.client;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IrisDebugScreenHandler {
    public static final IrisDebugScreenHandler INSTANCE = new IrisDebugScreenHandler();
    private static final List<BufferPoolMXBean> iris$pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    private static final BufferPoolMXBean iris$directPool;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && !AngelicaConfig.disableF3Additions) {
            event.right.add(Math.min(event.right.size(), 2), IrisDebugScreenHandler.jvmdowngrader$concat$onRenderGameOverlayTextEvent$1(IrisDebugScreenHandler.iris$humanReadableByteCountBin(iris$directPool.getMemoryUsed())));
            if (Iris.getIrisConfig().areShadersEnabled()) {
                event.right.add(IrisDebugScreenHandler.jvmdowngrader$concat$onRenderGameOverlayTextEvent$1(Iris.getCurrentPackName(), Iris.isFallback() ? " (fallback)" : ""));
                Iris.getCurrentPack().ifPresent(pack -> event.right.add(IrisDebugScreenHandler.jvmdowngrader$concat$lambda$onRenderGameOverlayTextEvent$0$1(pack.getProfileInfo())));
            } else {
                event.right.add("[AngelicaShaders] Shaders are disabled");
            }
            if (AngelicaConfig.speedupAnimations) {
                event.right.add(Math.min(event.right.size(), 9), IrisDebugScreenHandler.jvmdowngrader$concat$onRenderGameOverlayTextEvent$2(String.valueOf(AngelicaMod.animationsMode)));
            }
            Iris.getPipelineManager().getPipeline().ifPresent(pipeline -> pipeline.addDebugText(event.left));
        }
    }

    private static String iris$humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return IrisDebugScreenHandler.jvmdowngrader$concat$iris$humanReadableByteCountBin$1(bytes);
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.3f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    static {
        BufferPoolMXBean found = null;
        for (BufferPoolMXBean pool : iris$pools) {
            if (!pool.getName().equals("direct")) continue;
            found = pool;
            break;
        }
        iris$directPool = Objects.requireNonNull(found);
    }

    private static /* synthetic */ String jvmdowngrader$concat$onRenderGameOverlayTextEvent$1(String string) {
        return "Direct Buffers: +" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onRenderGameOverlayTextEvent$1(String string, String string2) {
        return "[AngelicaShaders] Shaderpack: " + string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onRenderGameOverlayTextEvent$2(String string) {
        return "animationsMode: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$iris$humanReadableByteCountBin$1(long l) {
        return l + " B";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$onRenderGameOverlayTextEvent$0$1(String string) {
        return "[AngelicaShaders] " + string;
    }
}

