/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.celeritas;

import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum IrisTerrainPass {
    SHADOW("shadow"),
    SHADOW_CUTOUT("shadow"),
    GBUFFER_SOLID("gbuffers_terrain"),
    GBUFFER_CUTOUT("gbuffers_terrain_cutout"),
    GBUFFER_TRANSLUCENT("gbuffers_water");

    public static final IrisTerrainPass[] VALUES;
    private final String name;

    private IrisTerrainPass(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isShadow() {
        return this == SHADOW || this == SHADOW_CUTOUT;
    }

    public TerrainRenderPass toTerrainPass(RenderPassConfiguration<?> config) {
        TerrainRenderPass terrainRenderPass;
        switch (this.ordinal()) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case 0: 
            case 2: {
                terrainRenderPass = config.defaultSolidMaterial().pass;
                break;
            }
            case 1: 
            case 3: {
                terrainRenderPass = config.defaultCutoutMippedMaterial().pass;
                break;
            }
            case 4: {
                terrainRenderPass = config.defaultTranslucentMaterial().pass;
            }
        }
        return terrainRenderPass;
    }

    public static IrisTerrainPass fromTerrainPass(TerrainRenderPass pass, boolean isShadow) {
        if (isShadow) {
            return pass.supportsFragmentDiscard() ? SHADOW_CUTOUT : SHADOW;
        }
        if (pass.supportsFragmentDiscard()) {
            return GBUFFER_CUTOUT;
        }
        if (pass.isReverseOrder()) {
            return GBUFFER_TRANSLUCENT;
        }
        return GBUFFER_SOLID;
    }

    static {
        VALUES = IrisTerrainPass.values();
    }
}

