/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.celeritas;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.celeritas.CeleritasTerrainPipeline;
import net.coderbot.iris.celeritas.IrisCeleritasChunkShaderInterface;
import net.coderbot.iris.celeritas.IrisTerrainPass;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.shadows.ShadowRenderingState;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttribute;
import org.embeddedt.embeddium.impl.gl.shader.GlProgram;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IrisCeleritasChunkProgramOverrides {
    private final EnumMap<IrisTerrainPass, GlProgram<IrisCeleritasChunkShaderInterface>> programs = new EnumMap(IrisTerrainPass.class);
    private boolean shadersCreated = false;
    private int versionCounterForShaderReload = -1;

    @Nullable
    private GlShader createVertexShader(IrisTerrainPass pass, CeleritasTerrainPipeline pipeline) {
        CeleritasTerrainPipeline.PassInfo info = pipeline.getPassInfo(pass);
        Optional<String> source = info.sources().get((Object)PatchShaderType.VERTEX);
        return source.map(s -> new GlShader(ShaderType.VERTEX, IrisCeleritasChunkProgramOverrides.jvmdowngrader$concat$lambda$createVertexShader$0$1(pass.toString().toLowerCase(Locale.ROOT)), (String)s)).orElse(null);
    }

    @Nullable
    private GlShader createGeometryShader(IrisTerrainPass pass, CeleritasTerrainPipeline pipeline) {
        CeleritasTerrainPipeline.PassInfo info = pipeline.getPassInfo(pass);
        Optional<String> source = info.sources().get((Object)PatchShaderType.GEOMETRY);
        return source.map(s -> new GlShader(ShaderType.GEOM, IrisCeleritasChunkProgramOverrides.jvmdowngrader$concat$lambda$createGeometryShader$0$1(pass.toString().toLowerCase(Locale.ROOT)), (String)s)).orElse(null);
    }

    @Nullable
    private GlShader createFragmentShader(IrisTerrainPass pass, CeleritasTerrainPipeline pipeline) {
        CeleritasTerrainPipeline.PassInfo info = pipeline.getPassInfo(pass);
        Optional<String> source = info.sources().get((Object)PatchShaderType.FRAGMENT);
        return source.map(s -> new GlShader(ShaderType.FRAGMENT, IrisCeleritasChunkProgramOverrides.jvmdowngrader$concat$lambda$createFragmentShader$0$1(pass.toString().toLowerCase(Locale.ROOT)), (String)s)).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GlProgram<IrisCeleritasChunkShaderInterface> createShader(IrisTerrainPass pass, CeleritasTerrainPipeline pipeline, RenderPassConfiguration<?> configuration) {
        GlShader vertShader = this.createVertexShader(pass, pipeline);
        GlShader geomShader = this.createGeometryShader(pass, pipeline);
        GlShader fragShader = this.createFragmentShader(pass, pipeline);
        if (vertShader == null || fragShader == null) {
            if (vertShader != null) {
                vertShader.delete();
            }
            if (geomShader != null) {
                geomShader.delete();
            }
            if (fragShader != null) {
                fragShader.delete();
            }
            return null;
        }
        try {
            GlProgram.Builder builder = GlProgram.builder(IrisCeleritasChunkProgramOverrides.jvmdowngrader$concat$createShader$1(pass.getName()));
            builder.attachShader(vertShader);
            if (geomShader != null) {
                builder.attachShader(geomShader);
            }
            builder.attachShader(fragShader);
            ChunkVertexType vertexType = pass.toTerrainPass(configuration).vertexType();
            int attrIndex = 0;
            for (GlVertexAttribute attr : vertexType.getVertexFormat().getAttributes()) {
                builder.bindAttribute(attr.getName(), attrIndex++);
            }
            CeleritasTerrainPipeline.PassInfo passInfo = pipeline.getPassInfo(pass);
            BlendModeOverride blendOverride = passInfo.blendModeOverride();
            GlProgram<IrisCeleritasChunkShaderInterface> glProgram = builder.link(context -> new IrisCeleritasChunkShaderInterface(((GlObject)((Object)context)).handle(), (ShaderBindingContext)context, pipeline, pass.isShadow(), blendOverride, pipeline.getCustomUniforms()));
            return glProgram;
        }
        finally {
            vertShader.delete();
            if (geomShader != null) {
                geomShader.delete();
            }
            fragShader.delete();
        }
    }

    public void createShaders(CeleritasTerrainPipeline pipeline, RenderPassConfiguration<?> configuration) {
        if (pipeline != null) {
            for (IrisTerrainPass pass : IrisTerrainPass.VALUES) {
                if (pass.isShadow() && !pipeline.hasShadowPass()) {
                    this.programs.put(pass, null);
                    continue;
                }
                this.programs.put(pass, this.createShader(pass, pipeline, configuration));
            }
        } else {
            this.deleteShaders();
        }
        this.shadersCreated = true;
    }

    @Nullable
    public GlProgram<? extends ChunkShaderInterface> getProgramOverride(TerrainRenderPass pass, RenderPassConfiguration<?> configuration) {
        if (this.versionCounterForShaderReload != Iris.getPipelineManager().getVersionCounterForSodiumShaderReload()) {
            this.versionCounterForShaderReload = Iris.getPipelineManager().getVersionCounterForSodiumShaderReload();
            this.deleteShaders();
        }
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().getPipelineNullable();
        CeleritasTerrainPipeline celeritasPipeline = null;
        if (worldPipeline != null) {
            celeritasPipeline = worldPipeline.getCeleritasTerrainPipeline();
        }
        if (!this.shadersCreated) {
            this.createShaders(celeritasPipeline, configuration);
        }
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (celeritasPipeline != null && !celeritasPipeline.hasShadowPass()) {
                throw new IllegalStateException("Shadow program requested, but shader pack has no shadow pass");
            }
            return this.programs.get((Object)(pass.supportsFragmentDiscard() ? IrisTerrainPass.SHADOW_CUTOUT : IrisTerrainPass.SHADOW));
        }
        if (pass.supportsFragmentDiscard()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_CUTOUT);
        }
        if (pass.isReverseOrder()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_TRANSLUCENT);
        }
        return this.programs.get((Object)IrisTerrainPass.GBUFFER_SOLID);
    }

    public void deleteShaders() {
        for (GlProgram<IrisCeleritasChunkShaderInterface> program : this.programs.values()) {
            if (program == null) continue;
            program.delete();
        }
        this.programs.clear();
        this.shadersCreated = false;
    }

    private static /* synthetic */ String jvmdowngrader$concat$createShader$1(String string) {
        return "iris:celeritas-chunk-" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$createFragmentShader$0$1(String string) {
        return "iris:celeritas-terrain-" + string + ".fsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$createGeometryShader$0$1(String string) {
        return "iris:celeritas-terrain-" + string + ".gsh";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$createVertexShader$0$1(String string) {
        return "iris:celeritas-terrain-" + string + ".vsh";
    }
}

