/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.celeritas;

import com.google.common.collect.ImmutableSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.celeritas.IrisTerrainPass;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.state.FogMode;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class, PassInfo.class})
public class CeleritasTerrainPipeline {
    private final EnumMap<IrisTerrainPass, PassInfo> passInfoMap = new EnumMap(IrisTerrainPass.class);
    private final CustomUniforms customUniforms;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;

    public CeleritasTerrainPipeline(IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, IntFunction<ProgramImages> createTerrainImages, IntFunction<ProgramImages> createShadowImages, CustomUniforms customUniforms, Optional<ProgramSource> terrainSource, Optional<ProgramSource> translucentSource, Optional<ProgramSource> shadowSource, CompletableFuture<Map<PatchShaderType, String>> terrainFuture, CompletableFuture<Map<PatchShaderType, String>> translucentFuture, CompletableFuture<Map<PatchShaderType, String>> shadowFuture, RenderTargets renderTargets, ImmutableSet<Integer> flippedAfterPrepare, ImmutableSet<Integer> flippedAfterTranslucent, @Nullable GlFramebuffer shadowFramebuffer) {
        this.customUniforms = customUniforms;
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
        this.createTerrainImages = createTerrainImages;
        this.createShadowImages = createShadowImages;
        EnumMap<IrisTerrainPass, Optional<ProgramSource>> gbufferProgramSource = new EnumMap<IrisTerrainPass, Optional<ProgramSource>>(IrisTerrainPass.class);
        gbufferProgramSource.put(IrisTerrainPass.GBUFFER_SOLID, terrainSource);
        gbufferProgramSource.put(IrisTerrainPass.GBUFFER_CUTOUT, terrainSource);
        gbufferProgramSource.put(IrisTerrainPass.GBUFFER_TRANSLUCENT, translucentSource.isPresent() ? translucentSource : terrainSource);
        gbufferProgramSource.put(IrisTerrainPass.SHADOW, shadowSource);
        for (IrisTerrainPass pass : IrisTerrainPass.VALUES) {
            float f;
            BlendModeOverride blendModeOverride;
            PassInfo passInfo = new PassInfo();
            this.passInfoMap.put(pass, passInfo);
            if (pass == IrisTerrainPass.SHADOW || pass == IrisTerrainPass.SHADOW_CUTOUT) {
                passInfo.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$framebuffer(shadowFramebuffer);
            } else if (renderTargets != null) {
                ImmutableSet<Integer> flipped = pass == IrisTerrainPass.GBUFFER_TRANSLUCENT ? flippedAfterTranslucent : flippedAfterPrepare;
                Optional programSource = (Optional)gbufferProgramSource.get((Object)pass);
                xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional.ifPresentOrElse((Optional)programSource, source -> passInfo.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$framebuffer(renderTargets.createGbufferFramebuffer(flipped, source.getDirectives().getDrawBuffers())), () -> passInfo.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$framebuffer(renderTargets.createGbufferFramebuffer(flipped, new int[]{0})));
            }
            switch (pass) {
                case GBUFFER_TRANSLUCENT: {
                    blendModeOverride = null;
                    break;
                }
                default: {
                    blendModeOverride = BlendModeOverride.OFF;
                }
            }
            passInfo.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$blendModeOverride(blendModeOverride);
            switch (pass) {
                case GBUFFER_CUTOUT: 
                case SHADOW_CUTOUT: {
                    f = 0.1f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            passInfo.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$alphaReference(f);
        }
        this.processShaderFuture(terrainFuture, terrainSource, this.passInfoMap.get((Object)IrisTerrainPass.GBUFFER_SOLID), this.passInfoMap.get((Object)IrisTerrainPass.GBUFFER_CUTOUT));
        this.processShaderFuture(translucentFuture, translucentSource, this.passInfoMap.get((Object)IrisTerrainPass.GBUFFER_TRANSLUCENT));
        this.processShaderFuture(shadowFuture, shadowSource, this.passInfoMap.get((Object)IrisTerrainPass.SHADOW), this.passInfoMap.get((Object)IrisTerrainPass.SHADOW_CUTOUT));
    }

    private void processShaderFuture(@Nullable CompletableFuture<Map<PatchShaderType, String>> future, Optional<ProgramSource> source, PassInfo ... targets) {
        if (future == null || J_U_Optional.isEmpty(source)) {
            return;
        }
        String sourceName = source.get().getName();
        try {
            Map<PatchShaderType, String> result = future.join();
            for (PassInfo target : targets) {
                target.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$setSource(PatchShaderType.VERTEX, result.get((Object)PatchShaderType.VERTEX));
                target.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$setSource(PatchShaderType.GEOMETRY, result.get((Object)PatchShaderType.GEOMETRY));
                target.jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$setSource(PatchShaderType.FRAGMENT, result.get((Object)PatchShaderType.FRAGMENT));
            }
            PatchedShaderPrinter.debugPatchedShaders(CeleritasTerrainPipeline.jvmdowngrader$concat$processShaderFuture$1(sourceName), result.get((Object)PatchShaderType.VERTEX), result.get((Object)PatchShaderType.GEOMETRY), result.get((Object)PatchShaderType.FRAGMENT));
        }
        catch (Exception e) {
            Iris.logger.error("Failed to transform shader for Celeritas: {}", sourceName, e);
            throw new RuntimeException(CeleritasTerrainPipeline.jvmdowngrader$concat$processShaderFuture$2(sourceName), e);
        }
    }

    public PassInfo getPassInfo(IrisTerrainPass pass) {
        return this.passInfoMap.get((Object)pass);
    }

    public ProgramUniforms.Builder initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<celeritas shaders>", programId);
        CommonUniforms.addDynamicUniforms(uniforms, FogMode.PER_VERTEX);
        this.customUniforms.assignTo(uniforms);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms;
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    public ProgramImages initTerrainImages(int programId) {
        return this.createTerrainImages.apply(programId);
    }

    public ProgramImages initShadowImages(int programId) {
        return this.createShadowImages.apply(programId);
    }

    @Generated
    public CustomUniforms getCustomUniforms() {
        return this.customUniforms;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processShaderFuture$1(String string) {
        return string + "_celeritas";
    }

    private static /* synthetic */ String jvmdowngrader$concat$processShaderFuture$2(String string) {
        return "Shader transformation failed for " + string;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=CeleritasTerrainPipeline.class)
    public static final class PassInfo {
        private final EnumMap<PatchShaderType, Optional<String>> sources = new EnumMap(PatchShaderType.class);
        private GlFramebuffer framebuffer;
        private BlendModeOverride blendModeOverride;
        private float alphaReference;

        PassInfo() {
            for (PatchShaderType type : PatchShaderType.VALUES) {
                this.sources.put(type, Optional.empty());
            }
        }

        private void setSource(PatchShaderType type, @Nullable String source) {
            this.sources.put(type, Optional.ofNullable(source));
        }

        @Generated
        public EnumMap<PatchShaderType, Optional<String>> sources() {
            return this.sources;
        }

        @Generated
        public GlFramebuffer framebuffer() {
            return this.framebuffer;
        }

        @Generated
        public BlendModeOverride blendModeOverride() {
            return this.blendModeOverride;
        }

        @Generated
        public float alphaReference() {
            return this.alphaReference;
        }

        public /* synthetic */ BlendModeOverride jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$get$blendModeOverride() {
            return this.blendModeOverride;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$blendModeOverride(BlendModeOverride blendModeOverride) {
            this.blendModeOverride = blendModeOverride;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$setSource(PatchShaderType patchShaderType, String string) {
            this.setSource(patchShaderType, string);
        }

        public /* synthetic */ GlFramebuffer jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$get$framebuffer() {
            return this.framebuffer;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$framebuffer(GlFramebuffer glFramebuffer) {
            this.framebuffer = glFramebuffer;
        }

        public /* synthetic */ float jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$get$alphaReference() {
            return this.alphaReference;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_coderbot_iris_celeritas_CeleritasTerrainPipeline$PassInfo$set$alphaReference(float f) {
            this.alphaReference = f;
        }
    }
}

