/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.client.gui.DynamicLightsOptionPages;
import com.gtnewhorizons.angelica.client.gui.ScrollableGuiScreen;
import com.gtnewhorizons.angelica.compat.mojang.Drawable;
import com.gtnewhorizons.angelica.compat.mojang.Element;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import jss.notfine.gui.GuiCustomMenu;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.element.SodiumControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SodiumOptionsGUI
extends ScrollableGuiScreen {
    protected static final SodiumControlElementFactory elementFactory = new SodiumControlElementFactory();
    protected final List<Element> children = new CopyOnWriteArrayList<Element>();
    protected final List<OptionPage> pages = new ArrayList<OptionPage>();
    protected final List<ControlElement<?>> controls = new ArrayList();
    protected final List<Drawable> drawable = new ArrayList<Drawable>();
    public final GuiScreen prevScreen;
    protected OptionPage currentPage;
    protected FlatButtonWidget applyButton;
    protected FlatButtonWidget closeButton;
    protected FlatButtonWidget undoButton;
    protected boolean hasPendingChanges;
    protected ControlElement<?> hoveredElement;
    protected OptionPage shaderPacks;

    public SodiumOptionsGUI(GuiScreen prevScreen) {
        OptionPage dlPage;
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.pages.add(SodiumGameOptionPages.performance());
        this.pages.add(SodiumGameOptionPages.appearance());
        if (DynamicLights.configEnabled && (dlPage = DynamicLightsOptionPages.dynamicLights()) != null) {
            this.pages.add(dlPage);
        }
        if (Iris.enabled) {
            this.shaderPacks = new OptionPage(I18n.func_135052_a((String)"options.iris.shaderPackSelection", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.of());
            this.pages.add(this.shaderPacks);
        }
        this.pages.add(SodiumGameOptionPages.debug());
    }

    public void setPage(OptionPage page) {
        if (Iris.enabled && page == this.shaderPacks) {
            this.field_146297_k.func_147108_a((GuiScreen)new ShaderPackScreen(this));
            return;
        }
        this.currentPage = page;
        this.rebuildGUI();
    }

    public void func_73866_w_() {
        this.rebuildGUI();
    }

    protected void rebuildGUI() {
        this.controls.clear();
        this.children.clear();
        this.drawable.clear();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 211, this.field_146295_m - 26, 65, 20), I18n.func_135052_a((String)"sodium.options.buttons.undo", (Object[])new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 142, this.field_146295_m - 26, 65, 20), I18n.func_135052_a((String)"sodium.options.buttons.apply", (Object[])new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 73, this.field_146295_m - 26, 65, 20), I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this::onClose);
        this.children.add(this.undoButton);
        this.children.add(this.applyButton);
        this.children.add(this.closeButton);
        for (Element element : this.children) {
            if (!(element instanceof Drawable)) continue;
            this.drawable.add((Drawable)((Object)element));
        }
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.field_146289_q.func_78256_a(page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, 6, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.children.add(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(6, y, 200, 18), elementFactory);
                this.controls.add(element);
                this.children.add((Element)((Object)element));
                y += 18;
            }
            y += 4;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float delta) {
        super.func_73863_a(mouseX, mouseY, delta);
        super.func_146276_q_();
        this.updateControls();
        for (Drawable drawable : this.drawable) {
            drawable.render(mouseX, mouseY, delta);
        }
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(this.hoveredElement);
        }
    }

    @Override
    public List<? extends Element> children() {
        return this.children;
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(ControlElement::isHovered).findFirst().orElse(null);
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.getOriginY();
        int boxX = dim.getLimitX() + 3;
        Option<?> option = element.getOption();
        ArrayList<String> tooltip = new ArrayList<String>(this.field_146289_q.func_78271_c(option.getTooltip(), 194));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(SodiumOptionsGUI.jvmdowngrader$concat$renderOptionTooltip$1(String.valueOf(EnumChatFormatting.GRAY), I18n.func_135052_a((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.toDisplayString()})));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + 3)) > (boxYCutoff = this.field_146295_m - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.func_73733_a(boxX, boxY, boxX + 200, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.field_146289_q.func_78276_b((String)tooltip.get(i), boxX + 3, boxY + 3 + i * 12, -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            this.field_146297_k.field_71438_f.func_72712_a();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            this.field_146297_k.func_147117_R().func_147633_a(this.field_146297_k.field_71474_y.field_151442_I);
            this.field_146297_k.func_110436_a();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 && !this.shouldCloseOnEsc()) {
            return;
        }
        if (keyCode == 1) {
            this.onClose();
            return;
        }
        if (keyCode == 25 && SodiumOptionsGUI.func_146272_n()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCustomMenu(this.prevScreen, SodiumGameOptionPages.general(), SodiumGameOptionPages.quality(), SodiumGameOptionPages.advanced(), SodiumGameOptionPages.performance(), SodiumGameOptionPages.appearance(), SodiumGameOptionPages.debug()));
        }
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    public void onClose() {
        this.field_146297_k.func_147108_a(this.prevScreen);
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.children.forEach(element -> element.mouseClicked(mouseX, mouseY, mouseButton));
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.children.forEach(element -> element.mouseDragged(mouseX, mouseY, mouseButton));
    }

    private static /* synthetic */ String jvmdowngrader$concat$renderOptionTooltip$1(String string, String string2) {
        return string + string2;
    }
}

