/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import java.util.ArrayList;
import java.util.function.Predicate;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.element.SodiumControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.Validate;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={Builder.class})
public class OptionPageFrame
extends AbstractFrame {
    protected static final SodiumControlElementFactory elementFactory = new SodiumControlElementFactory();
    protected final Dim2i originalDim;
    protected final OptionPage page;
    protected final Predicate<Option<?>> optionFilter;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page, Predicate<Option<?>> optionFilter) {
        super(dim, renderOutline);
        this.originalDim = new Dim2i(dim.getOriginX(), dim.getOriginY(), dim.getWidth(), dim.getHeight());
        this.page = page;
        this.optionFilter = optionFilter;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group2 : this.page.getGroups()) {
                int visibleCount = (int)group2.getOptions().stream().filter(this.optionFilter::test).count();
                if (visibleCount <= 0) continue;
                y += visibleCount * 18;
                if (group2 == lastGroup) continue;
                y += 4;
            }
        }
        this.dim.setHeight(y);
        this.page.getGroups().forEach(group -> group.getOptions().forEach(option -> {
            if (option instanceof OptionExtended) {
                OptionExtended optionExtended = (OptionExtended)option;
                optionExtended.setParentDimension(this.dim);
            }
        }));
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            boolean hasVisibleOptions = false;
            for (Option option : group.getOptions()) {
                if (!this.optionFilter.test(option)) continue;
                hasVisibleOptions = true;
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.getOriginX(), this.dim.getOriginY() + y, this.dim.getWidth(), 18), elementFactory);
                this.children.add((AbstractWidget)((Object)element));
                y += 18;
            }
            if (!hasVisibleOptions) continue;
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(controlElement -> controlElement.getDimensions().overlapWith(this.originalDim)).filter(ControlElement::isHovered).findFirst().orElse(null);
        super.render(mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && this.originalDim.containsCursor(mouseX, mouseY) && hoveredElement.isHovered()) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.getWidth();
        int boxY = dim.getLimitY();
        int boxX = dim.getOriginX();
        Option<?> option = element.getOption();
        ArrayList<String> tooltip = new ArrayList<String>(fontRenderer.func_78271_c(option.getTooltip(), boxWidth - 6));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(OptionPageFrame.jvmdowngrader$concat$renderOptionTooltip$1(String.valueOf(EnumChatFormatting.GRAY), I18n.func_135052_a((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.toDisplayString()})));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + 3)) > (boxYCutoff = this.originalDim.getLimitY())) {
            boxY -= boxHeight + dim.getHeight();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        this.drawRect(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawRectOutline(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -7019309);
        for (int i = 0; i < tooltip.size(); ++i) {
            fontRenderer.func_78276_b((String)tooltip.get(i), boxX + 3, boxY + 3 + i * 12, -1);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$renderOptionTooltip$1(String string, String string2) {
        return string + string2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=OptionPageFrame.class)
    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;
        private Predicate<Option<?>> optionFilter = opt -> true;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public Builder setOptionFilter(Predicate<Option<?>> optionFilter) {
            this.optionFilter = optionFilter;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page, this.optionFilter);
        }
    }
}

