/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import com.gtnewhorizons.angelica.client.gui.FontConfigScreen;
import com.gtnewhorizons.angelica.compat.mojang.Element;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jss.notfine.gui.GuiCustomMenu;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.SearchTextFieldComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class})
public class ReeseSodiumVideoOptionsScreen
extends SodiumOptionsGUI {
    @Nullable
    private Element focused;
    private static final AtomicReference<String> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<String> lastSearch = new AtomicReference<String>("");
    private AbstractFrame frame;
    private SearchTextFieldComponent searchTextField;

    public ReeseSodiumVideoOptionsScreen(GuiScreen prevScreen) {
        super(prevScreen);
    }

    @Override
    public void rebuildGUI() {
        boolean wasSearchFocused = this.searchTextField != null && this.searchTextField.isFocused();
        this.children.clear();
        this.func_73866_w_();
        if (wasSearchFocused && this.searchTextField != null) {
            this.searchTextField.setFocused(true);
            this.setFocused(this.searchTextField);
        }
    }

    public void setFocused(@Nullable Element focused) {
        this.focused = focused;
    }

    @Nullable
    public Element getFocused() {
        return this.focused;
    }

    @Override
    public void func_73866_w_() {
        this.frame = this.parentFrameBuilder().build();
        this.children.add(this.frame);
        this.searchTextField.setFocused(!lastSearch.get().trim().isEmpty());
        if (this.searchTextField.isFocused()) {
            this.setFocused(this.searchTextField);
        } else {
            this.setFocused(this.frame);
        }
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.field_146294_l;
        if ((double)((float)this.field_146294_l / (float)this.field_146295_m) > 1.77777777778) {
            newWidth = (int)((double)this.field_146295_m * 1.77777777778);
        }
        Dim2i basicFrameDim = new Dim2i((this.field_146294_l - newWidth) / 2, 0, newWidth, this.field_146295_m);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.getOriginX() + basicFrameDim.getWidth() / 20 / 2, basicFrameDim.getOriginY() + basicFrameDim.getHeight() / 4 / 2, basicFrameDim.getWidth() - basicFrameDim.getWidth() / 20, basicFrameDim.getHeight() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, "Undo", this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, "Apply", this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, "Close", this::onClose);
        String irisText = Iris.enabled ? I18n.func_135052_a((String)IrisApi.getInstance().getMainScreenLanguageKey(), (Object[])new Object[0]) : null;
        int irisWidth = irisText != null ? this.field_146297_k.field_71466_p.func_78256_a(irisText) : 0;
        String fontConfigText = AngelicaConfig.enableFontRenderer ? I18n.func_135052_a((String)"options.angelica.fontconfig", (Object[])new Object[0]) : null;
        int fontConfigWidth = fontConfigText != null ? this.field_146297_k.field_71466_p.func_78256_a(fontConfigText) : 0;
        int buttonsWidth = 0;
        if (irisText != null) {
            buttonsWidth += irisWidth + 12;
        }
        if (fontConfigText != null) {
            buttonsWidth += fontConfigWidth + 14;
        }
        Dim2i searchTextFieldDim = new Dim2i(tabFrameDim.getOriginX(), tabFrameDim.getOriginY() - 26, tabFrameDim.getWidth() - buttonsWidth, 20);
        this.searchTextField = new SearchTextFieldComponent(searchTextFieldDim, this.pages, tabFrameSelectedTab, tabFrameScrollBarOffset, optionPageScrollBarOffset, tabFrameDim.getHeight(), this, lastSearch);
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        int buttonX = tabFrameDim.getLimitX();
        if (irisText != null) {
            Dim2i shaderPackButtonDim = new Dim2i(buttonX -= irisWidth + 10, tabFrameDim.getOriginY() - 26, irisWidth + 10, 20);
            FlatButtonWidget shaderPackButton = new FlatButtonWidget(shaderPackButtonDim, irisText, () -> this.field_146297_k.func_147108_a((GuiScreen)new ShaderPackScreen(this)));
            basicFrameBuilder.addChild(dim -> shaderPackButton);
            buttonX -= 2;
        }
        if (fontConfigText != null) {
            Dim2i fontConfigButtonDim = new Dim2i(buttonX -= fontConfigWidth + 12, tabFrameDim.getOriginY() - 26, fontConfigWidth + 12, 20);
            FlatButtonWidget fontConfigButton = new FlatButtonWidget(fontConfigButtonDim, fontConfigText, () -> this.field_146297_k.func_147108_a((GuiScreen)new FontConfigScreen(this)));
            basicFrameBuilder.addChild(dim -> fontConfigButton);
        }
        basicFrameBuilder.addChild(dim -> this.searchTextField);
        return basicFrameBuilder;
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, final Dim2i tabFrameDim) {
        Predicate<Option<?>> optionPredicate = this.searchTextField.getOptionPredicate();
        boolean noResults = this.searchTextField.hasNoResults();
        BasicFrame.Builder builder = BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false);
        if (noResults) {
            final String noResultsText = I18n.func_135052_a((String)"options.angelica.search.no_results", (Object[])new Object[0]);
            builder.addChild(dim -> new AbstractWidget(this){
                final /* synthetic */ ReeseSodiumVideoOptionsScreen this$0;
                {
                    ReeseSodiumVideoOptionsScreen reeseSodiumVideoOptionsScreen = this$0;
                    Objects.requireNonNull(reeseSodiumVideoOptionsScreen);
                    this.this$0 = reeseSodiumVideoOptionsScreen;
                }

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    int textWidth = this.this$0.field_146297_k.field_71466_p.func_78256_a(noResultsText);
                    int x = tabFrameDim.getCenterX() - textWidth / 2;
                    int y = tabFrameDim.getCenterY();
                    this.drawString(noResultsText, x, y, 0x808080);
                }
            });
        } else {
            builder.addChild(parentDim -> TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(this::canShowPage).forEach(page -> tabs.add(Tab.createBuilder().from((OptionPage)page, optionPredicate, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build());
        }
        return builder.addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        this.handleMouseScroll(mouseX, mouseY, partialTicks);
        this.updateControls();
        this.frame.render(mouseX, mouseY, partialTicks);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            this.field_146297_k.field_71438_f.func_72712_a();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            this.field_146297_k.func_147117_R().func_147633_a(this.field_146297_k.field_71474_y.field_151442_I);
            this.field_146297_k.func_110436_a();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private boolean canShowPage(OptionPage page) {
        if (page.getGroups().isEmpty()) {
            return false;
        }
        Predicate<Option<?>> predicate = this.searchTextField.getOptionPredicate();
        for (OptionGroup group : page.getGroups()) {
            for (Option option : group.getOptions()) {
                if (!predicate.test(option)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 && !this.shouldCloseOnEsc()) {
            return;
        }
        if (keyCode == 1) {
            this.onClose();
            return;
        }
        if (keyCode == 25) {
            if (ReeseSodiumVideoOptionsScreen.func_146272_n()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCustomMenu(this.prevScreen, SodiumGameOptionPages.general(), SodiumGameOptionPages.quality(), SodiumGameOptionPages.advanced(), SodiumGameOptionPages.performance(), SodiumGameOptionPages.appearance(), SodiumGameOptionPages.debug()));
            } else if (ReeseSodiumVideoOptionsScreen.func_146271_m()) {
                this.field_146297_k.func_147108_a((GuiScreen)new SodiumOptionsGUI(this.prevScreen));
            }
        }
        if (this.focused != null) {
            this.focused.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    @Override
    public void onClose() {
        lastSearch.set("");
        super.onClose();
    }
}

