/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.asm;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.util.Objects;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ASMUtils {
    public static boolean abstractInsnNodeEquals(AbstractInsnNode node1, AbstractInsnNode node2) {
        boolean bl;
        if (node1.getType() != node2.getType()) {
            return false;
        }
        if (node1.getOpcode() != node2.getOpcode()) {
            return false;
        }
        switch (node1.getType()) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                if (node1 instanceof IntInsnNode) {
                    IntInsnNode intInsnNode1 = (IntInsnNode)node1;
                    if (node2 instanceof IntInsnNode) {
                        IntInsnNode intInsnNode2 = (IntInsnNode)node2;
                        if (intInsnNode1.operand == intInsnNode2.operand) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                if (node1 instanceof VarInsnNode) {
                    VarInsnNode varInsnNode1 = (VarInsnNode)node1;
                    if (node2 instanceof VarInsnNode) {
                        VarInsnNode varInsnNode2 = (VarInsnNode)node2;
                        if (varInsnNode1.var == varInsnNode2.var) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 3: {
                if (node1 instanceof TypeInsnNode) {
                    TypeInsnNode typeInsnNode1 = (TypeInsnNode)node1;
                    if (node2 instanceof TypeInsnNode) {
                        TypeInsnNode typeInsnNode2 = (TypeInsnNode)node2;
                        bl = typeInsnNode1.desc.equals(typeInsnNode2.desc);
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 4: {
                if (node1 instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsnNode1 = (FieldInsnNode)node1;
                    if (node2 instanceof FieldInsnNode) {
                        FieldInsnNode fieldInsnNode2 = (FieldInsnNode)node2;
                        if (fieldInsnNode1.desc.equals(fieldInsnNode2.desc) && fieldInsnNode1.name.equals(fieldInsnNode2.name) && fieldInsnNode1.owner.equals(fieldInsnNode2.owner)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 5: {
                if (node1 instanceof MethodInsnNode) {
                    MethodInsnNode methodInsnNode1 = (MethodInsnNode)node1;
                    if (node2 instanceof MethodInsnNode) {
                        MethodInsnNode methodInsnNode2 = (MethodInsnNode)node2;
                        if (methodInsnNode1.desc.equals(methodInsnNode2.desc) && methodInsnNode1.name.equals(methodInsnNode2.name) && methodInsnNode1.owner.equals(methodInsnNode2.owner)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 6: {
                if (node1 instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode invokeDynamicInsnNode1 = (InvokeDynamicInsnNode)node1;
                    if (node2 instanceof InvokeDynamicInsnNode) {
                        InvokeDynamicInsnNode invokeDynamicInsnNode2 = (InvokeDynamicInsnNode)node2;
                        if (invokeDynamicInsnNode1.desc.equals(invokeDynamicInsnNode2.desc) && invokeDynamicInsnNode1.name.equals(invokeDynamicInsnNode2.name) && invokeDynamicInsnNode1.bsm.equals((Object)invokeDynamicInsnNode2.bsm)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 7: {
                if (node1 instanceof JumpInsnNode) {
                    JumpInsnNode jumpInsnNode1 = (JumpInsnNode)node1;
                    if (node2 instanceof JumpInsnNode) {
                        JumpInsnNode jumpInsnNode2 = (JumpInsnNode)node2;
                        bl = jumpInsnNode1.label.getLabel().equals(jumpInsnNode2.label.getLabel());
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 8: {
                if (node1 instanceof LabelNode) {
                    LabelNode labelNode1 = (LabelNode)node1;
                    if (node2 instanceof LabelNode) {
                        LabelNode labelNode2 = (LabelNode)node2;
                        bl = labelNode1.getLabel().equals(labelNode2.getLabel());
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 9: {
                if (node1 instanceof LdcInsnNode) {
                    LdcInsnNode ldcInsnNode1 = (LdcInsnNode)node1;
                    if (node2 instanceof LdcInsnNode) {
                        LdcInsnNode ldcInsnNode2 = (LdcInsnNode)node2;
                        bl = ldcInsnNode1.cst.equals(ldcInsnNode2.cst);
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 10: {
                if (node1 instanceof IincInsnNode) {
                    IincInsnNode iincInsnNode1 = (IincInsnNode)node1;
                    if (node2 instanceof IincInsnNode) {
                        IincInsnNode iincInsnNode2 = (IincInsnNode)node2;
                        if (iincInsnNode1.incr == iincInsnNode2.incr && iincInsnNode1.var == iincInsnNode2.var) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 14: {
                if (node1 instanceof FrameNode) {
                    FrameNode frameNode1 = (FrameNode)node1;
                    if (node2 instanceof FrameNode) {
                        FrameNode frameNode2 = (FrameNode)node2;
                        if (frameNode1.type == frameNode2.type && Objects.equals(frameNode1.local, frameNode2.local) && Objects.equals(frameNode1.stack, frameNode2.stack)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 15: {
                if (node1 instanceof LineNumberNode) {
                    LineNumberNode lineNumberNode1 = (LineNumberNode)node1;
                    if (node2 instanceof LineNumberNode) {
                        LineNumberNode lineNumberNode2 = (LineNumberNode)node2;
                        if (lineNumberNode1.line == lineNumberNode2.line && lineNumberNode1.start.getLabel().equals(lineNumberNode2.start.getLabel())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                AngelicaTweaker.LOGGER.warn(ASMUtils.jvmdowngrader$concat$abstractInsnNodeEquals$1(String.valueOf(node1.getClass())));
                bl = node1.toString().equals(node2.toString());
            }
        }
        return bl;
    }

    public static boolean matchesNodeSequence(AbstractInsnNode node, AbstractInsnNode ... pattern) {
        AbstractInsnNode currentNode = node;
        for (AbstractInsnNode abstractInsnNode : pattern) {
            if (!ASMUtils.abstractInsnNodeEquals(currentNode, abstractInsnNode)) {
                return false;
            }
            if ((currentNode = currentNode.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ String jvmdowngrader$concat$abstractInsnNodeEquals$1(String string) {
        return "Unchecked node found: " + string;
    }
}

