/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mob.LineRenderer;
import com.prupe.mcpatcher.mob.MobOverlay;
import com.prupe.mcpatcher.mob.MobRuleList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={ExtraInfo.class, 1.class})
public class MobRandomizer {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.RANDOM_MOBS);
    private static final Map<String, ResourceLocation> cache = new LinkedHashMap<String, ResourceLocation>();

    public static void init() {
    }

    public static ResourceLocation randomTexture(EntityLivingBase entity, ResourceLocation texture) {
        if (texture == null || !texture.func_110623_a().endsWith(".png")) {
            return texture;
        }
        String key = MobRandomizer.jvmdowngrader$concat$randomTexture$1(String.valueOf(texture), entity.func_145782_y());
        ResourceLocation newTexture = cache.get(key);
        if (newTexture == null) {
            ExtraInfo info = ExtraInfo.getInfo(entity);
            MobRuleList list = MobRuleList.get(texture);
            newTexture = list.getSkin(info.jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$skin(), info.jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origX(), info.jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origY(), info.jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origZ(), info.jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origBiome());
            cache.put(key, newTexture);
            logger.finer("entity %s using %s (cache: %d)", entity, newTexture, cache.size());
            if (cache.size() > 250) {
                while (cache.size() > 200) {
                    cache.remove(cache.keySet().iterator().next());
                }
            }
        }
        return newTexture;
    }

    public static ResourceLocation randomTexture(Entity entity, ResourceLocation texture) {
        if (entity instanceof EntityLivingBase) {
            return MobRandomizer.randomTexture((EntityLivingBase)entity, texture);
        }
        return texture;
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Random Mobs", 2){

            @Override
            public void beforeChange() {
                cache.clear();
            }

            @Override
            public void afterChange() {
                MobRuleList.clear();
                MobOverlay.reset();
                LineRenderer.reset();
            }
        });
    }

    public static /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$set$cache(Map map) {
        cache = map;
    }

    public static /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$set$logger(MCLogger mCLogger) {
        logger = mCLogger;
    }

    private static /* synthetic */ String jvmdowngrader$concat$randomTexture$1(String string, int n) {
        return string + ":" + n;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=MobRandomizer.class)
    public static final class ExtraInfo {
        private static final String SKIN_TAG = "randomMobsSkin";
        private static final String ORIG_X_TAG = "origX";
        private static final String ORIG_Y_TAG = "origY";
        private static final String ORIG_Z_TAG = "origZ";
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private static final Map<Integer, ExtraInfo> allInfo = new HashMap<Integer, ExtraInfo>();
        private static final Map<WeakReference<EntityLivingBase>, ExtraInfo> allRefs = new HashMap<WeakReference<EntityLivingBase>, ExtraInfo>();
        private static final ReferenceQueue<EntityLivingBase> refQueue = new ReferenceQueue();
        private final int entityId;
        private final HashSet<WeakReference<EntityLivingBase>> references;
        private final long skin;
        private final int origX;
        private final int origY;
        private final int origZ;
        private Integer origBiome;

        ExtraInfo(EntityLivingBase entity) {
            this(entity, ExtraInfo.getSkinId(entity.func_145782_y()), (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
        }

        ExtraInfo(EntityLivingBase entity, long skin, int origX, int origY, int origZ) {
            this.entityId = entity.func_145782_y();
            this.references = new HashSet();
            this.skin = skin;
            this.origX = origX;
            this.origY = origY;
            this.origZ = origZ;
        }

        private void setBiome() {
            if (this.origBiome == null) {
                this.origBiome = BiomeAPI.getBiomeIDAt(BiomeAPI.getWorld(), this.origX, this.origY, this.origZ);
            }
        }

        public String toString() {
            return String.format("%s{%d, %d, %d, %d, %d, %s}", this.getClass().getSimpleName(), this.entityId, this.skin, this.origX, this.origY, this.origZ, this.origBiome);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearUnusedReferences() {
            Map<Integer, ExtraInfo> map = allInfo;
            synchronized (map) {
                Reference<EntityLivingBase> ref;
                while ((ref = refQueue.poll()) != null) {
                    ExtraInfo info = allRefs.get(ref);
                    if (info != null) {
                        info.references.remove(ref);
                        if (info.references.isEmpty()) {
                            logger.finest("removing unused ref %d", info.entityId);
                            allInfo.remove(info.entityId);
                        }
                    }
                    allRefs.remove(ref);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ExtraInfo getInfo(EntityLivingBase entity) {
            ExtraInfo info;
            Map<Integer, ExtraInfo> map = allInfo;
            synchronized (map) {
                ExtraInfo.clearUnusedReferences();
                info = allInfo.get(entity.func_145782_y());
                if (info == null) {
                    info = new ExtraInfo(entity);
                    ExtraInfo.putInfo(entity, info);
                }
                boolean found = false;
                for (WeakReference<EntityLivingBase> ref : info.references) {
                    if (ref.get() != entity) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    WeakReference<EntityLivingBase> reference = new WeakReference<EntityLivingBase>(entity, refQueue);
                    info.references.add(reference);
                    allRefs.put(reference, info);
                    logger.finest("added ref #%d for %d (%d entities)", info.references.size(), entity.func_145782_y(), allInfo.size());
                }
                info.setBiome();
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void putInfo(EntityLivingBase entity, ExtraInfo info) {
            Map<Integer, ExtraInfo> map = allInfo;
            synchronized (map) {
                allInfo.put(entity.func_145782_y(), info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clearInfo() {
            Map<Integer, ExtraInfo> map = allInfo;
            synchronized (map) {
                allInfo.clear();
            }
        }

        private static long getSkinId(int entityId) {
            long n = entityId;
            n = n ^ n << 16 ^ n << 32 ^ n << 48;
            n = 25214903917L * n + 11L;
            n = 25214903917L * n + 11L;
            return (n &= 0xFFFFFFFFFFFFL) >> 32 ^ n;
        }

        public static void readFromNBT(EntityLivingBase entity, NBTTagCompound nbt) {
            long skin = nbt.func_74763_f(SKIN_TAG);
            if (skin != 0L) {
                int x = nbt.func_74762_e(ORIG_X_TAG);
                int y = nbt.func_74762_e(ORIG_Y_TAG);
                int z = nbt.func_74762_e(ORIG_Z_TAG);
                ExtraInfo.putInfo(entity, new ExtraInfo(entity, skin, x, y, z));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeToNBT(EntityLivingBase entity, NBTTagCompound nbt) {
            Map<Integer, ExtraInfo> map = allInfo;
            synchronized (map) {
                ExtraInfo info = allInfo.get(entity.func_145782_y());
                if (info != null) {
                    nbt.func_74772_a(SKIN_TAG, info.skin);
                    nbt.func_74768_a(ORIG_X_TAG, info.origX);
                    nbt.func_74768_a(ORIG_Y_TAG, info.origY);
                    nbt.func_74768_a(ORIG_Z_TAG, info.origZ);
                }
            }
        }

        public /* synthetic */ long jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$skin() {
            return this.skin;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$set$skin(long l) {
            this.skin = l;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origZ() {
            return this.origZ;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$set$origZ(int n) {
            this.origZ = n;
        }

        public /* synthetic */ Integer jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origBiome() {
            return this.origBiome;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$set$origBiome(Integer n) {
            this.origBiome = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origY() {
            return this.origY;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$set$origY(int n) {
            this.origY = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$get$origX() {
            return this.origX;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_prupe_mcpatcher_mob_MobRandomizer$ExtraInfo$set$origX(int n) {
            this.origX = n;
        }
    }
}

