/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ctm.BlockFaceMatcher;
import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.ctm.TileOverrideImpl;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class TileOverride
implements Comparable<TileOverride> {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CONNECTED_TEXTURES, "CTM");
    private final PropertiesFile properties;
    private final String baseFilename;
    private final TileLoader tileLoader;
    private final int renderPass;
    private final int weight;
    private final List<BlockStateMatcher> matchBlocks;
    private final Set<String> matchTiles;
    private final BlockFaceMatcher faceMatcher;
    private final int connectType;
    private final boolean innerSeams;
    private final BitSet biomes;
    private final BitSet height;
    private final List<ResourceLocation> tileNames = new ArrayList<ResourceLocation>();
    protected IIcon[] icons;

    static TileOverride create(ResourceLocation propertiesFile, TileLoader tileLoader) {
        String status;
        if (propertiesFile == null) {
            return null;
        }
        PropertiesFile properties = PropertiesFile.get(logger, propertiesFile);
        if (properties == null) {
            return null;
        }
        String method = properties.getString("method", "default").toLowerCase();
        TileOverride override = null;
        switch (method) {
            case "default": 
            case "glass": 
            case "ctm": {
                override = new TileOverrideImpl.CTM(properties, tileLoader);
                break;
            }
            case "random": {
                override = new TileOverrideImpl.Random1(properties, tileLoader);
                if (override.getNumberOfTiles() != 1) break;
                override = new TileOverrideImpl.Fixed(properties, tileLoader);
                break;
            }
            case "fixed": 
            case "static": {
                override = new TileOverrideImpl.Fixed(properties, tileLoader);
                break;
            }
            case "bookshelf": 
            case "horizontal": {
                override = new TileOverrideImpl.Horizontal(properties, tileLoader);
                break;
            }
            case "horizontal+vertical": 
            case "h+v": {
                override = new TileOverrideImpl.HorizontalVertical(properties, tileLoader);
                break;
            }
            case "vertical": {
                override = new TileOverrideImpl.Vertical(properties, tileLoader);
                break;
            }
            case "vertical+horizontal": 
            case "v+h": {
                override = new TileOverrideImpl.VerticalHorizontal(properties, tileLoader);
                break;
            }
            case "sandstone": 
            case "top": {
                override = new TileOverrideImpl.Top(properties, tileLoader);
                break;
            }
            case "repeat": 
            case "pattern": {
                override = new TileOverrideImpl.Repeat(properties, tileLoader);
                break;
            }
            default: {
                properties.error("unknown method \"%s\"", method);
            }
        }
        if (override != null && !properties.valid() && (status = override.checkTileMap()) != null) {
            override.properties.error("invalid %s tile map: %s", override.getMethod(), status);
        }
        return override == null || override.isDisabled() ? null : override;
    }

    protected TileOverride(PropertiesFile properties, TileLoader tileLoader) {
        String connectType1;
        this.properties = properties;
        String texturesDirectory = properties.getResource().func_110623_a().replaceFirst("/[^/]*$", "");
        this.baseFilename = properties.getResource().func_110623_a().replaceFirst(".*/", "").replaceFirst("\\.properties$", "");
        this.tileLoader = tileLoader;
        String renderPassStr = properties.getString("renderPass", "");
        this.renderPass = RenderPassAPI.instance.parseRenderPass(renderPassStr);
        if (renderPassStr.matches("\\d+") && this.renderPass >= 0 && this.renderPass <= RenderPassAPI.MAX_EXTRA_RENDER_PASS) {
            properties.warning("renderPass=%s is deprecated, use renderPass=%s instead", renderPassStr, RenderPassAPI.instance.getRenderPassName(this.renderPass));
        }
        this.loadIcons();
        if (this.tileNames.isEmpty()) {
            properties.error("no images found in %s/", texturesDirectory);
        }
        String value = this.baseFilename.matches("block\\d+.*") ? this.baseFilename.replaceFirst("block(\\d+).*", "$1") : "";
        this.matchBlocks = this.getBlockList(properties.getString("matchBlocks", value), properties.getString("metadata", ""));
        this.matchTiles = this.getTileList("matchTiles");
        if (this.matchBlocks.isEmpty() && this.matchTiles.isEmpty()) {
            this.matchTiles.add(this.baseFilename);
        }
        this.faceMatcher = BlockFaceMatcher.create(properties.getString("faces", ""));
        switch (connectType1 = properties.getString("connect", "").toLowerCase()) {
            case "": {
                this.connectType = this.matchTiles.isEmpty() ? 0 : 1;
                break;
            }
            case "block": {
                this.connectType = 0;
                break;
            }
            case "tile": {
                this.connectType = 1;
                break;
            }
            case "material": {
                this.connectType = 2;
                break;
            }
            default: {
                properties.error("invalid connect type %s", connectType1);
                this.connectType = 0;
            }
        }
        this.innerSeams = properties.getBoolean("innerSeams", false);
        String biomeList = properties.getString("biomes", "");
        if (biomeList.isEmpty()) {
            this.biomes = null;
        } else {
            this.biomes = new BitSet();
            BiomeAPI.parseBiomeList(biomeList, this.biomes);
        }
        this.height = BiomeAPI.getHeightListProperty(properties, "");
        if (this.renderPass > RenderPassAPI.MAX_EXTRA_RENDER_PASS) {
            properties.error("invalid renderPass %s", renderPassStr);
        } else if (this.renderPass >= 0 && !this.matchTiles.isEmpty()) {
            properties.error("renderPass=%s must be block-based not tile-based", RenderPassAPI.instance.getRenderPassName(this.renderPass));
        }
        this.weight = properties.getInt("weight", 0);
    }

    private boolean addIcon(ResourceLocation resource) {
        this.tileNames.add(resource);
        return this.tileLoader.preloadTile(resource, this.renderPass > 4);
    }

    private void loadIcons() {
        this.tileNames.clear();
        String tileList = this.properties.getString("tiles", "");
        ResourceLocation blankResource = RenderPassAPI.instance.getBlankResource(this.renderPass);
        if (tileList.isEmpty()) {
            ResourceLocation resource;
            int i = 0;
            while (TexturePackAPI.hasResource(resource = TileLoader.parseTileAddress(this.properties.getResource(), String.valueOf(i), blankResource)) && this.addIcon(resource)) {
                ++i;
            }
        } else {
            Pattern range = Pattern.compile("(\\d+)-(\\d+)");
            for (String token : tileList.split("\\s+")) {
                Matcher matcher = range.matcher(token);
                if (token.isEmpty()) continue;
                if (matcher.matches()) {
                    try {
                        int from = Integer.parseInt(matcher.group(1));
                        int to = Integer.parseInt(matcher.group(2));
                        for (int i = from; i <= to; ++i) {
                            ResourceLocation resource = TileLoader.parseTileAddress(this.properties.getResource(), String.valueOf(i), blankResource);
                            if (TexturePackAPI.hasResource(resource)) {
                                this.addIcon(resource);
                                continue;
                            }
                            this.properties.warning("could not find image %s", resource);
                            this.tileNames.add(null);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                ResourceLocation resource = TileLoader.parseTileAddress(this.properties.getResource(), token, blankResource);
                if (resource == null) {
                    this.tileNames.add(null);
                    continue;
                }
                if (TexturePackAPI.hasResource(resource)) {
                    this.addIcon(resource);
                    continue;
                }
                this.properties.warning("could not find image %s", resource);
                this.tileNames.add(null);
            }
        }
    }

    private List<BlockStateMatcher> getBlockList(String property, String defaultMetadata) {
        ArrayList<BlockStateMatcher> blocks = new ArrayList<BlockStateMatcher>();
        if (!MCPatcherUtils.isNullOrEmpty(defaultMetadata)) {
            defaultMetadata = TileOverride.jvmdowngrader$concat$getBlockList$1(defaultMetadata);
        }
        for (String token : property.split("\\s+")) {
            if (token.isEmpty()) continue;
            if (token.matches("\\d+-\\d+")) {
                for (int id : MCPatcherUtils.parseIntegerList(token, 0, 65535)) {
                    BlockStateMatcher matcher = BlockAPI.createMatcher(this.properties, TileOverride.jvmdowngrader$concat$getBlockList$1(id, defaultMetadata));
                    if (matcher == null) {
                        this.properties.warning("unknown block id %d", id);
                        continue;
                    }
                    blocks.add(matcher);
                }
                continue;
            }
            BlockStateMatcher matcher = BlockAPI.createMatcher(this.properties, TileOverride.jvmdowngrader$concat$getBlockList$1(token, defaultMetadata));
            if (matcher == null) {
                this.properties.warning("unknown block %s", token);
                continue;
            }
            blocks.add(matcher);
        }
        for (BlockStateMatcher matcher : blocks) {
            matcher.setData(this);
        }
        return blocks;
    }

    private Set<String> getTileList(String key) {
        HashSet<String> list = new HashSet<String>();
        String property = this.properties.getString(key, "");
        for (String token : property.split("\\s+")) {
            if (token.isEmpty()) continue;
            if (token.contains("/")) {
                ResourceLocation resource;
                if (!token.endsWith(".png")) {
                    token = TileOverride.jvmdowngrader$concat$getTileList$1(token);
                }
                if ((resource = TexturePackAPI.parseResourceLocation(this.properties.getResource(), token)) == null) continue;
                list.add(resource.toString());
                continue;
            }
            list.add(token);
        }
        return list;
    }

    protected int getNumberOfTiles() {
        return this.tileNames.size();
    }

    String checkTileMap() {
        return null;
    }

    boolean requiresFace() {
        return false;
    }

    public String toString() {
        return String.format("%s[%s] (%d tiles)", this.getMethod(), this.properties, this.getNumberOfTiles());
    }

    public final void registerIcons() {
        this.icons = new IIcon[this.tileNames.size()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = this.tileLoader.getIcon(this.tileNames.get(i));
        }
    }

    public final boolean isDisabled() {
        return !this.properties.valid();
    }

    public final List<BlockStateMatcher> getMatchingBlocks() {
        return this.matchBlocks;
    }

    public final Set<String> getMatchingTiles() {
        if (MCPatcherUtils.isNullOrEmpty(this.matchTiles)) {
            return null;
        }
        return new HashSet<String>(this.matchTiles);
    }

    public final int getRenderPass() {
        return this.renderPass;
    }

    public final int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(TileOverride o) {
        int result = o.getWeight() - this.getWeight();
        if (result != 0) {
            return result;
        }
        if (o instanceof TileOverride) {
            return this.baseFilename.compareTo(o.baseFilename);
        }
        return -1;
    }

    final boolean shouldConnect(RenderBlockState renderBlockState, IIcon icon, int relativeDirection) {
        return this.shouldConnect(renderBlockState, icon, renderBlockState.getOffset(renderBlockState.getBlockFace(), relativeDirection));
    }

    final boolean shouldConnect(RenderBlockState renderBlockState, IIcon icon, int blockFace, int relativeDirection) {
        return this.shouldConnect(renderBlockState, icon, renderBlockState.getOffset(blockFace, relativeDirection));
    }

    private boolean shouldConnect(RenderBlockState renderBlockState, IIcon icon, int[] offset) {
        boolean bl;
        int[] normal;
        int blockFace;
        BlockStateMatcher filter;
        IBlockAccess blockAccess = renderBlockState.getBlockAccess();
        Block block = renderBlockState.getBlock();
        int x = renderBlockState.getX();
        int y = renderBlockState.getY();
        int z = renderBlockState.getZ();
        Block neighbor = blockAccess.func_147439_a(x += offset[0], y += offset[1], z += offset[2]);
        if (neighbor == null) {
            return false;
        }
        if (block == neighbor && (filter = renderBlockState.getFilter()) != null && !filter.match(blockAccess, x, y, z)) {
            return false;
        }
        if (this.innerSeams && (blockFace = renderBlockState.getBlockFace()) >= 0 && !neighbor.func_149646_a(blockAccess, x + (normal = RenderBlockState.NORMALS[blockFace])[0], y + normal[1], z + normal[2], blockFace)) {
            return false;
        }
        switch (this.connectType) {
            case 1: {
                bl = renderBlockState.shouldConnectByTile(neighbor, icon, x, y, z);
                break;
            }
            case 0: {
                bl = renderBlockState.shouldConnectByBlock(neighbor, x, y, z);
                break;
            }
            case 2: {
                if (block.field_149764_J == neighbor.field_149764_J) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final IIcon getTileWorld(RenderBlockState renderBlockState, IIcon origIcon) {
        if (this.icons == null) {
            this.properties.error("no images loaded, disabling", new Object[0]);
            return null;
        }
        IBlockAccess blockAccess = renderBlockState.getBlockAccess();
        Block block = renderBlockState.getBlock();
        int x = renderBlockState.getX();
        int y = renderBlockState.getY();
        int z = renderBlockState.getZ();
        if (renderBlockState.getBlockFace() < 0 && this.requiresFace()) {
            this.properties.warning("method=%s is not supported for non-standard block %s:%d @ %d %d %d", this.getMethod(), BlockAPI.getBlockName(block), blockAccess.func_72805_g(x, y, z), x, y, z);
            return null;
        }
        if (block == null || RenderPassAPI.instance.skipThisRenderPass(block, this.renderPass)) {
            return null;
        }
        BlockStateMatcher filter = renderBlockState.getFilter();
        if (filter != null && !filter.match(blockAccess, x, y, z)) {
            return null;
        }
        if (this.faceMatcher != null && !this.faceMatcher.match(renderBlockState)) {
            return null;
        }
        if (this.height != null && !this.height.get(y)) {
            return null;
        }
        if (this.biomes != null && !this.biomes.get(BiomeAPI.getBiomeIDAt(blockAccess, x, y, z))) {
            return null;
        }
        return this.getTileWorld_Impl(renderBlockState, origIcon);
    }

    public final IIcon getTileHeld(RenderBlockState renderBlockState, IIcon origIcon) {
        if (this.icons == null) {
            this.properties.error("no images loaded, disabling", new Object[0]);
            return null;
        }
        Block block = renderBlockState.getBlock();
        if (block == null || RenderPassAPI.instance.skipThisRenderPass(block, this.renderPass)) {
            return null;
        }
        int face = renderBlockState.getTextureFace();
        if (face < 0 && this.requiresFace()) {
            this.properties.warning("method=%s is not supported for non-standard block %s", this.getMethod(), renderBlockState);
            return null;
        }
        if (this.height != null || this.biomes != null) {
            return null;
        }
        if (this.faceMatcher != null && !this.faceMatcher.match(renderBlockState)) {
            return null;
        }
        return this.getTileHeld_Impl(renderBlockState, origIcon);
    }

    abstract String getMethod();

    abstract IIcon getTileWorld_Impl(RenderBlockState var1, IIcon var2);

    abstract IIcon getTileHeld_Impl(RenderBlockState var1, IIcon var2);

    private static /* synthetic */ String jvmdowngrader$concat$getBlockList$1(String string) {
        return ":" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getBlockList$1(int n, String string) {
        return n + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getBlockList$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getTileList$1(String string) {
        return string + ".png";
    }
}

