/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import net.minecraft.block.Block;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

final class BlockOrientation
extends RenderBlockState {
    private static final boolean fixedBottomFaceUV = Launch.blackboard.getOrDefault("hodgepodge.FixesConfig.fixBottomFaceUV", Boolean.FALSE);
    private static final int[][][] NEIGHBOR_OFFSET = new int[][][]{fixedBottomFaceUV ? BlockOrientation.makeNeighborOffset(5, 3, 4, 2) : BlockOrientation.makeNeighborOffset(4, 3, 5, 2), BlockOrientation.makeNeighborOffset(4, 3, 5, 2), BlockOrientation.makeNeighborOffset(5, 0, 4, 1), BlockOrientation.makeNeighborOffset(4, 0, 5, 1), BlockOrientation.makeNeighborOffset(2, 0, 3, 1), BlockOrientation.makeNeighborOffset(3, 0, 2, 1)};
    private static final int[][] ROTATE_UV_MAP = new int[][]{{4, 5, 2, 3, 1, 0, 2, -2, 2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, 2}, {4, 5, 2, 3, 1, 0, 2, -2, -2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, -2}};
    private int x;
    private int y;
    private int z;
    private int metadata;
    private int altMetadata;
    private int metadataBits;
    private int renderType;
    private int blockFace;
    private int textureFace;
    private int textureFaceOrig;
    private int rotateUV;

    BlockOrientation() {
    }

    @Override
    public void clear() {
        super.clear();
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.renderType = -1;
        this.metadata = 0;
        this.textureFace = 0;
        this.blockFace = 0;
        this.rotateUV = 0;
        this.offsetsComputed = false;
        this.haveOffsets = false;
        this.dz = 0;
        this.dy = 0;
        this.dx = 0;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getBlockFace() {
        return this.blockFace;
    }

    @Override
    public int getTextureFace() {
        return this.textureFace;
    }

    @Override
    public int getTextureFaceOrig() {
        return this.textureFaceOrig;
    }

    @Override
    public int getFaceForHV() {
        return this.blockFace;
    }

    @Override
    public boolean match(BlockStateMatcher matcher) {
        return this.isInWorld() ? matcher.match(this.blockAccess, this.x, this.y, this.z) : matcher.match(this.block, this.metadata);
    }

    @Override
    public int[] getOffset(int blockFace, int relativeDirection) {
        return NEIGHBOR_OFFSET[blockFace][this.rotateUV(relativeDirection)];
    }

    @Override
    public boolean setCoordOffsetsForRenderType() {
        if (this.offsetsComputed) {
            return this.haveOffsets;
        }
        this.offsetsComputed = true;
        this.haveOffsets = false;
        this.dz = 0;
        this.dy = 0;
        this.dx = 0;
        switch (this.renderType) {
            case 1: {
                while (this.y + this.dy > 0 && this.block == this.blockAccess.func_147439_a(this.x, this.y + this.dy - 1, this.z)) {
                    --this.dy;
                    this.haveOffsets = true;
                }
                break;
            }
            case 7: 
            case 40: {
                if ((this.metadata & 8) == 0 || this.block != this.blockAccess.func_147439_a(this.x, this.y - 1, this.z)) break;
                --this.dy;
                this.haveOffsets = true;
                break;
            }
            case 14: {
                this.metadata = this.blockAccess.func_72805_g(this.x, this.y, this.z);
                switch (this.metadata) {
                    case 0: 
                    case 4: {
                        this.dz = 1;
                        break;
                    }
                    case 1: 
                    case 5: {
                        this.dx = -1;
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.dz = -1;
                        break;
                    }
                    case 3: 
                    case 7: {
                        this.dx = 1;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.haveOffsets = this.block == this.blockAccess.func_147439_a(this.x + this.dx, this.y, this.z + this.dz);
                break;
            }
        }
        return this.haveOffsets;
    }

    @Override
    public boolean shouldConnectByBlock(Block neighbor, int neighborX, int neighborY, int neighborZ) {
        return this.block == neighbor && (this.metadataBits & 1 << this.blockAccess.func_72805_g(neighborX, neighborY, neighborZ)) != 0;
    }

    @Override
    public boolean shouldConnectByTile(Block neighbor, IIcon origIcon, int neighborX, int neighborY, int neighborZ) {
        return origIcon == neighbor.func_149673_e(this.blockAccess, neighborX, neighborY, neighborZ, this.getTextureFaceOrig());
    }

    void setBlock(Block block, IBlockAccess blockAccess, int x, int y, int z) {
        this.block = block;
        this.blockAccess = blockAccess;
        this.inWorld = true;
        this.x = x;
        this.y = y;
        this.z = z;
        this.renderType = block.func_149645_b();
        this.metadata = this.altMetadata = blockAccess.func_72805_g(x, y, z);
        this.offsetsComputed = false;
    }

    void setFace(int face) {
        this.blockFace = this.getBlockFaceByRenderType(face);
        this.textureFaceOrig = face;
        this.rotateUV = 0;
        this.textureFace = this.blockFaceToTextureFace(this.blockFace);
        this.metadataBits = 1 << this.metadata | 1 << this.altMetadata;
    }

    void setBlockMetadata(Block block, int metadata, int face) {
        this.block = block;
        this.blockAccess = null;
        this.inWorld = false;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.renderType = block.func_149645_b();
        this.textureFace = this.textureFaceOrig = face;
        this.blockFace = this.textureFaceOrig;
        this.metadata = metadata;
        this.metadataBits = 1 << metadata;
        this.dz = 0;
        this.dy = 0;
        this.dx = 0;
        this.rotateUV = 0;
    }

    private int getBlockFaceByRenderType(int face) {
        switch (this.renderType) {
            case 1: {
                return 2;
            }
            case 8: {
                switch (this.metadata) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return this.metadata;
                    }
                }
                break;
            }
            case 20: {
                switch (this.metadata) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 8: {
                        return 4;
                    }
                }
            }
        }
        return face;
    }

    private int blockFaceToTextureFace(int face) {
        switch (this.renderType) {
            case 31: {
                switch (this.metadata & 0xC) {
                    case 4: {
                        this.altMetadata &= 0xFFFFFFF3;
                        this.rotateUV = ROTATE_UV_MAP[0][face + 6];
                        return ROTATE_UV_MAP[0][face];
                    }
                    case 8: {
                        this.altMetadata &= 0xFFFFFFF3;
                        this.rotateUV = ROTATE_UV_MAP[1][face + 6];
                        return ROTATE_UV_MAP[1][face];
                    }
                }
                break;
            }
            case 39: {
                switch (this.metadata) {
                    case 3: {
                        this.altMetadata = 2;
                        this.rotateUV = ROTATE_UV_MAP[2][face + 6];
                        return ROTATE_UV_MAP[2][face];
                    }
                    case 4: {
                        this.altMetadata = 2;
                        this.rotateUV = ROTATE_UV_MAP[3][face + 6];
                        return ROTATE_UV_MAP[3][face];
                    }
                }
            }
        }
        return face;
    }

    private int rotateUV(int neighbor) {
        return neighbor + this.rotateUV & 7;
    }
}

