/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ctm.RenderBlockState;

public class BlockFaceMatcher {
    private final int faces;

    protected BlockFaceMatcher(String[] values) {
        int flags = 0;
        String[] stringArray = values;
        int n = stringArray.length;
        block23: for (int i = 0; i < n; ++i) {
            String face;
            switch (face = stringArray[i]) {
                case "bottom": 
                case "down": {
                    flags |= 1;
                    continue block23;
                }
                case "top": 
                case "up": {
                    flags |= 2;
                    continue block23;
                }
                case "north": {
                    flags |= 4;
                    continue block23;
                }
                case "south": {
                    flags |= 8;
                    continue block23;
                }
                case "east": {
                    flags |= 0x20;
                    continue block23;
                }
                case "west": {
                    flags |= 0x10;
                    continue block23;
                }
                case "side": 
                case "sides": {
                    flags |= 0x3C;
                    continue block23;
                }
                case "all": {
                    flags = -1;
                }
            }
        }
        this.faces = flags;
    }

    public boolean match(RenderBlockState renderBlockState) {
        int face = renderBlockState.getTextureFace();
        return face >= 0 && (this.faces & 1 << face) != 0;
    }

    protected boolean isAll() {
        return this.faces == -1;
    }

    public static BlockFaceMatcher create(String propertyValue) {
        if (!MCPatcherUtils.isNullOrEmpty(propertyValue)) {
            String[] values = propertyValue.toLowerCase().split("\\s+");
            try {
                BlockFaceMatcher matcher = new BlockFaceMatcher(values);
                if (!matcher.isAll()) {
                    return matcher;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

