/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jss.notfine.util.MapColorExpansion;
import jss.notfine.util.PotionExpansion;
import net.minecraft.block.material.MapColor;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ColorizeItem {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_COLORS);
    private static final Map<Integer, String> entityNamesByID = new HashMap<Integer, String>();
    private static final Map<Integer, Integer> spawnerEggShellColors = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> spawnerEggSpotColors = new HashMap<Integer, Integer>();
    private static int waterBottleColor;
    private static final List<Potion> potions;
    private static boolean potionsInitialized;
    private static final String[] MAP_MATERIALS;

    static void reset() {
        spawnerEggShellColors.clear();
        spawnerEggSpotColors.clear();
        if (potionsInitialized && PotionHelper.field_77925_n != null) {
            PotionHelper.field_77925_n.clear();
        }
        potionsInitialized = true;
        waterBottleColor = 3694022;
        for (Potion potion : potions) {
            potion.field_76414_N = ((PotionExpansion)potion).getOrigColor();
        }
        for (MapColor mapColor : MapColor.field_76281_a) {
            if (mapColor == null) continue;
            mapColor.field_76291_p = ((MapColorExpansion)mapColor).getOriginalColorValue();
        }
    }

    static void reloadPotionColors(PropertiesFile properties) {
        for (Potion potion : potions) {
            Colorizer.loadIntColor(potion.func_76393_a(), potion);
        }
        int[] temp = new int[]{waterBottleColor};
        Colorizer.loadIntColor("potion.water", temp, 0);
        waterBottleColor = temp[0];
    }

    static void reloadMapColors(PropertiesFile properties) {
        for (int i = 0; i < MapColor.field_76281_a.length; ++i) {
            if (MapColor.field_76281_a[i] == null) continue;
            int[] rgb = new int[]{((MapColorExpansion)MapColor.field_76281_a[i]).getOriginalColorValue()};
            Colorizer.loadIntColor(ColorizeItem.jvmdowngrader$concat$reloadMapColors$1(Colorizer.getStringKey(MAP_MATERIALS, i)), rgb, 0);
            MapColor.field_76281_a[i].field_76291_p = rgb[0];
        }
    }

    public static void setupSpawnerEgg(String entityName, int entityID, int defaultShellColor, int defaultSpotColor) {
        logger.config("egg.shell.%s=%06x", entityName, defaultShellColor);
        logger.config("egg.spots.%s=%06x", entityName, defaultSpotColor);
        entityNamesByID.put(entityID, entityName);
    }

    public static void setupPotion(Potion potion) {
        ((PotionExpansion)potion).setOrigColor(potion.func_76401_j());
        potions.add(potion);
    }

    public static int colorizeSpawnerEgg(int defaultColor, int entityID, int spots) {
        String name;
        Map<Integer, Integer> eggMap;
        if (!Colorizer.useEggColors) {
            return defaultColor;
        }
        Integer value = null;
        Map<Integer, Integer> map = eggMap = spots == 0 ? spawnerEggShellColors : spawnerEggSpotColors;
        if (eggMap.containsKey(entityID)) {
            value = eggMap.get(entityID);
        } else if (entityNamesByID.containsKey(entityID) && (name = entityNamesByID.get(entityID)) != null) {
            int[] tmp = new int[]{defaultColor};
            Colorizer.loadIntColor(ColorizeItem.jvmdowngrader$concat$colorizeSpawnerEgg$1(spots == 0 ? "egg.shell." : "egg.spots.", name), tmp, 0);
            eggMap.put(entityID, tmp[0]);
            value = tmp[0];
        }
        return value == null ? defaultColor : value;
    }

    public static int getWaterBottleColor() {
        return waterBottleColor;
    }

    static {
        potions = new ArrayList<Potion>();
        MAP_MATERIALS = new String[]{"air", "grass", "sand", "cloth", "tnt", "ice", "iron", "foliage", "snow", "clay", "dirt", "stone", "water", "wood", "quartz", "adobe", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black", "gold", "diamond", "lapis", "emerald", "obsidian", "netherrack"};
        try {
            ColorizeItem.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$reloadMapColors$1(String string) {
        return "map." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$colorizeSpawnerEgg$1(String string, String string2) {
        return string + string2;
    }
}

