/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.cc.ColorizeWorld;
import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ColorizeEntity {
    private static final ResourceLocation LAVA_DROP_COLORS = TexturePackAPI.newMCPatcherResourceLocation("colormap/lavadrop.png");
    private static final ResourceLocation MYCELIUM_COLORS = TexturePackAPI.newMCPatcherResourceLocation("colormap/myceliumparticle.png");
    private static final ResourceLocation XPORB_COLORS = TexturePackAPI.newMCPatcherResourceLocation("colormap/xporb.png");
    static float[] waterBaseColor;
    private static float[] lavaDropColors;
    public static float[] portalColor;
    private static final Random random;
    private static int[] myceliumColors;
    private static int[] xpOrbColors;
    public static int xpOrbRed;
    public static int xpOrbGreen;
    public static int xpOrbBlue;
    private static final String[] colorNames;
    private static final Integer[] dyeColors;
    private static final float[][] fleeceColors;
    private static final float[][] collarColors;
    private static final float[][] armorColors;
    public static int undyedLeatherColor;

    static void reset() {
        waterBaseColor = new float[]{0.2f, 0.3f, 1.0f};
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        lavaDropColors = null;
        Arrays.fill((Object[])dyeColors, null);
        Arrays.fill((Object[])fleeceColors, null);
        Arrays.fill((Object[])collarColors, null);
        Arrays.fill((Object[])armorColors, null);
        undyedLeatherColor = 10511680;
        myceliumColors = null;
        xpOrbColors = null;
    }

    static void reloadParticleColors(PropertiesFile properties) {
        Colorizer.loadFloatColor("drop.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.portal", portalColor);
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(LAVA_DROP_COLORS));
        if (rgb != null) {
            lavaDropColors = new float[3 * rgb.length];
            for (int i = 0; i < rgb.length; ++i) {
                ColorUtils.intToFloat3(rgb[i], lavaDropColors, 3 * i);
            }
        }
        myceliumColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(MYCELIUM_COLORS));
    }

    static void reloadDyeColors(PropertiesFile properties) {
        int i;
        for (i = 0; i < colorNames.length; ++i) {
            ColorizeEntity.dyeColors[i] = Colorizer.loadIntegerColor(ColorizeEntity.jvmdowngrader$concat$reloadDyeColors$1(Colorizer.getStringKey(colorNames, i)));
        }
        for (i = 0; i < colorNames.length; ++i) {
            String key = Colorizer.getStringKey(colorNames, i);
            ColorizeEntity.fleeceColors[i] = Colorizer.loadFloatColor(ColorizeEntity.jvmdowngrader$concat$reloadDyeColors$2(key));
            ColorizeEntity.collarColors[i] = Colorizer.loadFloatColor(ColorizeEntity.jvmdowngrader$concat$reloadDyeColors$3(key));
            ColorizeEntity.armorColors[i] = Colorizer.loadFloatColor(ColorizeEntity.jvmdowngrader$concat$reloadDyeColors$4(key));
        }
        undyedLeatherColor = Colorizer.loadIntColor("armor.default", undyedLeatherColor);
    }

    static void reloadXPOrbColors(PropertiesFile properties) {
        xpOrbColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(XPORB_COLORS));
    }

    public static int colorizeXPOrb(int origColor, float timer) {
        if (xpOrbColors == null || xpOrbColors.length == 0) {
            return origColor;
        }
        return xpOrbColors[(int)((Math.sin((double)timer / 4.0) + 1.0) * (double)(xpOrbColors.length - 1) / 2.0)];
    }

    public static int colorizeXPOrb(int origRed, int origBlue, float timer) {
        int color = ColorizeEntity.colorizeXPOrb(origRed << 16 | 0xFF | origBlue, timer);
        xpOrbRed = color >> 16 & 0xFF;
        xpOrbGreen = color >> 8 & 0xFF;
        xpOrbBlue = color & 0xFF;
        return xpOrbRed;
    }

    public static boolean computeLavaDropColor(int age) {
        if (lavaDropColors == null) {
            return false;
        }
        int offset = 3 * Math.max(Math.min(lavaDropColors.length / 3 - 1, age - 20), 0);
        System.arraycopy(lavaDropColors, offset, Colorizer.setColor, 0, 3);
        return true;
    }

    public static boolean computeMyceliumParticleColor() {
        if (myceliumColors == null) {
            return false;
        }
        Colorizer.setColorF(myceliumColors[random.nextInt(myceliumColors.length)]);
        return true;
    }

    public static void computeSuspendColor(int defaultColor, int i, int j, int k) {
        if (ColorizeWorld.underwaterColor != null) {
            defaultColor = ColorizeWorld.underwaterColor.getColorMultiplier(BiomeAPI.getWorld(), i, j, k);
        }
        Colorizer.setColorF(defaultColor);
    }

    public static float[] getWolfCollarColor(float[] rgb, int index) {
        return ColorizeEntity.getArrayColor(collarColors, rgb, index);
    }

    public static float[] getArmorDyeColor(float[] rgb, int index) {
        return ColorizeEntity.getArrayColor(armorColors, rgb, index);
    }

    private static float[] getArrayColor(float[][] array, float[] rgb, int index) {
        float[] newRGB = array[index];
        return newRGB == null ? rgb : newRGB;
    }

    static {
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        random = new Random();
        colorNames = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        dyeColors = new Integer[colorNames.length];
        fleeceColors = new float[colorNames.length][];
        collarColors = new float[colorNames.length][];
        armorColors = new float[colorNames.length][];
        try {
            ColorizeEntity.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$reloadDyeColors$1(String string) {
        return "dye." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reloadDyeColors$2(String string) {
        return "sheep." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reloadDyeColors$3(String string) {
        return "collar." + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reloadDyeColors$4(String string) {
        return "armor." + string;
    }
}

