/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.lwjgl.lwjgl3;

import com.mitchej123.lwjgl.DebugExtension;
import com.mitchej123.lwjgl.DebugMessageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;

final class LWJGL3DebugSupport {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/LWJGL3Debug");
    private GLDebugMessageCallback debugCallback;
    private GLDebugMessageARBCallback debugCallbackARB;
    private GLDebugMessageAMDCallback debugCallbackAMD;

    LWJGL3DebugSupport() {
    }

    int setupDebugCallback(DebugMessageHandler handler) {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            LOGGER.info("Using OpenGL 4.3 for debug output");
            this.debugCallback = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> handler.handle(source, type, id, severity, GLDebugMessageCallback.getMessage((int)length, (long)message), DebugExtension.GL43));
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            GL43C.glDebugMessageCallback((GLDebugMessageCallbackI)this.debugCallback, (long)0L);
            if ((GL43C.glGetInteger((int)33310) & 2) == 0) {
                LOGGER.warn("Non-debug context may not produce debug output");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_KHR_debug) {
            LOGGER.info("Using KHR_debug for debug output");
            this.debugCallback = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> handler.handle(source, type, id, severity, GLDebugMessageCallback.getMessage((int)length, (long)message), DebugExtension.KHR_DEBUG));
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)this.debugCallback, (long)0L);
            if (caps.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                LOGGER.warn("Non-debug context may not produce debug output");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_ARB_debug_output) {
            LOGGER.info("Using ARB_debug_output for debug output");
            this.debugCallbackARB = GLDebugMessageARBCallback.create((source, type, id, severity, length, message, userParam) -> handler.handle(source, type, id, severity, GLDebugMessageARBCallback.getMessage((int)length, (long)message), DebugExtension.ARB_DEBUG_OUTPUT));
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)this.debugCallbackARB, (long)0L);
            return 1;
        }
        if (caps.GL_AMD_debug_output) {
            LOGGER.info("Using AMD_debug_output for debug output");
            this.debugCallbackAMD = GLDebugMessageAMDCallback.create((id, category, severity, length, message, userParam) -> handler.handle(category, 0, id, severity, GLDebugMessageAMDCallback.getMessage((int)length, (long)message), DebugExtension.AMD_DEBUG_OUTPUT));
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, (int[])null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)this.debugCallbackAMD, (long)0L);
            return 1;
        }
        LOGGER.info("No debug output implementation available");
        return 0;
    }

    void disableDebugCallback() {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            GL43C.glDebugMessageCallback(null, (long)0L);
        } else if (caps.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null, (long)0L);
            if (caps.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                GL43C.glDisable((int)37600);
            }
        } else if (caps.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null, (long)0L);
        } else if (caps.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null, (long)0L);
        }
        if (this.debugCallback != null) {
            this.debugCallback.free();
            this.debugCallback = null;
        }
        if (this.debugCallbackARB != null) {
            this.debugCallbackARB.free();
            this.debugCallbackARB = null;
        }
        if (this.debugCallbackAMD != null) {
            this.debugCallbackAMD.free();
            this.debugCallbackAMD = null;
        }
    }
}

