/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.lwjgl.lwjgl2;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.bytebuf.Pointer;
import com.mitchej123.lwjgl.DebugMessageHandler;
import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLService;
import com.mitchej123.lwjgl.MemoryStack;
import com.mitchej123.lwjgl.lwjgl2.LWJGL2DebugSupport;
import com.mitchej123.lwjgl.lwjgl2.LWJGL2MemoryStack;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ARBCopyBuffer;
import org.lwjgl.opengl.ARBDrawElementsBaseVertex;
import org.lwjgl.opengl.ARBMapBufferRange;
import org.lwjgl.opengl.ARBMultiDrawIndirect;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.ARBTimerQuery;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.EXTGpuShader4;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;
import org.lwjgl.opengl.KHRDebug;

public class LWJGL2Service
implements LWJGLService {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/LWJGL2Service");
    private final LWJGL2DebugSupport debugSupport = new LWJGL2DebugSupport();
    private final Long2ObjectOpenHashMap<GLSync> syncObjects = new Long2ObjectOpenHashMap();
    private final VAOMode vaoMode;
    private final TimerQueryMode timerQueryMode;
    private final DebugMode debugMode;
    private final VertexAttribIMode vertexAttribIMode;

    public LWJGL2Service() {
        ContextCapabilities caps = GLContext.getCapabilities();
        this.vaoMode = caps.OpenGL30 ? VAOMode.CORE : (caps.GL_ARB_vertex_array_object ? VAOMode.ARB : (caps.GL_APPLE_vertex_array_object ? VAOMode.APPLE : VAOMode.NONE));
        if (caps.OpenGL33) {
            this.timerQueryMode = TimerQueryMode.CORE;
        } else if (caps.GL_ARB_timer_query) {
            this.timerQueryMode = TimerQueryMode.ARB;
        } else {
            this.timerQueryMode = TimerQueryMode.NONE;
            LOGGER.warn("ARB_timer_query extension not available - GPU profiling will be disabled");
        }
        this.debugMode = caps.GL_KHR_debug || caps.OpenGL43 ? DebugMode.KHR : DebugMode.NONE;
        this.vertexAttribIMode = caps.OpenGL30 ? VertexAttribIMode.CORE : (caps.GL_EXT_gpu_shader4 ? VertexAttribIMode.EXT : VertexAttribIMode.NONE);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isOpenGLVersionSupported(int major, int minor) {
        ContextCapabilities caps = GLContext.getCapabilities();
        switch (major * 10 + minor) {
            case 11: {
                return caps.OpenGL11;
            }
            case 12: {
                return caps.OpenGL12;
            }
            case 13: {
                return caps.OpenGL13;
            }
            case 14: {
                return caps.OpenGL14;
            }
            case 15: {
                return caps.OpenGL15;
            }
            case 20: {
                return caps.OpenGL20;
            }
            case 21: {
                return caps.OpenGL21;
            }
            case 30: {
                return caps.OpenGL30;
            }
            case 31: {
                return caps.OpenGL31;
            }
            case 32: {
                return caps.OpenGL32;
            }
            case 33: {
                return caps.OpenGL33;
            }
            case 40: {
                return caps.OpenGL40;
            }
            case 41: {
                return caps.OpenGL41;
            }
            case 42: {
                return caps.OpenGL42;
            }
            case 43: {
                return caps.OpenGL43;
            }
            case 44: {
                return caps.OpenGL44;
            }
            case 45: {
                return caps.OpenGL45;
            }
        }
        return false;
    }

    @Override
    public boolean isExtensionSupported(GLExtension extension) {
        ContextCapabilities caps = GLContext.getCapabilities();
        switch (extension) {
            case ARB_buffer_storage: {
                return caps.GL_ARB_buffer_storage;
            }
            case ARB_multi_draw_indirect: {
                return caps.GL_ARB_multi_draw_indirect;
            }
            case ARB_draw_elements_base_vertex: {
                return caps.GL_ARB_draw_elements_base_vertex;
            }
            case ARB_direct_state_access: {
                return caps.GL_ARB_direct_state_access;
            }
            case ARB_shader_storage_buffer_object: {
                return caps.GL_ARB_shader_storage_buffer_object;
            }
            case ARB_sync: {
                return caps.GL_ARB_sync;
            }
            case ARB_timer_query: {
                return caps.GL_ARB_timer_query;
            }
            case ARB_debug_output: {
                return caps.GL_ARB_debug_output;
            }
            case KHR_debug: {
                return caps.GL_KHR_debug;
            }
            case AMD_debug_output: {
                return caps.GL_AMD_debug_output;
            }
            case ARB_uniform_buffer_object: {
                return caps.GL_ARB_uniform_buffer_object;
            }
            case ARB_vertex_array_object: {
                return caps.GL_ARB_vertex_array_object;
            }
            case ARB_map_buffer_range: {
                return caps.GL_ARB_map_buffer_range;
            }
            case ARB_copy_buffer: {
                return caps.GL_ARB_copy_buffer;
            }
            case ARB_texture_storage: {
                return caps.GL_ARB_texture_storage;
            }
            case ARB_base_instance: {
                return caps.GL_ARB_base_instance;
            }
            case ARB_compatibility: {
                return caps.GL_ARB_compatibility;
            }
        }
        return false;
    }

    @Override
    public int getPointerSize() {
        return Pointer.POINTER_SIZE;
    }

    @Override
    public int glGenBuffers() {
        return GL15.glGenBuffers();
    }

    @Override
    public void glDeleteBuffers(int buffer) {
        GL15.glDeleteBuffers((int)buffer);
    }

    @Override
    public void glBindBuffer(int target, int buffer) {
        GL15.glBindBuffer((int)target, (int)buffer);
    }

    @Override
    public void glBufferData(int target, long size, int usage) {
        GL15.glBufferData((int)target, (long)size, (int)usage);
    }

    @Override
    public void glBufferData(int target, ByteBuffer data, int usage) {
        GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    @Override
    public void glBufferData(int target, long size, long data, int usage) {
        if (data == 0L) {
            GL15.glBufferData((int)target, (long)size, (int)usage);
        } else {
            ByteBuffer buf = MemoryUtilities.memByteBuffer((long)data, (int)((int)size));
            GL15.glBufferData((int)target, (ByteBuffer)buf, (int)usage);
        }
    }

    @Override
    public void glBufferStorage(int target, long size, int flags) {
        if (!GLContext.getCapabilities().GL_ARB_buffer_storage) {
            throw new UnsupportedOperationException("GL_ARB_buffer_storage not available");
        }
        ARBBufferStorage.glBufferStorage((int)target, (long)size, (int)flags);
    }

    @Override
    public ByteBuffer glMapBufferRange(int target, long offset, long length, int flags) {
        if (GLContext.getCapabilities().OpenGL30) {
            return GL30.glMapBufferRange((int)target, (long)offset, (long)length, (int)flags, null);
        }
        if (GLContext.getCapabilities().GL_ARB_map_buffer_range) {
            return ARBMapBufferRange.glMapBufferRange((int)target, (long)offset, (long)length, (int)flags, null);
        }
        throw new UnsupportedOperationException("glMapBufferRange not available");
    }

    @Override
    public long nglMapBuffer(int target, int access) {
        ByteBuffer buf = GL15.glMapBuffer((int)target, (int)access, null);
        return buf != null ? MemoryUtilities.memAddress((ByteBuffer)buf) : 0L;
    }

    @Override
    public ByteBuffer glMapBuffer(int target, int access) {
        return GL15.glMapBuffer((int)target, (int)access, null);
    }

    @Override
    public void glUnmapBuffer(int target) {
        GL15.glUnmapBuffer((int)target);
    }

    @Override
    public void glFlushMappedBufferRange(int target, long offset, long length) {
        if (GLContext.getCapabilities().OpenGL30) {
            GL30.glFlushMappedBufferRange((int)target, (long)offset, (long)length);
        } else if (GLContext.getCapabilities().GL_ARB_map_buffer_range) {
            ARBMapBufferRange.glFlushMappedBufferRange((int)target, (long)offset, (long)length);
        } else {
            throw new UnsupportedOperationException("glFlushMappedBufferRange not available");
        }
    }

    @Override
    public void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        if (GLContext.getCapabilities().OpenGL31) {
            GL31.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
        } else if (GLContext.getCapabilities().GL_ARB_copy_buffer) {
            ARBCopyBuffer.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
        } else {
            throw new UnsupportedOperationException("glCopyBufferSubData not available");
        }
    }

    @Override
    public void glBindBufferBase(int target, int index, int buffer) {
        if (GLContext.getCapabilities().OpenGL30) {
            GL30.glBindBufferBase((int)target, (int)index, (int)buffer);
        } else if (GLContext.getCapabilities().GL_ARB_uniform_buffer_object) {
            ARBUniformBufferObject.glBindBufferBase((int)target, (int)index, (int)buffer);
        } else {
            throw new UnsupportedOperationException("glBindBufferBase not available");
        }
    }

    @Override
    public int glGenVertexArrays() {
        switch (this.vaoMode.ordinal()) {
            case 0: {
                return GL30.glGenVertexArrays();
            }
            case 1: {
                return ARBVertexArrayObject.glGenVertexArrays();
            }
            case 2: {
                return APPLEVertexArrayObject.glGenVertexArraysAPPLE();
            }
        }
        throw new UnsupportedOperationException("VAO not supported");
    }

    @Override
    public void glDeleteVertexArrays(int array) {
        switch (this.vaoMode.ordinal()) {
            case 0: {
                GL30.glDeleteVertexArrays((int)array);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glDeleteVertexArrays((int)array);
                break;
            }
            case 2: {
                APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((int)array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("VAO not supported");
            }
        }
    }

    @Override
    public void glBindVertexArray(int array) {
        switch (this.vaoMode.ordinal()) {
            case 0: {
                GL30.glBindVertexArray((int)array);
                break;
            }
            case 1: {
                ARBVertexArrayObject.glBindVertexArray((int)array);
                break;
            }
            case 2: {
                APPLEVertexArrayObject.glBindVertexArrayAPPLE((int)array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("VAO not supported");
            }
        }
    }

    @Override
    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)pointer);
    }

    @Override
    public void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        switch (this.vertexAttribIMode.ordinal()) {
            case 0: {
                GL30.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)pointer);
                break;
            }
            case 1: {
                EXTGpuShader4.glVertexAttribIPointerEXT((int)index, (int)size, (int)type, (int)stride, (long)pointer);
                break;
            }
            default: {
                throw new UnsupportedOperationException("glVertexAttribIPointer not supported");
            }
        }
    }

    @Override
    public void glEnableVertexAttribArray(int index) {
        GL20.glEnableVertexAttribArray((int)index);
    }

    @Override
    public int glCreateShader(int type) {
        return GL20.glCreateShader((int)type);
    }

    @Override
    public void glShaderSource(int shader, CharSequence source) {
        GL20.glShaderSource((int)shader, (CharSequence)source);
    }

    @Override
    public void glShaderSourceSafe(int shader, CharSequence source) {
        ByteBuffer sourceBuffer = MemoryUtilities.memUTF8((CharSequence)source, (boolean)true);
        GL20.glShaderSource((int)shader, (ByteBuffer)sourceBuffer);
    }

    @Override
    public void glCompileShader(int shader) {
        GL20.glCompileShader((int)shader);
    }

    @Override
    public String glGetShaderInfoLog(int shader, int maxLength) {
        return GL20.glGetShaderInfoLog((int)shader, (int)maxLength);
    }

    @Override
    public int glGetShaderi(int shader, int pname) {
        return GL20.glGetShaderi((int)shader, (int)pname);
    }

    @Override
    public void glDeleteShader(int shader) {
        GL20.glDeleteShader((int)shader);
    }

    @Override
    public int glCreateProgram() {
        return GL20.glCreateProgram();
    }

    @Override
    public void glAttachShader(int program, int shader) {
        GL20.glAttachShader((int)program, (int)shader);
    }

    @Override
    public void glLinkProgram(int program) {
        GL20.glLinkProgram((int)program);
    }

    @Override
    public String glGetProgramInfoLog(int program, int maxLength) {
        return GL20.glGetProgramInfoLog((int)program, (int)maxLength);
    }

    @Override
    public int glGetProgrami(int program, int pname) {
        return GL20.glGetProgrami((int)program, (int)pname);
    }

    @Override
    public void glUseProgram(int program) {
        GL20.glUseProgram((int)program);
    }

    @Override
    public void glDeleteProgram(int program) {
        GL20.glDeleteProgram((int)program);
    }

    @Override
    public void glBindAttribLocation(int program, int index, CharSequence name) {
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    @Override
    public void glBindFragDataLocation(int program, int colorNumber, CharSequence name) {
        if (!GLContext.getCapabilities().OpenGL30) {
            throw new UnsupportedOperationException("glBindFragDataLocation not supported (requires OpenGL 3.0)");
        }
        GL30.glBindFragDataLocation((int)program, (int)colorNumber, (CharSequence)name);
    }

    @Override
    public int glGetUniformLocation(int program, CharSequence name) {
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    @Override
    public int glGetUniformBlockIndex(int program, CharSequence name) {
        if (GLContext.getCapabilities().OpenGL31) {
            return GL31.glGetUniformBlockIndex((int)program, (CharSequence)name);
        }
        if (GLContext.getCapabilities().GL_ARB_uniform_buffer_object) {
            return ARBUniformBufferObject.glGetUniformBlockIndex((int)program, (CharSequence)name);
        }
        throw new UnsupportedOperationException("glGetUniformBlockIndex not available");
    }

    @Override
    public void glUniformBlockBinding(int program, int blockIndex, int blockBinding) {
        if (GLContext.getCapabilities().OpenGL31) {
            GL31.glUniformBlockBinding((int)program, (int)blockIndex, (int)blockBinding);
        } else if (GLContext.getCapabilities().GL_ARB_uniform_buffer_object) {
            ARBUniformBufferObject.glUniformBlockBinding((int)program, (int)blockIndex, (int)blockBinding);
        } else {
            throw new UnsupportedOperationException("glUniformBlockBinding not available");
        }
    }

    @Override
    public void glUniform1f(int location, float v0) {
        GL20.glUniform1f((int)location, (float)v0);
    }

    @Override
    public void glUniform1i(int location, int v0) {
        GL20.glUniform1i((int)location, (int)v0);
    }

    @Override
    public void glUniform1fv(int location, FloatBuffer value) {
        GL20.glUniform1((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform2i(int location, int v0, int v1) {
        GL20.glUniform2i((int)location, (int)v0, (int)v1);
    }

    @Override
    public void glUniform3f(int location, float v0, float v1, float v2) {
        GL20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    @Override
    public void glUniform3fv(int location, FloatBuffer value) {
        GL20.glUniform3((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform3fv(int location, float[] value) {
        GL20.glUniform3f((int)location, (float)value[0], (float)value[1], (float)value[2]);
    }

    @Override
    public void glUniform4fv(int location, FloatBuffer value) {
        GL20.glUniform4((int)location, (FloatBuffer)value);
    }

    @Override
    public void glUniform4fv(int location, float[] value) {
        GL20.glUniform4f((int)location, (float)value[0], (float)value[1], (float)value[2], (float)value[3]);
    }

    @Override
    public void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    @Override
    public void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        if (GLContext.getCapabilities().OpenGL32) {
            GL32.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
        } else if (GLContext.getCapabilities().GL_ARB_draw_elements_base_vertex) {
            ARBDrawElementsBaseVertex.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
        } else {
            throw new UnsupportedOperationException("glDrawElementsBaseVertex not available");
        }
    }

    @Override
    public void glMultiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int drawcount, long pBaseVertex) {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (caps.OpenGL32 || caps.GL_ARB_draw_elements_base_vertex) {
            for (int i = 0; i < drawcount; ++i) {
                int count = MemoryUtilities.memGetInt((long)(pCount + (long)i * 4L));
                if (count <= 0) continue;
                long indices = MemoryUtilities.memGetAddress((long)(pIndices + (long)i * (long)Pointer.POINTER_SIZE));
                int baseVertex = MemoryUtilities.memGetInt((long)(pBaseVertex + (long)i * 4L));
                if (caps.OpenGL32) {
                    GL32.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)baseVertex);
                    continue;
                }
                ARBDrawElementsBaseVertex.glDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)baseVertex);
            }
        } else {
            throw new UnsupportedOperationException("glMultiDrawElementsBaseVertex not available");
        }
    }

    @Override
    public void glMultiDrawElementsIndirect(int mode, int type, long indirect, int drawcount, int stride) {
        if (GLContext.getCapabilities().OpenGL43) {
            GL43.glMultiDrawElementsIndirect((int)mode, (int)type, (long)indirect, (int)drawcount, (int)stride);
        } else if (GLContext.getCapabilities().GL_ARB_multi_draw_indirect) {
            ARBMultiDrawIndirect.glMultiDrawElementsIndirect((int)mode, (int)type, (long)indirect, (int)drawcount, (int)stride);
        } else {
            throw new UnsupportedOperationException("glMultiDrawElementsIndirect not available");
        }
    }

    @Override
    public long glFenceSync(int condition, int flags) {
        GLSync sync;
        if (GLContext.getCapabilities().OpenGL32) {
            sync = GL32.glFenceSync((int)condition, (int)flags);
        } else if (GLContext.getCapabilities().GL_ARB_sync) {
            sync = ARBSync.glFenceSync((int)condition, (int)flags);
        } else {
            throw new UnsupportedOperationException("glFenceSync not available");
        }
        long pointer = sync.getPointer();
        this.syncObjects.put(pointer, (Object)sync);
        return pointer;
    }

    @Override
    public int glClientWaitSync(long sync, int flags, long timeout) {
        GLSync obj = (GLSync)this.syncObjects.get(sync);
        if (GLContext.getCapabilities().OpenGL32) {
            return GL32.glClientWaitSync((GLSync)obj, (int)flags, (long)timeout);
        }
        if (GLContext.getCapabilities().GL_ARB_sync) {
            return ARBSync.glClientWaitSync((GLSync)obj, (int)flags, (long)timeout);
        }
        throw new UnsupportedOperationException("glClientWaitSync not available");
    }

    @Override
    public int glGetSynci(long sync, int pname, IntBuffer length) {
        int result;
        GLSync obj = (GLSync)this.syncObjects.get(sync);
        if (GLContext.getCapabilities().OpenGL32) {
            result = GL32.glGetSynci((GLSync)obj, (int)pname);
        } else if (GLContext.getCapabilities().GL_ARB_sync) {
            result = ARBSync.glGetSynci((GLSync)obj, (int)pname);
        } else {
            throw new UnsupportedOperationException("glGetSynci not available");
        }
        if (length != null) {
            length.put(0, 1);
        }
        return result;
    }

    @Override
    public void glWaitSync(long sync, int flags, long timeout) {
        GLSync obj = (GLSync)this.syncObjects.get(sync);
        if (GLContext.getCapabilities().OpenGL32) {
            GL32.glWaitSync((GLSync)obj, (int)flags, (long)timeout);
        } else if (GLContext.getCapabilities().GL_ARB_sync) {
            ARBSync.glWaitSync((GLSync)obj, (int)flags, (long)timeout);
        } else {
            throw new UnsupportedOperationException("glWaitSync not available");
        }
    }

    @Override
    public void glDeleteSync(long sync) {
        GLSync obj = (GLSync)this.syncObjects.remove(sync);
        if (obj == null) {
            return;
        }
        if (GLContext.getCapabilities().OpenGL32) {
            GL32.glDeleteSync((GLSync)obj);
        } else if (GLContext.getCapabilities().GL_ARB_sync) {
            ARBSync.glDeleteSync((GLSync)obj);
        } else {
            throw new UnsupportedOperationException("glDeleteSync not available");
        }
    }

    @Override
    public int glGenQueries() {
        return GL15.glGenQueries();
    }

    @Override
    public void glDeleteQueries(int query) {
        GL15.glDeleteQueries((int)query);
    }

    @Override
    public void glQueryCounter(int id, int target) {
        switch (this.timerQueryMode.ordinal()) {
            case 0: {
                GL33.glQueryCounter((int)id, (int)target);
                break;
            }
            case 1: {
                ARBTimerQuery.glQueryCounter((int)id, (int)target);
                break;
            }
        }
    }

    @Override
    public long glGetQueryObjectui64(int id, int pname) {
        switch (this.timerQueryMode.ordinal()) {
            case 0: {
                return GL33.glGetQueryObjectui64((int)id, (int)pname);
            }
            case 1: {
                return ARBTimerQuery.glGetQueryObjectui64((int)id, (int)pname);
            }
        }
        return 0L;
    }

    @Override
    public PrintStream getDebugStream() {
        return System.err;
    }

    @Override
    public int setupDebugCallback(DebugMessageHandler handler) {
        return this.debugSupport.setupDebugCallback(handler);
    }

    @Override
    public void disableDebugCallback() {
        this.debugSupport.disableDebugCallback();
    }

    @Override
    public void glObjectLabel(int identifier, int name, CharSequence label) {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glObjectLabel((int)identifier, (int)name, (CharSequence)label);
        }
    }

    @Override
    public void glPushDebugGroup(int source, int id, CharSequence message) {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glPushDebugGroup((int)source, (int)id, (CharSequence)message);
        }
    }

    @Override
    public void glPopDebugGroup() {
        if (this.debugMode == DebugMode.KHR) {
            KHRDebug.glPopDebugGroup();
        }
    }

    @Override
    public int glGenTextures() {
        return GL11.glGenTextures();
    }

    @Override
    public void glGenTextures(int[] textures) {
        IntBuffer buf = MemoryUtilities.memAllocInt((int)textures.length);
        GL11.glGenTextures((IntBuffer)buf);
        buf.get(textures);
        MemoryUtilities.memFree((IntBuffer)buf);
    }

    @Override
    public void glDeleteTextures(int texture) {
        GL11.glDeleteTextures((int)texture);
    }

    @Override
    public void glDeleteTextures(int[] textures) {
        IntBuffer buf = MemoryUtilities.memAllocInt((int)textures.length).put(textures).flip();
        GL11.glDeleteTextures((IntBuffer)buf);
        MemoryUtilities.memFree((IntBuffer)buf);
    }

    @Override
    public void glBindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    @Override
    public void glActiveTexture(int texture) {
        GL13.glActiveTexture((int)texture);
    }

    @Override
    public int glGetTexLevelParameteri(int target, int level, int pname) {
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
    }

    @Override
    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glPixelStorei(int pname, int param) {
        GL11.glPixelStorei((int)pname, (int)param);
    }

    @Override
    public int glGenFramebuffers() {
        if (GLContext.getCapabilities().OpenGL30) {
            return GL30.glGenFramebuffers();
        }
        if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            return EXTFramebufferObject.glGenFramebuffersEXT();
        }
        throw new UnsupportedOperationException("Framebuffers not available");
    }

    @Override
    public void glDeleteFramebuffers(int framebuffer) {
        if (GLContext.getCapabilities().OpenGL30) {
            GL30.glDeleteFramebuffers((int)framebuffer);
        } else if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebuffer);
        } else {
            throw new UnsupportedOperationException("Framebuffers not available");
        }
    }

    @Override
    public void glBindFramebuffer(int target, int framebuffer) {
        if (GLContext.getCapabilities().OpenGL30) {
            GL30.glBindFramebuffer((int)target, (int)framebuffer);
        } else if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
        } else {
            throw new UnsupportedOperationException("Framebuffers not available");
        }
    }

    @Override
    public int glCheckFramebufferStatus(int target) {
        if (GLContext.getCapabilities().OpenGL30) {
            return GL30.glCheckFramebufferStatus((int)target);
        }
        if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
        }
        throw new UnsupportedOperationException("Framebuffers not available");
    }

    @Override
    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        if (GLContext.getCapabilities().OpenGL30) {
            GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
        } else if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
        } else {
            throw new UnsupportedOperationException("Framebuffers not available");
        }
    }

    @Override
    public void glEnable(int cap) {
        GL11.glEnable((int)cap);
    }

    @Override
    public void glDisable(int cap) {
        GL11.glDisable((int)cap);
    }

    @Override
    public void glBlendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    @Override
    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL14.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    @Override
    public void glDepthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    @Override
    public void glDepthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    @Override
    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glClear(int mask) {
        GL11.glClear((int)mask);
    }

    @Override
    public void glClearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public int glGetError() {
        return GL11.glGetError();
    }

    @Override
    public void glMatrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    @Override
    public void glLoadMatrixf(FloatBuffer m) {
        GL11.glLoadMatrix((FloatBuffer)m);
    }

    @Override
    public int glGetInteger(int pname) {
        return GL11.glGetInteger((int)pname);
    }

    @Override
    public void glGetIntegerv(int pname, int[] params) {
        IntBuffer buf = MemoryUtilities.memAllocInt((int)params.length);
        GL11.glGetInteger((int)pname, (IntBuffer)buf);
        buf.get(params);
        MemoryUtilities.memFree((IntBuffer)buf);
    }

    @Override
    public boolean glGetBoolean(int pname) {
        return GL11.glGetBoolean((int)pname);
    }

    @Override
    public String glGetString(int pname) {
        return GL11.glGetString((int)pname);
    }

    @Override
    public int glGetAttribLocation(int program, CharSequence name) {
        return GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    @Override
    public MemoryStack stackPush() {
        return new LWJGL2MemoryStack(com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack.stackPush());
    }

    @Override
    public long nmemAlloc(long size) {
        return MemoryUtilities.nmemAlloc((long)size);
    }

    @Override
    public long nmemCalloc(long count, long size) {
        return MemoryUtilities.nmemCalloc((long)count, (long)size);
    }

    @Override
    public long nmemAlignedAlloc(long alignment, long size) {
        int required = 8;
        long prefixLength = Math.max(alignment = Math.max(alignment, 8L), (long)required) + (long)required;
        long capacity = size + prefixLength;
        long addr = MemoryUtilities.nmemAlloc((long)capacity);
        if (addr == 0L) {
            return 0L;
        }
        long shiftBy = alignment - addr % alignment;
        if (shiftBy < (long)required) {
            shiftBy += alignment;
        }
        long finalAddr = addr + shiftBy;
        MemoryUtilities.memPutLong((long)(finalAddr - 8L), (long)addr);
        return finalAddr;
    }

    @Override
    public long nmemRealloc(long ptr, long size) {
        return MemoryUtilities.nmemRealloc((long)ptr, (long)size);
    }

    @Override
    public void nmemFree(long ptr) {
        MemoryUtilities.nmemFree((long)ptr);
    }

    @Override
    public void nmemAlignedFree(long ptr) {
        if (ptr == 0L) {
            return;
        }
        long realAddr = MemoryUtilities.memGetLong((long)(ptr - 8L));
        MemoryUtilities.nmemFree((long)realAddr);
    }

    @Override
    public ByteBuffer memAlloc(int size) {
        return MemoryUtilities.memAlloc((int)size);
    }

    @Override
    public ByteBuffer memCalloc(int size) {
        return MemoryUtilities.memCalloc((int)size);
    }

    @Override
    public ByteBuffer memRealloc(ByteBuffer buffer, int size) {
        return MemoryUtilities.memRealloc((ByteBuffer)buffer, (int)size);
    }

    @Override
    public void memFree(Buffer buffer) {
        MemoryUtilities.memFree((Buffer)buffer);
    }

    @Override
    public ByteBuffer memByteBuffer(long address, int capacity) {
        return MemoryUtilities.memByteBuffer((long)address, (int)capacity);
    }

    @Override
    public long memAddress(Buffer buffer) {
        return MemoryUtilities.memAddress((Buffer)buffer);
    }

    @Override
    public long memAddress(Buffer buffer, int position) {
        if (buffer == null) {
            return position;
        }
        return MemoryUtilities.memAddress0((Buffer)buffer) + (long)position;
    }

    @Override
    public void memSet(long address, int value, long bytes) {
        MemoryUtilities.memSet((long)address, (int)value, (long)bytes);
    }

    @Override
    public void memCopy(long src, long dst, long bytes) {
        MemoryUtilities.memCopy((long)src, (long)dst, (long)bytes);
    }

    @Override
    public void memPutByte(long address, byte value) {
        MemoryUtilities.memPutByte((long)address, (byte)value);
    }

    @Override
    public void memPutShort(long address, short value) {
        MemoryUtilities.memPutShort((long)address, (short)value);
    }

    @Override
    public void memPutInt(long address, int value) {
        MemoryUtilities.memPutInt((long)address, (int)value);
    }

    @Override
    public void memPutFloat(long address, float value) {
        MemoryUtilities.memPutFloat((long)address, (float)value);
    }

    @Override
    public void memPutLong(long address, long value) {
        MemoryUtilities.memPutLong((long)address, (long)value);
    }

    @Override
    public void memPutAddress(long address, long value) {
        MemoryUtilities.memPutAddress((long)address, (long)value);
    }

    @Override
    public byte memGetByte(long address) {
        return MemoryUtilities.memGetByte((long)address);
    }

    @Override
    public short memGetShort(long address) {
        return MemoryUtilities.memGetShort((long)address);
    }

    @Override
    public int memGetInt(long address) {
        return MemoryUtilities.memGetInt((long)address);
    }

    @Override
    public float memGetFloat(long address) {
        return MemoryUtilities.memGetFloat((long)address);
    }

    @Override
    public long memGetLong(long address) {
        return MemoryUtilities.memGetLong((long)address);
    }

    @Override
    public long memGetAddress(long address) {
        return MemoryUtilities.memGetAddress((long)address);
    }

    @Override
    public ByteBuffer memSlice(ByteBuffer buffer, int offset, int capacity) {
        long address = MemoryUtilities.memAddress((ByteBuffer)buffer) + (long)offset;
        return MemoryUtilities.memByteBuffer((long)address, (int)capacity);
    }

    private static enum VAOMode {
        CORE,
        ARB,
        APPLE,
        NONE;

    }

    private static enum TimerQueryMode {
        CORE,
        ARB,
        NONE;

    }

    private static enum DebugMode {
        KHR,
        NONE;

    }

    private static enum VertexAttribIMode {
        CORE,
        EXT,
        NONE;

    }
}

