/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.lwjgl.lwjgl2;

import com.mitchej123.lwjgl.DebugExtension;
import com.mitchej123.lwjgl.DebugMessageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

final class LWJGL2DebugSupport {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/LWJGL2Debug");
    private KHRDebugCallback debugCallbackKHR;
    private ARBDebugOutputCallback debugCallbackARB;
    private AMDDebugOutputCallback debugCallbackAMD;

    LWJGL2DebugSupport() {
    }

    int setupDebugCallback(final DebugMessageHandler handler) {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (caps.OpenGL43) {
            LOGGER.info("Using OpenGL 4.3 for debug output");
            this.debugCallbackKHR = new KHRDebugCallback(new KHRDebugCallback.Handler(){

                public void handleMessage(int source, int type, int id, int severity, String message) {
                    handler.handle(source, type, id, severity, message, DebugExtension.GL43);
                }
            });
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)false);
            KHRDebug.glDebugMessageCallback((KHRDebugCallback)this.debugCallbackKHR);
            if ((GL11.glGetInteger((int)33310) & 2) == 0) {
                LOGGER.warn("Non-debug context may not produce debug output");
                GL11.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_KHR_debug) {
            LOGGER.info("Using KHR_debug for debug output");
            this.debugCallbackKHR = new KHRDebugCallback(new KHRDebugCallback.Handler(){

                public void handleMessage(int source, int type, int id, int severity, String message) {
                    handler.handle(source, type, id, severity, message, DebugExtension.KHR_DEBUG);
                }
            });
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)false);
            KHRDebug.glDebugMessageCallback((KHRDebugCallback)this.debugCallbackKHR);
            if (caps.OpenGL30 && (GL11.glGetInteger((int)33310) & 2) == 0) {
                LOGGER.warn("Non-debug context may not produce debug output");
                GL11.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_ARB_debug_output) {
            LOGGER.info("Using ARB_debug_output for debug output");
            this.debugCallbackARB = new ARBDebugOutputCallback(new ARBDebugOutputCallback.Handler(){

                public void handleMessage(int source, int type, int id, int severity, String message) {
                    handler.handle(source, type, id, severity, message, DebugExtension.ARB_DEBUG_OUTPUT);
                }
            });
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)this.debugCallbackARB);
            return 1;
        }
        if (caps.GL_AMD_debug_output) {
            LOGGER.info("Using AMD_debug_output for debug output");
            this.debugCallbackAMD = new AMDDebugOutputCallback(new AMDDebugOutputCallback.Handler(){

                public void handleMessage(int id, int category, int severity, String message) {
                    handler.handle(category, 0, id, severity, message, DebugExtension.AMD_DEBUG_OUTPUT);
                }
            });
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((AMDDebugOutputCallback)this.debugCallbackAMD);
            return 1;
        }
        LOGGER.info("No debug output implementation available");
        return 0;
    }

    void disableDebugCallback() {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (caps.OpenGL43 || caps.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null);
            if (caps.OpenGL30 && (GL11.glGetInteger((int)33310) & 2) == 0) {
                GL11.glDisable((int)37600);
            }
        } else if (caps.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null);
        } else if (caps.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null);
        }
        this.debugCallbackKHR = null;
        this.debugCallbackARB = null;
        this.debugCallbackAMD = null;
    }
}

