/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.lwjgl;

import com.mitchej123.lwjgl.LWJGLService;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LWJGLServiceProvider {
    private static final Logger LOGGER = LogManager.getLogger((String)"Celeritas/LWJGLService");
    public static final LWJGLService LWJGL = LWJGLServiceProvider.loadService();
    public static final int POINTER_SIZE = LWJGL.getPointerSize();
    public static final long NULL = 0L;

    private LWJGLServiceProvider() {
    }

    private static LWJGLService loadService() {
        ServiceLoader<LWJGLService> loader = ServiceLoader.load(LWJGLService.class, LWJGLService.class.getClassLoader());
        Object best = null;
        Iterator<LWJGLService> iterator = loader.iterator();
        int attempts = 0;
        while (attempts < 16) {
            try {
                ++attempts;
                if (!iterator.hasNext()) break;
                LWJGLService service = iterator.next();
                LOGGER.info("Found LWJGLService: {} (priority {})", new Object[]{service.getClass().getName(), service.getPriority()});
                if (best != null && service.getPriority() <= best.getPriority()) continue;
                best = service;
            }
            catch (LinkageError | ServiceConfigurationError e) {
                LOGGER.debug("Skipping unavailable service: {}", new Object[]{e.getMessage()});
            }
        }
        if (best != null) {
            LOGGER.info("Using LWJGLService: {} (priority {})", new Object[]{best.getClass().getName(), best.getPriority()});
            return best;
        }
        throw new IllegalStateException("No LWJGLService implementation found.");
    }
}

