/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.glsm.impl;

import com.mitchej123.glsm.RenderSystemService;
import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class PassThroughRenderSystem
implements RenderSystemService {
    private static boolean isCompatibilityProfile = false;
    private static boolean profileInitialized = false;
    private final int[] shaderTextures = new int[16];
    private final float[] shaderColor = new float[4];
    private final float[] shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float shaderFogStart = 0.0f;
    private float shaderFogEnd = 0.0f;
    private int fogShape = 0;
    private float shaderLineWidth = 1.0f;
    private final FloatBuffer PROJECTION_MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private final Matrix4f PROJECTION_MATRIX = new Matrix4f();

    public static void initializeProfileDetection() {
        if (profileInitialized) {
            return;
        }
        boolean hasGL31 = LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(3, 1);
        boolean hasGL32 = LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(3, 2);
        isCompatibilityProfile = hasGL32 || hasGL31 ? LWJGLServiceProvider.LWJGL.isExtensionSupported(GLExtension.ARB_compatibility) : true;
        profileInitialized = true;
    }

    public static boolean isCompatibilityProfile() {
        if (!profileInitialized) {
            throw new IllegalStateException("Profile detection not initialized. Call initializeProfileDetection() first.");
        }
        return isCompatibilityProfile;
    }

    @Override
    public void glActiveTexture(int texture) {
        LWJGLServiceProvider.LWJGL.glActiveTexture(texture);
    }

    @Override
    public void enableCullFace() {
        LWJGLServiceProvider.LWJGL.glEnable(2884);
    }

    @Override
    public void disableCullFace() {
        LWJGLServiceProvider.LWJGL.glDisable(2884);
    }

    @Override
    public void enableBlend() {
        LWJGLServiceProvider.LWJGL.glEnable(3042);
    }

    @Override
    public void disableBlend() {
        LWJGLServiceProvider.LWJGL.glDisable(3042);
    }

    @Override
    public void setUnknownBlendState() {
    }

    @Override
    public void enableDepthTest() {
        LWJGLServiceProvider.LWJGL.glEnable(2929);
    }

    @Override
    public void disableDepthTest() {
        LWJGLServiceProvider.LWJGL.glDisable(2929);
    }

    @Override
    public void depthFunc(int depthFunc) {
        LWJGLServiceProvider.LWJGL.glDepthFunc(depthFunc);
    }

    @Override
    public void depthMask(boolean flag) {
        LWJGLServiceProvider.LWJGL.glDepthMask(flag);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        LWJGLServiceProvider.LWJGL.glViewport(x, y, width, height);
    }

    @Override
    public void bindTexture(int texture) {
        LWJGLServiceProvider.LWJGL.glBindTexture(3553, texture);
    }

    @Override
    public void glUniform1i(int location, int value) {
        LWJGLServiceProvider.LWJGL.glUniform1i(location, value);
    }

    @Override
    public void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        LWJGLServiceProvider.LWJGL.glUniformMatrix3fv(location, transpose, value);
    }

    @Override
    public void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        LWJGLServiceProvider.LWJGL.glUniformMatrix4fv(location, transpose, value);
    }

    @Override
    public void glClearColor(float red, float green, float blue, float alpha) {
        LWJGLServiceProvider.LWJGL.glClearColor(red, green, blue, alpha);
    }

    @Override
    public void clear(int mask, boolean checkError) {
        int error;
        LWJGLServiceProvider.LWJGL.glClear(mask);
        if (checkError && (error = LWJGLServiceProvider.LWJGL.glGetError()) != 0) {
            throw new RuntimeException(PassThroughRenderSystem.jvmdowngrader$concat$clear$1(error));
        }
    }

    @Override
    public void assertOnRenderThread() {
    }

    @Override
    public void assertOnRenderThreadOrInit() {
    }

    @Override
    public void setShaderTexture(int shaderTexture, int textureId) {
        if (shaderTexture >= 0 && shaderTexture < this.shaderTextures.length) {
            this.shaderTextures[shaderTexture] = textureId;
        }
    }

    @Override
    public int getShaderTexture(int shaderTexture) {
        if (shaderTexture >= 0 && shaderTexture < this.shaderTextures.length) {
            return this.shaderTextures[shaderTexture];
        }
        return 0;
    }

    @Override
    public void setShaderColor(float red, float green, float blue, float alpha) {
        this.shaderColor[0] = red;
        this.shaderColor[1] = green;
        this.shaderColor[2] = blue;
        this.shaderColor[3] = alpha;
    }

    @Override
    public float[] getShaderColor() {
        return this.shaderColor;
    }

    @Override
    public void setShaderFogColor(float red, float green, float blue, float alpha) {
        this.shaderFogColor[0] = red;
        this.shaderFogColor[1] = green;
        this.shaderFogColor[2] = blue;
        this.shaderFogColor[3] = alpha;
    }

    @Override
    public void setShaderFogStart(float start) {
        this.shaderFogStart = start;
    }

    @Override
    public void setShaderFogEnd(float end) {
        this.shaderFogEnd = end;
    }

    @Override
    public void setFogShape(int shape) {
        this.fogShape = shape;
    }

    @Override
    public float[] getShaderFogColor() {
        return this.shaderFogColor;
    }

    @Override
    public float getShaderFogStart() {
        return this.shaderFogStart;
    }

    @Override
    public float getShaderFogEnd() {
        return this.shaderFogEnd;
    }

    @Override
    public int getFogShape() {
        return this.fogShape;
    }

    @Override
    public void setShaderLineWidth(float lineWidth) {
        this.shaderLineWidth = lineWidth;
    }

    @Override
    public float getShaderLineWidth() {
        return this.shaderLineWidth;
    }

    @Override
    public Matrix4f getProjectionMatrix() {
        return new Matrix4f((Matrix4fc)this.PROJECTION_MATRIX);
    }

    @Override
    public void setProjectionMatrixOrth(Matrix4f projectionMatrix) {
        this.PROJECTION_MATRIX.set((Matrix4fc)projectionMatrix);
        if (PassThroughRenderSystem.isCompatibilityProfile()) {
            LWJGLServiceProvider.LWJGL.glMatrixMode(5889);
            projectionMatrix.get(0, this.PROJECTION_MATRIX_BUFFER);
            LWJGLServiceProvider.LWJGL.glLoadMatrixf(this.PROJECTION_MATRIX_BUFFER);
            LWJGLServiceProvider.LWJGL.glMatrixMode(5888);
        }
    }

    @Override
    public void setProjectionMatrixOrigin(Matrix4f projectionMatrix) {
        this.PROJECTION_MATRIX.set((Matrix4fc)projectionMatrix);
        if (PassThroughRenderSystem.isCompatibilityProfile()) {
            LWJGLServiceProvider.LWJGL.glMatrixMode(5889);
            projectionMatrix.get(0, this.PROJECTION_MATRIX_BUFFER);
            LWJGLServiceProvider.LWJGL.glLoadMatrixf(this.PROJECTION_MATRIX_BUFFER);
            LWJGLServiceProvider.LWJGL.glMatrixMode(5888);
        }
    }

    @Override
    public void defaultBlendFunc() {
        LWJGLServiceProvider.LWJGL.glBlendFunc(770, 771);
    }

    @Override
    public void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        LWJGLServiceProvider.LWJGL.glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    private static /* synthetic */ String jvmdowngrader$concat$clear$1(int n) {
        return "OpenGL Error: " + n;
    }
}

