/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.utils;

import com.gtnewhorizons.angelica.rendering.RenderThreadContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;

public class ConcurrentTileEntityMap
implements Map<ChunkPosition, TileEntity> {
    private final Object2ObjectOpenHashMap<ChunkPosition, TileEntity> delegate = new Object2ObjectOpenHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentLinkedQueue<ChunkPosition> invalidationQueue = new ConcurrentLinkedQueue();

    public void queueInvalidation(ChunkPosition pos) {
        this.invalidationQueue.add(pos);
    }

    private void processInvalidationQueue() {
        ChunkPosition pos;
        while ((pos = this.invalidationQueue.poll()) != null) {
            TileEntity te = (TileEntity)this.delegate.get((Object)pos);
            if (te == null || !te.func_145837_r()) continue;
            this.delegate.remove((Object)pos);
        }
    }

    public void withReadLock(Runnable action) {
        this.lock.readLock().lock();
        try {
            action.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void withWriteLock(Runnable action) {
        this.lock.writeLock().lock();
        try {
            action.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object2ObjectOpenHashMap<ChunkPosition, TileEntity> getDelegate() {
        return this.delegate;
    }

    public TileEntity putDirect(ChunkPosition key, TileEntity value) {
        return (TileEntity)this.delegate.put((Object)key, (Object)value);
    }

    private static boolean isRenderWorkerThread() {
        return RenderThreadContext.hasWorldSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TileEntity get(Object key) {
        if (!ConcurrentTileEntityMap.isRenderWorkerThread()) {
            return (TileEntity)this.delegate.get(key);
        }
        this.lock.readLock().lock();
        try {
            TileEntity te = (TileEntity)this.delegate.get(key);
            if (te != null && te.func_145837_r()) {
                if (key instanceof ChunkPosition) {
                    ChunkPosition pos = (ChunkPosition)key;
                    this.invalidationQueue.add(pos);
                }
                TileEntity tileEntity = null;
                return tileEntity;
            }
            TileEntity tileEntity = te;
            return tileEntity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TileEntity put(ChunkPosition key, TileEntity value) {
        this.lock.writeLock().lock();
        try {
            this.processInvalidationQueue();
            TileEntity tileEntity = (TileEntity)this.delegate.put((Object)key, (Object)value);
            return tileEntity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TileEntity remove(Object key) {
        if (ConcurrentTileEntityMap.isRenderWorkerThread()) {
            if (key instanceof ChunkPosition) {
                ChunkPosition pos = (ChunkPosition)key;
                this.invalidationQueue.add(pos);
            }
            return null;
        }
        this.lock.writeLock().lock();
        try {
            this.processInvalidationQueue();
            TileEntity tileEntity = (TileEntity)this.delegate.remove(key);
            return tileEntity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void putAll(Map<? extends ChunkPosition, ? extends TileEntity> m) {
        this.lock.writeLock().lock();
        try {
            this.processInvalidationQueue();
            this.delegate.putAll(m);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.invalidationQueue.clear();
            this.delegate.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        if (!ConcurrentTileEntityMap.isRenderWorkerThread()) {
            return this.delegate.size();
        }
        this.lock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        if (!ConcurrentTileEntityMap.isRenderWorkerThread()) {
            return this.delegate.isEmpty();
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (!ConcurrentTileEntityMap.isRenderWorkerThread()) {
            return this.delegate.containsKey(key);
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (!ConcurrentTileEntityMap.isRenderWorkerThread()) {
            return this.delegate.containsValue(value);
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsValue(value);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<ChunkPosition> keySet() {
        if (ConcurrentTileEntityMap.isRenderWorkerThread()) {
            throw new IllegalStateException("keySet() called from render worker. Use withReadLock() for iteration.");
        }
        return this.delegate.keySet();
    }

    @Override
    public Collection<TileEntity> values() {
        if (ConcurrentTileEntityMap.isRenderWorkerThread()) {
            throw new IllegalStateException("values() called from render worker. Use withReadLock() for iteration.");
        }
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<ChunkPosition, TileEntity>> entrySet() {
        if (ConcurrentTileEntityMap.isRenderWorkerThread()) {
            throw new IllegalStateException("entrySet() called from render worker. Use withReadLock() for iteration.");
        }
        return this.delegate.entrySet();
    }
}

