/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.taumc.glsl;

import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonToken;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.ParserRuleContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.RuleContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Token;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTreeWalker;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.BuiltinFunction;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.InjectorPoint;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Main;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ShaderParser;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.TransformerCollector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.TransformerRemover;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Transformer {
    private final GLSLParser.Translation_unitContext root;
    final Collection<ParserRuleContext>[] cachedContexts;
    final Map<String, Collection<ParserRuleContext>>[] cachedContextsByText;
    public GLSLParser.External_declarationContext variable = null;
    public GLSLParser.External_declarationContext function = null;
    private final ArrayDeque<ParseTree> nodeStack = new ArrayDeque();

    private <T extends ParserRuleContext> Collection<T> getContextsForRule(int ruleIndex) {
        return ruleIndex >= 0 && ruleIndex < this.cachedContexts.length ? this.cachedContexts[ruleIndex] : Collections.emptyList();
    }

    private Map<String, Collection<ParserRuleContext>> buildCacheForRuleIndex(int ruleIndex) {
        Collection contexts = this.getContextsForRule(ruleIndex);
        HashMap<String, Collection<ParserRuleContext>> map = new HashMap<String, Collection<ParserRuleContext>>();
        for (ParserRuleContext ctx : contexts) {
            Collection coll = map.computeIfAbsent(ctx.getText(), k -> Collections.newSetFromMap(new IdentityHashMap()));
            coll.add(ctx);
        }
        this.cachedContextsByText[ruleIndex] = map;
        return map;
    }

    private <T extends ParserRuleContext> Collection<T> getCachedContextsByText(int ruleIndex, String text) {
        Collection<ParserRuleContext> collection;
        Map<String, Collection<ParserRuleContext>> cacheByText = this.cachedContextsByText[ruleIndex];
        if (cacheByText == null) {
            cacheByText = this.buildCacheForRuleIndex(ruleIndex);
        }
        return (collection = cacheByText.get(text)) != null ? collection : Collections.emptySet();
    }

    public Transformer(GLSLParser.Translation_unitContext root) {
        this.root = root;
        this.cachedContexts = new Collection[GLSLParser.ruleNames.length];
        for (int i = 0; i < this.cachedContexts.length; ++i) {
            this.cachedContexts[i] = new LinkedHashSet<ParserRuleContext>();
        }
        this.cachedContextsByText = new Map[GLSLParser.ruleNames.length];
        ParseTreeWalker.DEFAULT.walk(new TransformerCollector(this), root);
    }

    public void injectVariable(String code) {
        Collection functionDefinitions;
        ParserRuleContext parserRuleContext;
        Collection storageQualifiers;
        GLSLParser.External_declarationContext insert = ShaderParser.parseSnippet(code, GLSLParser::external_declaration);
        if (this.variable == null && !(storageQualifiers = this.getContextsForRule(35)).isEmpty()) {
            ParserRuleContext parent = ((ParserRuleContext)storageQualifiers.iterator().next()).getParent();
            while (!(parent instanceof GLSLParser.External_declarationContext) && parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (parent instanceof GLSLParser.External_declarationContext) {
                GLSLParser.External_declarationContext list;
                this.variable = list = (GLSLParser.External_declarationContext)parent;
            }
        }
        if (this.variable == null && (parserRuleContext = ((ParserRuleContext)(functionDefinitions = this.getContextsForRule(68)).iterator().next()).getParent()) instanceof GLSLParser.External_declarationContext) {
            GLSLParser.External_declarationContext list;
            this.variable = list = (GLSLParser.External_declarationContext)parserRuleContext;
        }
        if (this.variable != null) {
            ParserRuleContext parent = this.variable.getParent();
            int i = parent.children.indexOf(this.variable);
            parent.children.add(i, insert);
            insert.setParent(parent);
            this.scanNode(insert);
            ParseTreeWalker.DEFAULT.walk(new InjectorPoint(this, false), insert);
        }
    }

    public void injectFunction(String code) {
        ParserRuleContext parserRuleContext;
        Collection functionDefinitions;
        GLSLParser.External_declarationContext insert = ShaderParser.parseSnippet(code, GLSLParser::external_declaration);
        if (this.function == null && !(functionDefinitions = this.getContextsForRule(68)).isEmpty() && (parserRuleContext = ((ParserRuleContext)functionDefinitions.iterator().next()).getParent()) instanceof GLSLParser.External_declarationContext) {
            GLSLParser.External_declarationContext list;
            this.function = list = (GLSLParser.External_declarationContext)parserRuleContext;
        }
        ParserRuleContext parent = this.function != null ? this.function.getParent() : this.root;
        int i = parent.children.indexOf(this.function);
        parent.children.add(i, insert);
        insert.setParent(parent);
        this.scanNode(insert);
        ParseTreeWalker.DEFAULT.walk(new InjectorPoint(this, true), insert);
    }

    public void injectAtEnd(String code) {
        GLSLParser.External_declarationContext insert = ShaderParser.parseSnippet(code, GLSLParser::external_declaration);
        this.root.children.add(insert);
        this.scanNode(insert);
    }

    public void rename(String oldName, String newName) {
        this.rename(Collections.singletonMap(oldName, newName));
    }

    public void rename(Map<String, String> names) {
        ArrayList nodes = new ArrayList();
        Collection typelessDeclarations = this.getContextsForRule(25);
        Collection functionPrototypes = this.getContextsForRule(18);
        Collection variableIdentifiers = this.getContextsForRule(1);
        nodes.addAll(typelessDeclarations.stream().map(GLSLParser.Typeless_declarationContext::IDENTIFIER).collect(Collectors.toList()));
        nodes.addAll(variableIdentifiers.stream().map(GLSLParser.Variable_identifierContext::IDENTIFIER).collect(Collectors.toList()));
        nodes.addAll(functionPrototypes.stream().map(GLSLParser.Function_prototypeContext::IDENTIFIER).collect(Collectors.toList()));
        for (TerminalNode node : nodes) {
            CommonToken cToken;
            String replacement;
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken) || (replacement = names.get((cToken = (CommonToken)token).getText())) == null) continue;
            cToken.setText(replacement);
        }
    }

    @Deprecated
    public void replaceExpression(String oldCode, String newCode) {
        this.replaceExpression(oldCode, newCode, GLSLParser::binary_expression);
        this.replaceExpression(oldCode, newCode, GLSLParser::postfix_expression);
    }

    private boolean textEqual(RuleContext ctx, String text) {
        int currentIndex = 0;
        ArrayDeque<ParseTree> stack = this.nodeStack;
        stack.add(ctx);
        boolean matches = true;
        while (!stack.isEmpty()) {
            ParseTree node = stack.removeLast();
            if (node.getChildCount() == 0) {
                String nodeText = node.getText();
                if (!text.regionMatches(currentIndex, nodeText, 0, nodeText.length())) {
                    matches = false;
                    break;
                }
                currentIndex += nodeText.length();
                continue;
            }
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                stack.add(node.getChild(i));
            }
        }
        stack.clear();
        return matches && currentIndex == text.length();
    }

    public <T extends ParserRuleContext> void replaceExpression(String oldCode, String newCode, Function<GLSLParser, T> expressionType) {
        ParserRuleContext oldExpression = (ParserRuleContext)ShaderParser.parseSnippet(oldCode, expressionType);
        String oldText = oldExpression.getText();
        ArrayList<T> exprList = new ArrayList<T>(this.getCachedContextsByText(oldExpression.getRuleIndex(), oldText));
        for (ParserRuleContext ctx : exprList) {
            this.replaceNode(ctx, (ParserRuleContext)ShaderParser.parseSnippet(newCode, expressionType));
        }
    }

    private void replaceNode(ParserRuleContext oldNode, ParserRuleContext newNode) {
        this.scanNode(newNode);
        newNode.parent = oldNode.getParent();
        int i = oldNode.getParent().children.indexOf(oldNode);
        oldNode.getParent().children.set(i, newNode);
        this.removeNode(oldNode);
    }

    private void removeNode(ParserRuleContext node) {
        TransformerRemover remover = new TransformerRemover(this);
        ParseTreeWalker.DEFAULT.walk(remover, node);
        remover.performRemovals();
    }

    private void scanNode(ParserRuleContext node) {
        ParseTreeWalker.DEFAULT.walk(new TransformerCollector(this), node);
    }

    public void prependMain(String code) {
        GLSLParser.StatementContext insert = ShaderParser.parseSnippet(code, GLSLParser::statement);
        Collection functionDefinitions = this.getContextsForRule(68);
        for (GLSLParser.Function_definitionContext ctx : functionDefinitions) {
            if (!ctx.function_prototype().IDENTIFIER().getText().equals("main")) continue;
            ctx.compound_statement_no_new_scope().statement_list().children.add(0, insert);
            this.scanNode(insert);
        }
    }

    public void removeVariable(String code) {
        Object token;
        ParserRuleContext typeless = null;
        Collection typelessDeclaration = this.getContextsForRule(25);
        for (GLSLParser.Typeless_declarationContext ctx : typelessDeclaration) {
            CommonToken cToken;
            if (ctx.IDENTIFIER() == null || !((token = ctx.IDENTIFIER().getSymbol()) instanceof CommonToken) || !code.equals((cToken = (CommonToken)token).getText())) continue;
            if (ctx.getParent() instanceof GLSLParser.Single_declarationContext) {
                ParserRuleContext parserRuleContext = ctx.getParent().getParent();
                if (!(parserRuleContext instanceof GLSLParser.Init_declarator_listContext)) continue;
                GLSLParser.Init_declarator_listContext list = (GLSLParser.Init_declarator_listContext)parserRuleContext;
                if (!list.typeless_declaration().isEmpty()) {
                    GLSLParser.Typeless_declarationContext entry = list.typeless_declaration(0);
                    cToken.setText(entry.getText());
                    typeless = entry;
                    break;
                }
                typeless = ctx;
                continue;
            }
            if (!(ctx.getParent() instanceof GLSLParser.Init_declarator_listContext)) continue;
            typeless = ctx;
            break;
        }
        if (typeless == null) {
            return;
        }
        token = typeless.getParent();
        if (token instanceof GLSLParser.Init_declarator_listContext) {
            ParserRuleContext context;
            GLSLParser.Init_declarator_listContext listContext = (GLSLParser.Init_declarator_listContext)token;
            int i = listContext.children.indexOf(typeless);
            Object e = listContext.children.remove(i - 1);
            if (e instanceof ParserRuleContext) {
                context = (ParserRuleContext)e;
                this.removeNode(context);
            }
            if ((e = listContext.children.remove(i - 1)) instanceof ParserRuleContext) {
                context = (ParserRuleContext)e;
                this.removeNode(context);
            }
        } else {
            RuleContext i = typeless.parent;
            if (i instanceof GLSLParser.Single_declarationContext) {
                GLSLParser.Single_declarationContext singleContext = (GLSLParser.Single_declarationContext)i;
                ParserRuleContext node = singleContext.getParent().getParent().getParent();
                node.getParent().children.remove(node);
                this.removeNode(node);
            }
        }
    }

    public int findType(String code) {
        Collection singleDeclarations = this.getContextsForRule(24);
        for (GLSLParser.Single_declarationContext ctx : singleDeclarations) {
            TerminalNode node;
            Token token;
            ParseTree parseTree;
            CommonToken cToken;
            if (ctx.typeless_declaration() == null) continue;
            Object object = ctx.typeless_declaration().IDENTIFIER().getSymbol();
            if (object instanceof CommonToken && (cToken = (CommonToken)object).getText().equals(code) && (parseTree = ctx.fully_specified_type().type_specifier().type_specifier_nonarray().getChild(0)) instanceof TerminalNode && (token = (node = (TerminalNode)parseTree).getSymbol()) instanceof CommonToken) {
                CommonToken t = (CommonToken)token;
                return t.getType();
            }
            object = ctx.getParent();
            if (!(object instanceof GLSLParser.Init_declarator_listContext)) continue;
            GLSLParser.Init_declarator_listContext listContext = (GLSLParser.Init_declarator_listContext)object;
            for (GLSLParser.Typeless_declarationContext entry : listContext.typeless_declaration()) {
                TerminalNode node2;
                Token token2;
                ParseTree parseTree2;
                CommonToken cToken2;
                Token token3 = entry.IDENTIFIER().getSymbol();
                if (!(token3 instanceof CommonToken) || !(cToken2 = (CommonToken)token3).getText().equals(code) || !((parseTree2 = ctx.fully_specified_type().type_specifier().type_specifier_nonarray().getChild(0)) instanceof TerminalNode) || !((token2 = (node2 = (TerminalNode)parseTree2).getSymbol()) instanceof CommonToken)) continue;
                CommonToken t = (CommonToken)token2;
                return t.getType();
            }
        }
        return 0;
    }

    public void appendMain(String code) {
        GLSLParser.StatementContext insert = ShaderParser.parseSnippet(code, GLSLParser::statement);
        Collection functionDefinitions = this.getContextsForRule(68);
        for (GLSLParser.Function_definitionContext ctx : functionDefinitions) {
            if (!ctx.function_prototype().IDENTIFIER().getText().equals("main")) continue;
            ctx.compound_statement_no_new_scope().statement_list().children.add(insert);
            this.scanNode(insert);
        }
    }

    public boolean containsCall(String name) {
        Collection variableIdentifiers = this.getContextsForRule(1);
        for (GLSLParser.Variable_identifierContext ctx : variableIdentifiers) {
            CommonToken cToken;
            Token token = ctx.IDENTIFIER().getSymbol();
            if (!(token instanceof CommonToken) || !(cToken = (CommonToken)token).getText().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariable(String name) {
        ArrayList nodes = new ArrayList();
        Collection typelessDeclarations = this.getContextsForRule(25);
        Collection functionPrototypes = this.getContextsForRule(18);
        nodes.addAll(typelessDeclarations.stream().map(GLSLParser.Typeless_declarationContext::IDENTIFIER).collect(Collectors.toList()));
        nodes.addAll(functionPrototypes.stream().map(GLSLParser.Function_prototypeContext::IDENTIFIER).collect(Collectors.toList()));
        for (TerminalNode node : nodes) {
            CommonToken cToken;
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken) || !name.equals((cToken = (CommonToken)token).getText())) continue;
            return true;
        }
        return false;
    }

    public void renameArray(String oldName, String newName, Set<Integer> found) {
        this.renameArray(Collections.singletonMap(oldName, newName), found);
    }

    public void renameArray(Map<String, String> replacements, Set<Integer> found) {
        Collection postfixExpressions = this.getContextsForRule(3);
        for (GLSLParser.Postfix_expressionContext ctx : postfixExpressions) {
            CommonToken cToken;
            String replacement;
            Token token;
            if (ctx.postfix_expression() == null || ctx.postfix_expression().primary_expression() == null || ctx.postfix_expression().primary_expression().variable_identifier() == null || !((token = ctx.postfix_expression().primary_expression().variable_identifier().IDENTIFIER().getSymbol()) instanceof CommonToken) || (replacement = replacements.get((cToken = (CommonToken)token).getText())) == null || ctx.integer_expression() == null) continue;
            String i = ctx.integer_expression().getText();
            found.add(Integer.parseInt(i));
            cToken.setText(replacement + i);
            ctx.removeLastChild();
            ctx.removeLastChild();
            ctx.removeLastChild();
        }
    }

    public void mutateTree(Consumer<GLSLParser.Translation_unitContext> contextConsumer) {
        contextConsumer.accept(this.root);
    }

    public void renameFunctionCall(String oldName, String newName) {
        this.renameFunctionCall(Collections.singletonMap(oldName, newName));
    }

    public void renameFunctionCall(Map<String, String> names) {
        ArrayList nodes = new ArrayList();
        Collection functionPrototypes = this.getContextsForRule(18);
        Collection variableIdentifiers = this.getContextsForRule(1);
        Collection nonArraySpecifiers = this.getContextsForRule(41);
        nodes.addAll(functionPrototypes.stream().map(GLSLParser.Function_prototypeContext::IDENTIFIER).collect(Collectors.toList()));
        nodes.addAll(variableIdentifiers.stream().map(GLSLParser.Variable_identifierContext::IDENTIFIER).collect(Collectors.toList()));
        nodes.addAll(nonArraySpecifiers.stream().map(c -> {
            if (c.TEXTURE2D() != null) {
                return c.TEXTURE2D();
            }
            return c.TEXTURE3D();
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        for (TerminalNode node : nodes) {
            CommonToken cToken;
            String replacement;
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken) || (replacement = names.get((cToken = (CommonToken)token).getText())) == null) continue;
            cToken.setText(replacement);
        }
    }

    public void renameAndWrapShadow(String oldName, String newName) {
        ArrayList postfixExpressions = new ArrayList(this.getContextsForRule(3));
        for (GLSLParser.Postfix_expressionContext expr : postfixExpressions) {
            if (expr.function_call_parameters() == null) continue;
            String function = expr.getText();
            if (expr.function_call_parameters() == null || !function.startsWith(oldName + "(")) continue;
            function = "vec4(" + function + ")";
            GLSLParser.Postfix_expressionContext def = ShaderParser.parseSnippet(function, GLSLParser::postfix_expression);
            this.replaceNode(expr, def);
        }
        this.renameFunctionCall(oldName, newName);
    }

    public void removeFunction(String name) {
        Collection functionPrototypes = this.getContextsForRule(18);
        ArrayList functionPrototype = new ArrayList(functionPrototypes);
        for (GLSLParser.Function_prototypeContext ctx : functionPrototype) {
            ParserRuleContext parserRuleContext;
            if (!ctx.IDENTIFIER().getText().equals(name) || !((parserRuleContext = ctx.getParent().getParent()) instanceof GLSLParser.External_declarationContext)) continue;
            GLSLParser.External_declarationContext declarationContext = (GLSLParser.External_declarationContext)parserRuleContext;
            declarationContext.getParent().children.remove(declarationContext);
            this.removeNode(declarationContext);
        }
    }

    public void removeUnusedFunctions() {
        Collection functionPrototypes = this.getContextsForRule(18);
        Collection variableIdentifiers = this.getContextsForRule(1);
        List result = functionPrototypes.stream().map(c -> c.IDENTIFIER().getText()).collect(Collectors.toList());
        List usedIdentifiers = variableIdentifiers.stream().map(c -> c.IDENTIFIER().getText()).collect(Collectors.toList());
        List functionsToRemove = result.stream().filter(name -> !usedIdentifiers.contains(name) && !name.equals("main")).collect(Collectors.toList());
        for (String name2 : functionsToRemove) {
            this.removeFunction(name2);
        }
    }

    public Map<String, List<String>> findConstParameter() {
        HashMap<String, List<String>> functions = new HashMap<String, List<String>>();
        Collection parameterDeclarations = this.getContextsForRule(21);
        for (GLSLParser.Parameter_declarationContext ctx : parameterDeclarations) {
            ParserRuleContext parserRuleContext;
            GLSLParser.Storage_qualifierContext storageQualifierContext;
            GLSLParser.Single_type_qualifierContext singleTypeQualifierContext;
            GLSLParser.Type_qualifierContext typeQualifierContext = ctx.type_qualifier();
            if (typeQualifierContext == null || (singleTypeQualifierContext = typeQualifierContext.single_type_qualifier(0)) == null || (storageQualifierContext = singleTypeQualifierContext.storage_qualifier()) == null || storageQualifierContext.CONST() == null || !((parserRuleContext = ctx.getParent().getParent()) instanceof GLSLParser.Function_prototypeContext)) continue;
            GLSLParser.Function_prototypeContext proto = (GLSLParser.Function_prototypeContext)parserRuleContext;
            if (functions.containsKey(proto.IDENTIFIER().getText())) {
                ((List)functions.get(proto.IDENTIFIER().getText())).add(ctx.parameter_declarator().IDENTIFIER().getText());
                continue;
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(ctx.parameter_declarator().IDENTIFIER().getText());
            functions.put(proto.IDENTIFIER().getText(), params);
        }
        return functions;
    }

    public void removeConstAssignment(Map<String, List<String>> functions) {
        Collection variableIdentifiers = this.getContextsForRule(1);
        for (Map.Entry<String, List<String>> entry : functions.entrySet()) {
            for (GLSLParser.Variable_identifierContext ctx : variableIdentifiers) {
                ParserRuleContext parent;
                block6: {
                    block5: {
                        if (!entry.getValue().contains(ctx.IDENTIFIER().getText())) continue;
                        parent = ctx.getParent();
                        do {
                            if (parent instanceof GLSLParser.Function_definitionContext) break block5;
                        } while ((parent = parent.getParent()) != null);
                        return;
                    }
                    GLSLParser.Function_definitionContext definitionContext = (GLSLParser.Function_definitionContext)parent;
                    if (!definitionContext.function_prototype().IDENTIFIER().getText().equals(entry.getKey())) continue;
                    parent = ctx.getParent();
                    do {
                        if (parent instanceof GLSLParser.Single_declarationContext) break block6;
                    } while ((parent = parent.getParent()) != null);
                    return;
                }
                GLSLParser.Single_declarationContext declarationContext = (GLSLParser.Single_declarationContext)parent;
                entry.getValue().add(declarationContext.typeless_declaration().IDENTIFIER().getText());
                GLSLParser.Type_qualifierContext typeQualifierContext = declarationContext.fully_specified_type().type_qualifier();
                if (typeQualifierContext == null || typeQualifierContext.single_type_qualifier(0) == null) {
                    return;
                }
                GLSLParser.Storage_qualifierContext storageQualifierContext = typeQualifierContext.single_type_qualifier(0).storage_qualifier();
                if (storageQualifierContext == null || storageQualifierContext.CONST() == null) continue;
                declarationContext.fully_specified_type().children.remove(typeQualifierContext);
                this.removeNode(typeQualifierContext);
            }
        }
    }

    public void removeConstAssignment() {
        Map<String, List<String>> functions = this.findConstParameter();
        this.removeConstAssignment(functions);
    }

    public void initialize(GLSLParser.Single_declarationContext declarationContext, String name) {
        TerminalNode node;
        Object object = declarationContext.fully_specified_type().type_specifier().type_specifier_nonarray().getChild(0);
        if (object instanceof TerminalNode && (object = (node = (TerminalNode)object).getSymbol()) instanceof CommonToken) {
            CommonToken token = (CommonToken)object;
            String insert = name + " = " + BuiltinFunction.getByType(token.getType()).getInitializer() + ";";
            this.prependMain(insert);
        }
    }

    public void makeOutDeclaration(GLSLParser.Single_declarationContext inDeclarationContext, String name) {
        String insert = Main.getFormattedShader(inDeclarationContext.fully_specified_type()) + name + ";";
        insert = insert.replaceFirst("in", "out");
        this.injectVariable(insert);
    }

    public Map<String, GLSLParser.Single_declarationContext> findQualifiers(int type) {
        HashMap<String, GLSLParser.Single_declarationContext> nodes = new HashMap<String, GLSLParser.Single_declarationContext>();
        Collection storageQualifiers = this.getContextsForRule(35);
        for (GLSLParser.Storage_qualifierContext ctx : storageQualifiers) {
            GLSLParser.Init_declarator_listContext listContext;
            ParseTree parent;
            block3: {
                CommonToken token;
                TerminalNode node;
                Object object = ctx.children.get(0);
                if (!(object instanceof TerminalNode) || !((object = (node = (TerminalNode)object).getSymbol()) instanceof CommonToken) || (token = (CommonToken)object).getType() != type) continue;
                parent = node.getParent();
                do {
                    if (parent instanceof GLSLParser.Single_declarationContext) break block3;
                } while ((parent = parent.getParent()) != null);
                continue;
            }
            GLSLParser.Single_declarationContext declarationContext = (GLSLParser.Single_declarationContext)parent;
            nodes.put(declarationContext.typeless_declaration().IDENTIFIER().getText(), declarationContext);
            ParserRuleContext parserRuleContext = declarationContext.getParent();
            if (!(parserRuleContext instanceof GLSLParser.Init_declarator_listContext) || (listContext = (GLSLParser.Init_declarator_listContext)parserRuleContext).typeless_declaration() == null) continue;
            for (GLSLParser.Typeless_declarationContext entry : listContext.typeless_declaration()) {
                nodes.put(entry.IDENTIFIER().getText(), declarationContext);
            }
        }
        return nodes;
    }

    public boolean hasAssigment(String name) {
        Collection assignmentExpressions = this.getContextsForRule(11);
        for (GLSLParser.Assignment_expressionContext ctx : assignmentExpressions) {
            if (ctx.unary_expression() == null || !ctx.unary_expression().getText().startsWith(name) && !ctx.unary_expression().getText().startsWith(name + ".")) continue;
            return true;
        }
        return false;
    }

    public void rewriteStructArrays() {
        Collection structDeclarations = this.getContextsForRule(45);
        for (GLSLParser.Struct_declarationContext ctx : structDeclarations) {
            if (ctx.type_specifier().array_specifier() == null) continue;
            GLSLParser.Array_specifierContext array_specifier = ctx.type_specifier().array_specifier();
            if (array_specifier.dimension().get(0).constant_expression() != null) {
                return;
            }
            ctx.type_specifier().children.remove(array_specifier);
            for (GLSLParser.Struct_declaratorContext entry : ctx.struct_declarator_list().struct_declarator()) {
                array_specifier.setParent(entry);
                entry.children.add(array_specifier);
            }
        }
    }

    public List<TerminalNode> collectStorage() {
        Collection storageQualifiers = this.getContextsForRule(35);
        return storageQualifiers.stream().filter(ctx -> ctx.getChild(0) instanceof TerminalNode).map(ctx -> (TerminalNode)ctx.getChild(0)).collect(Collectors.toList());
    }
}

