/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.taumc.glsl;

import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.CppReader;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Preprocessor;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.BufferedTokenStream;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CharStreams;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonTokenStream;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ShaderViewerGUI;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Transformer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLLexer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLPreParser;
import java.io.File;
import java.util.HashSet;

public class Main {
    public static String tab = "";

    public static void main(String[] args) throws Exception {
        GLSLLexer lexer = new GLSLLexer(CharStreams.fromReader(new CppReader(new Preprocessor(new File("test.glsl")))));
        GLSLParser parser = new GLSLParser(new CommonTokenStream(lexer));
        GLSLPreParser preParser = new GLSLPreParser(new BufferedTokenStream(lexer));
        System.out.println(Main.getFormattedShader(preParser.translation_unit()));
        parser.setBuildParseTree(true);
        GLSLParser.Translation_unitContext translationUnit = parser.translation_unit();
        Transformer transformer = new Transformer(translationUnit);
        transformer.injectVariable("in ivec2 a_LightCoord2;");
        transformer.rename("a_Color", "rewritten_Color");
        HashSet<Integer> found = new HashSet<Integer>();
        transformer.renameArray("test", "replaced", found);
        transformer.removeVariable("testing");
        transformer.removeConstAssignment();
        transformer.renameFunctionCall("_vert_init", "newCall");
        transformer.renameAndWrapShadow("function", "wrapped");
        transformer.prependMain("injected = 5;");
        transformer.replaceExpression("vartest", "unint(5)");
        transformer.removeUnusedFunctions();
        transformer.rewriteStructArrays();
        transformer.renameFunctionCall("texture2D", "texture");
        transformer.replaceExpression("gl_TextureMatrix[0]", "mat4(1.0f)");
        System.out.println(Main.getFormattedShader(translationUnit));
        ShaderViewerGUI.display(parser, translationUnit);
    }

    public static String getFormattedShader(ParseTree tree) {
        StringBuilder sb = new StringBuilder();
        Main.getFormattedShader(tree, sb);
        return sb.toString();
    }

    private static void getFormattedShader(ParseTree tree, StringBuilder stringBuilder) {
        if (tree instanceof TerminalNode) {
            String text = tree.getText();
            stringBuilder.append(text);
            if (text.equals("{")) {
                stringBuilder.append(" \n\t");
                tab = "\t";
            }
            if (text.equals("}")) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 2);
                tab = "";
            }
            stringBuilder.append(text.equals(";") ? " \n" + tab : " ");
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                Main.getFormattedShader(tree.getChild(i), stringBuilder);
            }
        }
    }
}

