/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas.threading;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizons.angelica.rendering.AngelicaBlockSafetyRegistry;
import com.gtnewhorizons.angelica.rendering.RenderThreadContext;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuildContext;
import com.gtnewhorizons.angelica.rendering.celeritas.AngelicaChunkBuilderMeshingTask;
import com.gtnewhorizons.angelica.rendering.celeritas.SmoothBiomeColorCache;
import com.gtnewhorizons.angelica.rendering.celeritas.WorldClientExtension;
import com.gtnewhorizons.angelica.rendering.celeritas.threading.RenderPassHelper;
import com.gtnewhorizons.angelica.rendering.celeritas.world.WorldSlice;
import com.gtnewhorizons.angelica.rendering.celeritas.world.cloned.ChunkRenderContext;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.util.position.SectionPos;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class ThreadedAngelicaChunkBuilderMeshingTask
extends AngelicaChunkBuilderMeshingTask {
    private static final int MAX_VANILLA_RENDER_TYPE = 41;
    @Nullable
    private final ChunkRenderContext renderContext;
    private IBlockAccess blockAccess;
    private SmoothBiomeColorCache biomeColorCache;
    private boolean enteredLocalMode;

    public ThreadedAngelicaChunkBuilderMeshingTask(RenderSection render, @Nullable ChunkRenderContext renderContext, int time, Vector3d camera) {
        super(render, time, camera);
        this.renderContext = renderContext;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext context, CancellationToken cancellationToken) {
        AngelicaChunkBuildContext buildContext = (AngelicaChunkBuildContext)context;
        this.initBlockAccess(buildContext);
        return super.execute(context, cancellationToken);
    }

    private void initBlockAccess(AngelicaChunkBuildContext buildContext) {
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        if (this.renderContext != null) {
            WorldSlice worldSlice = buildContext.getWorldSlice();
            worldSlice.copyData(this.renderContext);
            this.blockAccess = worldSlice;
            this.biomeColorCache = worldSlice.getBiomeColorCache();
            buildContext.setupLightPipeline(minX, minY, minZ);
        } else {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            this.blockAccess = new ChunkCache((World)world, minX - 1, minY - 1, minZ - 1, minX + 17, minY + 17, minZ + 17, 1);
            this.biomeColorCache = ((WorldClientExtension)world).celeritas$getSmoothBiomeColorCache();
            this.biomeColorCache.update(new SectionPos(this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ()));
            buildContext.setupLightPipeline(this.blockAccess, minX, minY, minZ);
        }
    }

    @Override
    protected Tessellator getTessellator() {
        return Tessellator.field_78398_a;
    }

    @Override
    protected void setRenderPass(int pass) {
        RenderPassHelper.setWorldRenderPass(pass);
    }

    @Override
    protected IBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    @Override
    protected SmoothBiomeColorCache getBiomeColorCache() {
        return this.biomeColorCache;
    }

    @Override
    protected boolean isThreaded() {
        return this.enteredLocalMode;
    }

    @Override
    protected boolean canRenderOffThread(Block block) {
        int renderType = block.func_149645_b();
        return renderType >= 0 && renderType <= 41 || AngelicaBlockSafetyRegistry.canBlockRenderOffThread(block, true, true);
    }

    @Override
    protected void onEnterExecute() {
        boolean bl = this.enteredLocalMode = !TessellatorManager.isOnMainThread();
        if (this.enteredLocalMode) {
            TessellatorManager.enterLocalMode();
            IBlockAccess iBlockAccess = this.blockAccess;
            if (iBlockAccess instanceof WorldSlice) {
                WorldSlice worldSlice = (WorldSlice)iBlockAccess;
                RenderThreadContext.set(worldSlice);
            }
        }
    }

    @Override
    protected void onExitExecute() {
        if (this.enteredLocalMode) {
            RenderThreadContext.clear();
            RenderPassHelper.resetWorldRenderPass();
            TessellatorManager.exitLocalMode();
        }
    }

    @Override
    protected void addExtraCrashInfo(CrashReportCategory category) {
        category.func_71507_a("Thread", (Object)Thread.currentThread().getName());
    }
}

