/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas.threading;

import com.gtnewhorizons.angelica.rendering.celeritas.threading.ChunkTaskProvider;
import com.gtnewhorizons.angelica.rendering.celeritas.threading.DefaultChunkTaskProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkTaskRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkTaskRegistry");
    private static final List<ChunkTaskProvider> providers = new ArrayList<ChunkTaskProvider>();
    private static ChunkTaskProvider activeProvider;

    private ChunkTaskRegistry() {
    }

    public static synchronized void registerProvider(ChunkTaskProvider provider) {
        providers.add(provider);
        providers.sort(Comparator.comparingInt(ChunkTaskProvider::priority));
        activeProvider = null;
        LOGGER.info("Registered chunk task provider: {} (priority={})", new Object[]{provider.getClass().getSimpleName(), provider.priority()});
    }

    public static synchronized ChunkTaskProvider getActiveProvider() {
        for (ChunkTaskProvider provider : providers) {
            if (!provider.isEnabled()) continue;
            if (activeProvider != provider) {
                activeProvider = provider;
                LOGGER.info("Active chunk task provider: {} (threads={})", new Object[]{activeProvider.getClass().getSimpleName(), activeProvider.threadCount()});
            }
            return activeProvider;
        }
        if (activeProvider != DefaultChunkTaskProvider.INSTANCE) {
            activeProvider = DefaultChunkTaskProvider.INSTANCE;
            LOGGER.info("Active chunk task provider: single-threaded fallback");
        }
        return activeProvider;
    }

    public static synchronized void reset() {
        providers.clear();
        activeProvider = null;
    }
}

