/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering.celeritas.iris;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.BlockRenderContext;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.CeleritasQuadView;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.ContextAwareChunkVertexEncoder;
import com.gtnewhorizons.angelica.rendering.celeritas.iris.IrisExtendedChunkVertexType;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import lombok.Generated;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.block.Block;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.joml.Vector3f;

public class IrisExtendedChunkVertexEncoder
implements ContextAwareChunkVertexEncoder {
    private static final int MID_TEX_OFFSET = IrisExtendedChunkVertexType.VERTEX_FORMAT.getAttribute("mc_midTexCoord").getPointer();
    private static final int TANGENT_OFFSET = IrisExtendedChunkVertexType.VERTEX_FORMAT.getAttribute("at_tangent").getPointer();
    private static final int NORMAL_OFFSET = IrisExtendedChunkVertexType.VERTEX_FORMAT.getAttribute("iris_Normal").getPointer();
    private static final int MC_ENTITY_OFFSET = IrisExtendedChunkVertexType.VERTEX_FORMAT.getAttribute("mc_Entity").getPointer();
    private static final int MID_BLOCK_OFFSET = IrisExtendedChunkVertexType.VERTEX_FORMAT.getAttribute("at_midBlock").getPointer();
    private final ChunkVertexEncoder baseEncoder = IrisExtendedChunkVertexType.BASE_TYPE.createEncoder();
    private final CeleritasQuadView quad = new CeleritasQuadView();
    private final Vector3f normal = new Vector3f();
    private final Reference2ObjectMap<Block, Int2IntMap> blockMetaMatches = BlockRenderingSettings.INSTANCE.getBlockMetaMatches();
    private int vertexCount;
    private float uSum;
    private float vSum;
    private BlockRenderContext context;

    @Override
    public void prepareToRenderBlock(BlockRenderContext ctx, Block block, int metadata, short renderType, byte lightValue) {
        this.context = ctx;
        Int2IntMap metaMap = this.blockMetaMatches != null ? (Int2IntMap)this.blockMetaMatches.get((Object)block) : null;
        ctx.blockId = (short)(metaMap != null ? metaMap.get(metadata) : -1);
        ctx.renderType = renderType;
        ctx.lightValue = lightValue;
    }

    @Override
    public void prepareToRenderFluid(BlockRenderContext ctx, Block block, byte lightValue) {
        this.context = ctx;
        Int2IntMap metaMap = this.blockMetaMatches != null ? (Int2IntMap)this.blockMetaMatches.get((Object)block) : null;
        ctx.blockId = (short)(metaMap != null ? metaMap.get(0) : -1);
        ctx.renderType = 1;
        ctx.lightValue = lightValue;
    }

    @Override
    public void finishRenderingBlock() {
        if (this.context != null) {
            this.context.reset();
        }
    }

    @Override
    public long write(long ptr, Material material, ChunkVertexEncoder.Vertex vertex, int sectionIndex) {
        this.uSum += vertex.u;
        this.vSum += vertex.v;
        ++this.vertexCount;
        BlockRenderContext ctx = this.context;
        this.baseEncoder.write(ptr, material, vertex, sectionIndex);
        MemoryUtilities.memPutShort((long)(ptr + (long)MC_ENTITY_OFFSET + 2L), (short)ctx.renderType);
        int midBlock = ExtendedDataHelper.computeMidBlock(vertex.x, vertex.y, vertex.z, ctx.localPosX, ctx.localPosY, ctx.localPosZ);
        MemoryUtilities.memPutInt((long)(ptr + (long)MID_BLOCK_OFFSET), (int)midBlock);
        MemoryUtilities.memPutByte((long)(ptr + (long)MID_BLOCK_OFFSET + 3L), (byte)ctx.lightValue);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            float midU = this.uSum * 0.25f;
            float midV = this.vSum * 0.25f;
            int midUV = IrisExtendedChunkVertexType.encodeMidTexture(midU, midV);
            MemoryUtilities.memPutInt((long)(ptr + (long)MID_TEX_OFFSET), (int)midUV);
            MemoryUtilities.memPutInt((long)(ptr + (long)MID_TEX_OFFSET - 48L), (int)midUV);
            MemoryUtilities.memPutInt((long)(ptr + (long)MID_TEX_OFFSET - 96L), (int)midUV);
            MemoryUtilities.memPutInt((long)(ptr + (long)MID_TEX_OFFSET - 144L), (int)midUV);
            MemoryUtilities.memPutShort((long)(ptr + (long)MC_ENTITY_OFFSET), (short)ctx.blockId);
            MemoryUtilities.memPutShort((long)(ptr + (long)MC_ENTITY_OFFSET - 48L), (short)ctx.blockId);
            MemoryUtilities.memPutShort((long)(ptr + (long)MC_ENTITY_OFFSET - 96L), (short)ctx.blockId);
            MemoryUtilities.memPutShort((long)(ptr + (long)MC_ENTITY_OFFSET - 144L), (short)ctx.blockId);
            this.quad.setup(ptr, 48);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormI8.pack(this.normal);
            MemoryUtilities.memPutInt((long)(ptr + (long)NORMAL_OFFSET), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(ptr + (long)NORMAL_OFFSET - 48L), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(ptr + (long)NORMAL_OFFSET - 96L), (int)packedNormal);
            MemoryUtilities.memPutInt((long)(ptr + (long)NORMAL_OFFSET - 144L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtilities.memPutInt((long)(ptr + (long)TANGENT_OFFSET), (int)tangent);
            MemoryUtilities.memPutInt((long)(ptr + (long)TANGENT_OFFSET - 48L), (int)tangent);
            MemoryUtilities.memPutInt((long)(ptr + (long)TANGENT_OFFSET - 96L), (int)tangent);
            MemoryUtilities.memPutInt((long)(ptr + (long)TANGENT_OFFSET - 144L), (int)tangent);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
        }
        return ptr + 48L;
    }

    @Generated
    public void setContext(BlockRenderContext context) {
        this.context = context;
    }
}

